/*
 * Decompiled with CFR 0.152.
 */
package fairino;

import fairino.FrLogLevel;
import fairino.FrLogType;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FRLog {
    private FrLogType curLogType = FrLogType.DIRECT;
    private FrLogLevel curLogLevel = FrLogLevel.INFO;
    private String logFileName = "";
    private String logFilePath = "";
    private List<String> logBuf = new ArrayList<String>();
    private List<String> asyncWriteBuf = new ArrayList<String>();
    private int maxLogBufCount = 100;
    private int checkLogFileSizeFlag = 0;
    private final int CHECKFILESIZE = 1000;
    private boolean writeLogAsyncFlag = false;
    Lock slockAsyncLog = new ReentrantLock();
    private final long MAXFILESIZE = 10000000L;
    private int logSaveDays = 10;
    private int logSaveFileNum = 10;

    public FRLog() {
        this.logFilePath = "";
        this.logFileName = this.GetNewLogFileName();
    }

    public FRLog(FrLogType logType, FrLogLevel logLevel, String filePath, int saveFileNum, int saveFileDays) {
        this.logFilePath = filePath;
        this.curLogType = logType;
        this.logSaveDays = saveFileDays;
        this.curLogLevel = logLevel;
        this.logSaveFileNum = saveFileNum;
        this.logFileName = this.GetNewLogFileName();
        if (logType == FrLogType.ASYNC) {
            this.writeLogAsyncFlag = true;
        }
    }

    public int SetLogLevel(FrLogLevel level) {
        this.curLogLevel = level;
        return 0;
    }

    public int LogInfo(String logStr) {
        if (this.curLogLevel.compareTo(FrLogLevel.INFO) > 0) {
            return 0;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = new Date(System.currentTimeMillis());
        String fullLogStr = "[INFO] [" + formatter.format(date) + "] " + logStr;
        this.LogWrite(fullLogStr);
        return 0;
    }

    public int LogWarn(String logStr) {
        if (this.curLogLevel.compareTo(FrLogLevel.WARN) > 0) {
            return 0;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = new Date(System.currentTimeMillis());
        String fullLogStr = "[WARN] [" + formatter.format(date) + "] " + logStr;
        this.LogWrite(fullLogStr);
        return 0;
    }

    public int LogError(String methodName, int linNum, String logStr) {
        if (this.curLogLevel.compareTo(FrLogLevel.ERROR) > 0) {
            return 0;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = new Date(System.currentTimeMillis());
        String fullLogStr = "[ERROR] [" + formatter.format(date) + "] [" + methodName + " " + linNum + "] " + logStr;
        this.LogWrite(fullLogStr);
        return 0;
    }

    public int LogError(String logStr) {
        if (this.curLogLevel.compareTo(FrLogLevel.ERROR) > 0) {
            return 0;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = new Date(System.currentTimeMillis());
        String fullLogStr = "[ERROR] [" + formatter.format(date) + "] " + logStr;
        this.LogWrite(fullLogStr);
        return 0;
    }

    public int LogDebug(String logStr) {
        if (this.curLogLevel.compareTo(FrLogLevel.DEBUG) > 0) {
            return 0;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = new Date(System.currentTimeMillis());
        String fullLogStr = "[DEBUG] [" + formatter.format(date) + "] " + logStr;
        this.LogWrite(fullLogStr);
        return 0;
    }

    private int LogWrite(String logStr) {
        File fileInfo;
        long logFileSize;
        System.out.println(logStr);
        ++this.checkLogFileSizeFlag;
        if (this.checkLogFileSizeFlag > 1000 && (logFileSize = (fileInfo = new File(this.logFileName)).length()) > 10000000L) {
            this.logFileName = this.GetNewLogFileName();
            this.checkLogFileSizeFlag = 0;
        }
        this.slockAsyncLog.lock();
        if (this.curLogType == FrLogType.DIRECT) {
            this.WriteLogDirect(logStr + "\n");
        } else if (this.curLogType == FrLogType.BUFFER) {
            this.WriteLogBuffer(logStr + "\n");
        } else if (this.curLogType == FrLogType.ASYNC) {
            this.WriteLogAsync(logStr + "\n");
        }
        this.slockAsyncLog.unlock();
        return 0;
    }

    private int WriteLogDirect(String logStr) {
        try {
            File file2 = new File(this.logFileName);
            if (!file2.exists()) {
                file2.createNewFile();
            }
            Files.write(Paths.get(this.logFileName, new String[0]), logStr.getBytes(), StandardOpenOption.APPEND);
        }
        catch (Throwable e) {
            System.out.println("write log file fail " + e.getMessage());
            return -1;
        }
        return 0;
    }

    private int WriteLogBuffer(String logStr) {
        this.logBuf.add(logStr);
        int curLogCount = this.logBuf.size();
        if (curLogCount > this.maxLogBufCount) {
            try {
                for (int i = 0; i < curLogCount; ++i) {
                    File file2 = new File(this.logFileName);
                    if (!file2.exists()) {
                        file2.createNewFile();
                    }
                    Files.write(Paths.get(this.logFileName, new String[0]), this.logBuf.get(i).getBytes(), StandardOpenOption.APPEND);
                }
            }
            catch (Throwable e) {
                System.out.println("write log file fail " + e.getMessage());
                return -1;
            }
            this.logBuf.clear();
        }
        return 0;
    }

    private int WriteLogAsync(String logStr) {
        this.logBuf.add(logStr);
        return 0;
    }

    private String GetNewLogFileName() {
        int logFileCount = 0;
        File file = new File(this.logFilePath);
        File[] files = file.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                long diff = f1.lastModified() - f2.lastModified();
                if (diff > 0L) {
                    return 1;
                }
                if (diff == 0L) {
                    return 0;
                }
                return -1;
            }

            @Override
            public boolean equals(Object obj) {
                return true;
            }
        });
        for (File file2 : files) {
            if (!file2.getName().contains("FrLog")) continue;
            ++logFileCount;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        if (logFileCount > this.logSaveFileNum) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -1 * this.logSaveDays);
            Date curTime = cal.getTime();
            for (File tmpFile : files) {
                try {
                    String fileDataStr = tmpFile.getName().substring(6, 25);
                    Date fileDate = formatter.parse(fileDataStr);
                    if (!fileDate.before(curTime) || logFileCount <= this.logSaveFileNum) continue;
                    tmpFile.delete();
                    --logFileCount;
                }
                catch (Throwable e) {
                    System.out.println("delete old log file fail  :  " + e.getMessage());
                }
            }
        }
        return this.logFilePath + "\\FrLog_" + formatter.format(Calendar.getInstance().getTime()) + ".log";
    }

    private void WriteLogAsyncThread() {
        try {
            while (this.writeLogAsyncFlag) {
                if (this.curLogType == FrLogType.ASYNC && !this.logBuf.isEmpty()) {
                    this.slockAsyncLog.lock();
                    this.asyncWriteBuf.addAll(this.logBuf);
                    this.logBuf.clear();
                    for (int i = 0; i < this.asyncWriteBuf.size(); ++i) {
                        File file2 = new File(this.logFileName);
                        if (!file2.exists()) {
                            file2.createNewFile();
                        }
                        Files.write(Paths.get(this.logFileName, new String[0]), this.asyncWriteBuf.get(i).getBytes(), StandardOpenOption.APPEND);
                    }
                    this.asyncWriteBuf.clear();
                    continue;
                }
                Thread.sleep(50L);
            }
        }
        catch (Throwable e) {
            System.out.println("async write log failed  :  " + e.getMessage());
        }
    }

    public int LogClose() {
        try {
            this.slockAsyncLog.lock();
            int curLogCount = this.logBuf.size();
            if (curLogCount > 0) {
                for (int i = 0; i < curLogCount; ++i) {
                    Files.write(Paths.get(this.logFileName, new String[0]), this.logBuf.get(i).getBytes(), StandardOpenOption.APPEND);
                }
                this.logBuf.clear();
            }
            this.slockAsyncLog.unlock();
            this.writeLogAsyncFlag = false;
        }
        catch (Throwable e) {
            System.out.println("log close failed  :  " + e.getMessage());
        }
        return 0;
    }
}

