/*
 * Decompiled with CFR 0.152.
 */
package fairino;

import fairino.FRLog;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;

public class TCPClient {
    private String ip;
    private int port;
    private Socket mSocket;
    private SocketAddress mSocketAddress;
    private OutputStream mOutputStream;
    private InputStream mInputStream;
    private boolean isConnected = false;
    private boolean comFlag = true;
    private boolean reconnEnable = true;
    private int reconnTimes = 100;
    private int curReconnTimes = 0;
    private int reconnPeriod = 200;
    private boolean reconnState = false;
    private FRLog log;

    public TCPClient(String ip, int port) {
        this.ip = ip;
        this.port = port;
    }

    public int SetReconnectParam(boolean enable, int times, int period) {
        try {
            this.reconnEnable = enable;
            this.reconnTimes = times;
            this.reconnPeriod = period;
        }
        finally {
            return 0;
        }
    }

    public boolean GetReconnState() {
        return this.reconnState;
    }

    private boolean ReConnect() {
        this.curReconnTimes = 0;
        this.reconnState = true;
        if (!this.reconnEnable) {
            this.reconnState = false;
            return false;
        }
        while (this.curReconnTimes < this.reconnTimes) {
            this.Close();
            if (this.Connect()) {
                if (this.log != null) {
                    this.log.LogInfo("SDK Disconnected from robot, try to reconnect robot success! ");
                }
                this.reconnState = false;
                return true;
            }
            ++this.curReconnTimes;
            if (this.log == null) continue;
            this.log.LogInfo("SDK Disconnected from robot, try to reconnect robot failed! " + this.curReconnTimes + " / " + this.reconnTimes);
        }
        this.reconnState = false;
        return false;
    }

    public boolean Connect() {
        try {
            this.mSocket = new Socket();
            this.mSocket.setKeepAlive(true);
            this.mSocketAddress = new InetSocketAddress(this.ip, this.port);
            this.mSocket.connect(this.mSocketAddress, this.reconnPeriod);
            this.mOutputStream = this.mSocket.getOutputStream();
            this.mInputStream = this.mSocket.getInputStream();
            this.mSocket.setTcpNoDelay(true);
            this.mSocket.setSoTimeout(this.reconnPeriod * 100);
            this.isConnected = true;
            return this.isConnected;
        }
        catch (Throwable e) {
            this.isConnected = false;
            return this.isConnected;
        }
    }

    public void Close() {
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
                this.mSocket = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.isConnected = false;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void Send(byte[] bOutArray) {
        try {
            this.mOutputStream.write(bOutArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int Send(String str) {
        try {
            byte[] bOutArray = str.getBytes();
            this.mOutputStream.write(bOutArray);
            return str.length();
        }
        catch (Throwable e) {
            System.out.println("send fail  " + e.getMessage());
            return -1;
        }
    }

    public int GetPkg(byte[] buf, int recvSize) {
        int totalRecvSize = 0;
        int tmpRecvSize = 0;
        byte[] tmpBuf = new byte[1024];
        try {
            if (this.mInputStream == null) {
                System.out.println("mInputStream is null ");
                return -1;
            }
            while (recvSize > totalRecvSize) {
                Arrays.fill(tmpBuf, (byte)0);
                tmpRecvSize = this.mInputStream.read(tmpBuf, 0, recvSize - totalRecvSize);
                if (tmpRecvSize <= 0) {
                    return -1;
                }
                System.arraycopy(tmpBuf, 0, buf, totalRecvSize, tmpRecvSize);
                if (recvSize != (totalRecvSize += tmpRecvSize) || buf[0] != 90 || buf[1] != 90) continue;
                short len = 0;
                len = (short)(len | (short)buf[4]);
                len = (short)(len << 8);
                short tmp = 0;
                tmp = buf[3] < 0 ? (short)((short)buf[3] + 256) : (short)buf[3];
                if ((len = (short)(len | tmp)) + 7 > recvSize) {
                    recvSize = len + 7;
                    continue;
                }
                if (len + 7 == recvSize) {
                    short checksum = 0;
                    short checkdata = 0;
                    short tmpL = 0;
                    short tmpH = buf[recvSize - 1] < 0 ? (short)((short)buf[recvSize - 1] + 256) : (short)buf[recvSize - 1];
                    tmpL = buf[recvSize - 2] < 0 ? (short)((short)buf[recvSize - 2] + 256) : (short)buf[recvSize - 2];
                    checkdata = (short)(checkdata | tmpH);
                    checkdata = (short)(checkdata << 8);
                    checkdata = (short)(checkdata | tmpL);
                    for (int j = 0; j < recvSize - 2; ++j) {
                        short tmp1 = 0;
                        tmp1 = buf[j] < 0 ? (short)((short)buf[j] + 256) : (short)buf[j];
                        checksum = (short)(checksum + tmp1);
                    }
                    if (checksum == checkdata) {
                        return 0;
                    }
                    System.out.println("error check sum" + checkdata + "    " + checksum + "   " + Integer.toBinaryString(checkdata) + "  " + Integer.toBinaryString(checksum));
                    return -2;
                }
                System.out.println("error SDK version");
                return -3;
            }
        }
        catch (Throwable e) {
            System.out.println("get pkg exception " + e.getMessage());
            if (this.ReConnect()) {
                return 0;
            }
            return -1;
        }
        return -1;
    }

    public int Recv11(byte[] buffer) {
        try {
            if (this.mInputStream == null) {
                return -1;
            }
            int available = this.mInputStream.available();
            if (available > 0) {
                return this.mInputStream.read(buffer);
            }
            return -1;
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
            return -1;
        }
    }

    public int Recv(byte[] buffer) {
        try {
            if (this.mInputStream == null) {
                return -1;
            }
            return this.mInputStream.read(buffer);
        }
        catch (Throwable e) {
            System.out.println(e.getMessage());
            return -1;
        }
    }

    public void SetLog(FRLog logger) {
        this.log = logger;
    }
}

