/*
 * Decompiled with CFR 0.152.
 */
package fairino;

import fairino.AxleComParam;
import fairino.DescOffset;
import fairino.DescPose;
import fairino.DeviceConfig;
import fairino.ExaxisPos;
import fairino.ForceTorque;
import fairino.FrLogLevel;
import fairino.FrLogType;
import fairino.JointPos;
import fairino.ROBOT_STATE_PKG;
import fairino.Robot;
import fairino.UDPComParam;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;

public class Main {
    public static void main(String[] args) throws InterruptedException {
        Robot robot = new Robot();
        robot.SetReconnectParam(true, 100, 500);
        robot.LoggerInit(FrLogType.DIRECT, FrLogLevel.INFO, "D://log", 10, 10);
        int rtn = robot.RPC("192.168.58.2");
        if (rtn != 0) {
            System.out.println("rpc\u8fde\u63a5 fail");
            return;
        }
        System.out.println("rpc\u8fde\u63a5 success");
        Main.TestWeaveChange(robot);
        robot.CloseRPC();
    }

    public static void ShutDownRobotOS(Robot robot) {
        int i;
        int rtn = 0;
        for (i = 0; i < 10; ++i) {
            System.out.println("DataPackageDownload start");
            rtn = robot.DataPackageDownload("D://zDOWN/");
            System.out.println("DataPackageDownload rtn is: " + rtn + "  times  :" + i);
        }
        for (i = 0; i < 10; ++i) {
            System.out.println("AllDataSourceDownload start");
            rtn = robot.AllDataSourceDownload("D://zDOWN/");
            System.out.println("AllDataSourceDownload rtn is: " + rtn + "  times  :" + i);
        }
        for (i = 0; i < 10; ++i) {
            System.out.println("RbLogDownload start");
            rtn = robot.RbLogDownload("D://zDOWN/");
            System.out.println("RbLogDownload rtn is: " + rtn + "  times  :" + i);
        }
    }

    public static void Trigger(Robot robot) {
        System.out.println("please input a number to trigger:");
        Scanner scanner = new Scanner(System.in);
        int i = scanner.nextInt();
        System.out.println(i);
        int rtn = robot.ConveyorComDetectTrigger();
        System.out.println("ConveyorComDetectTrigger retval is: " + rtn);
        scanner.close();
    }

    public static int ConveyorTest(Robot robot) {
        int retval = 0;
        retval = 0;
        boolean index = true;
        int max_time = 30000;
        boolean block = false;
        retval = 0;
        DescPose startdescPose = new DescPose(139.176, 4.717, 9.088, -179.999, -0.004, -179.99);
        JointPos startjointPos = new JointPos(-34.129, -88.062, 97.839, -99.78, -90.003, -34.14);
        DescPose homePose = new DescPose(139.177, 4.717, 69.084, -180.0, -0.004, -179.989);
        JointPos homejointPos = new JointPos(-34.129, -88.618, 84.039, -85.423, -90.003, -34.14);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        retval = robot.MoveL(homejointPos, homePose, 1, 1, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        System.out.println("MoveL to safety retval is: " + retval);
        Thread triggerThread = new Thread(() -> Main.Trigger(robot));
        triggerThread.setDaemon(true);
        triggerThread.start();
        retval = robot.ConveyorComDetect(10000);
        System.out.println("ConveyorComDetect retval is: " + retval);
        retval = robot.ConveyorGetTrackData(2);
        System.out.println("ConveyorGetTrackData retval is: " + retval);
        retval = robot.ConveyorTrackStart(2);
        System.out.println("ConveyorTrackStart retval is: " + retval);
        robot.MoveL(startjointPos, startdescPose, 1, 1, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        robot.MoveL(startjointPos, startdescPose, 1, 1, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        retval = robot.ConveyorTrackEnd();
        System.out.println("ConveyorTrackEnd retval is: " + retval);
        robot.MoveL(homejointPos, homePose, 1, 1, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        return 0;
    }

    public static void TestInverseKen(Robot robot) {
        DescPose dcs1 = new DescPose(32.316, -232.029, 1063.415, 90.159, 18.376, 36.575);
        DescPose dcs2 = new DescPose(105.25, -170.914, 1076.283, 87.032, 25.94, 54.644);
        DescPose dcs3 = new DescPose(79.164, 81.645, 1045.609, 133.691, -73.265, 162.726);
        DescPose dcs4 = new DescPose(298.779, -104.112, 298.242, 179.631, -0.628, -166.481);
        JointPos inverseRtn = new JointPos(){};
        JointPos jpos1 = new JointPos(56.999, -59.002, 56.996, -96.552, 60.392, -90.005);
        DescPose forwordResult = new DescPose(){};
        robot.GetForwardKin(jpos1, forwordResult);
        System.out.println("jpos1 forwordResult rtn is " + forwordResult.tran.x + "," + forwordResult.tran.y + "," + forwordResult.tran.z + "," + forwordResult.rpy.rx + "," + forwordResult.rpy.ry + "," + forwordResult.rpy.rz);
    }

    public static void testSmooth(Robot robot) {
        JointPos JP1 = new JointPos(88.927, -85.834, 80.289, -85.561, -91.388, 108.718);
        DescPose DP1 = new DescPose(88.739, -527.617, 514.939, -179.039, 1.494, 70.209);
        JointPos JP2 = new JointPos(27.036, -83.909, 80.284, -85.579, -90.027, 108.604);
        DescPose DP2 = new DescPose(-433.125, -334.428, 497.139, -179.723, -0.745, 8.437);
        JointPos JP3 = new JointPos(60.219, -94.324, 62.906, -62.005, -87.159, 108.598);
        DescPose DP3 = new DescPose(-112.215, -409.323, 686.497, 176.217, 2.338, 41.625);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose p1Desc = new DescPose(228.879, -503.594, 453.984, -175.58, 8.293, 171.267);
        JointPos p1Joint = new JointPos(102.7, -85.333, 90.518, -102.365, -83.932, 22.134);
        DescPose p2Desc = new DescPose(-333.302, -435.58, 449.866, -174.997, 2.017, 109.815);
        JointPos p2Joint = new JointPos(41.862, -85.333, 90.526, -100.587, -90.014, 22.135);
        int error = robot.AccSmoothStart(false);
        System.out.println("AccSmoothStart return:" + error);
        robot.MoveL(p1Joint, p1Desc, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 10);
        robot.MoveL(p2Joint, p2Desc, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 10);
        error = robot.AccSmoothEnd(false);
    }

    public static void reconnect_test(Robot robot) {
        int rtn = -1;
        DescPose p1Desc = new DescPose(-423.723, -145.123, 546.173, -161.851, -29.236, 150.755);
        JointPos p1Joint = new JointPos(6.001, -103.515, 102.462, -122.922, -90.77, -59.761);
        DescPose p2Desc = new DescPose(-458.433, -678.096, 290.075, -176.815, -6.699, -161.689);
        JointPos p2Joint = new JointPos(48.905, -43.486, 53.364, -107.265, -90.655, -59.635);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        int i = 0;
        while (i < 1000) {
            rtn = -1;
            boolean flag = robot.isConnected();
            System.out.println("\u8fde\u63a5\u662f\u5426\u65ad\u5f00: " + flag);
            robot.Sleep(200);
        }
    }

    private static void TestTrajectoryLA(Robot robot) {
        int rtn = 0;
        String nameA = "/fruser/traj/testA.txt";
        String nameB = "/fruser/traj/B.txt";
        robot.TrajectoryJDelete("testA.txt");
        robot.TrajectoryJUpLoad("D://zUP/testA.txt");
        rtn = robot.LoadTrajectoryLA(nameA, 2, 0.0, 0, 1.0, 100.0, 200.0, 1000.0);
    }

    public static void CustomCollisionTest(Robot robot) {
        int[] safety = new int[]{5, 5, 5, 5, 5, 5};
        robot.SetCollisionStrategy(3, 1000, 150, 250, safety);
        double[] jointDetectionThreshould = new double[]{0.3, 0.3, 0.3, 0.3, 0.3, 0.3};
        double[] tcpDetectionThreshould = new double[]{60.0, 60.0, 60.0, 60.0, 60.0, 60.0};
        int rtn = robot.CustomCollisionDetectionStart(3, jointDetectionThreshould, tcpDetectionThreshould, 0);
        DescPose p1Desc = new DescPose(228.879, -503.594, 453.984, -175.58, 8.293, 171.267);
        JointPos p1Joint = new JointPos(102.7, -85.333, 90.518, -102.365, -83.932, 22.134);
        DescPose p2Desc = new DescPose(-333.302, -435.58, 449.866, -174.997, 2.017, 109.815);
        JointPos p2Joint = new JointPos(41.862, -85.333, 90.526, -100.587, -90.014, 22.135);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < 10; ++i) {
            robot.MoveL(p1Joint, p1Desc, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 10);
            robot.MoveL(p2Joint, p2Desc, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 10);
        }
        rtn = robot.CustomCollisionDetectionEnd();
    }

    private static void TestReWeld(Robot robot) {
        int rtn = -1;
        rtn = robot.WeldingSetCheckArcInterruptionParam(1, 200);
        System.out.println("WeldingSetCheckArcInterruptionParam: " + rtn);
        rtn = robot.WeldingSetReWeldAfterBreakOffParam(1, 5.7, 98.2, 0);
        System.out.println("WeldingSetReWeldAfterBreakOffParam: " + rtn);
        int enable = 0;
        double length = 0.0;
        double velocity = 0.0;
        int moveType = 0;
        int checkEnable = 0;
        int arcInterruptTimeLength = 0;
        List<Integer> rtnArray = new ArrayList<Integer>(){};
        List<Number> rtnArrayWeld = new ArrayList<Number>(){};
        rtnArray = robot.WeldingGetCheckArcInterruptionParam();
        checkEnable = rtnArray.get(1);
        arcInterruptTimeLength = rtnArray.get(2);
        System.out.println("WeldingGetCheckArcInterruptionParam  checkEnable:" + checkEnable + ", arcInterruptTimeLength : " + arcInterruptTimeLength);
        rtnArrayWeld = robot.WeldingGetReWeldAfterBreakOffParam();
        enable = (Integer)rtnArrayWeld.get(1);
        length = (Double)rtnArrayWeld.get(2);
        velocity = (Double)rtnArrayWeld.get(3);
        moveType = (Integer)rtnArrayWeld.get(4);
        System.out.println("WeldingGetReWeldAfterBreakOffParam :" + enable + ",length: " + length + ",velocity :" + velocity + ",moveType :" + moveType);
        robot.ProgramLoad("/fruser/test.lua");
        robot.ProgramRun();
        robot.Sleep(5000);
        while (true) {
            ROBOT_STATE_PKG pkg = new ROBOT_STATE_PKG();
            pkg = robot.GetRobotRealTimeState();
            System.out.println("welding breakoff state is " + pkg.weldingBreakOffstate.breakOffState);
            if (pkg.weldingBreakOffstate.breakOffState == 1) break;
            robot.Sleep(100);
        }
        System.out.println("welding breakoff !");
        robot.Sleep(2000);
        rtn = robot.WeldingStartReWeldAfterBreakOff();
        System.out.println("WeldingStartReWeldAfterBreakOff: " + rtn);
    }

    public static void TestTCP(Robot robot) {
        DescPose p1Desc = new DescPose(-394.073, -276.405, 399.451, -133.692, 7.657, -139.047);
        JointPos p1Joint = new JointPos(15.234, -88.178, 96.583, -68.314, -52.303, -122.926);
        DescPose p2Desc = new DescPose(-187.141, -444.908, 432.425, 148.662, 15.483, -90.637);
        JointPos p2Joint = new JointPos(61.796, -91.959, 101.693, -102.417, -124.511, -122.767);
        DescPose p3Desc = new DescPose(-368.695, -485.023, 426.64, -162.588, 31.433, -97.036);
        JointPos p3Joint = new JointPos(43.896, -64.59, 60.087, -50.269, -94.663, -122.652);
        DescPose p4Desc = new DescPose(-291.069, -376.976, 467.56, -179.272, -2.326, -107.757);
        JointPos p4Joint = new JointPos(39.559, -94.731, 96.307, -93.141, -88.131, -122.673);
        DescPose p5Desc = new DescPose(-284.14, -488.041, 478.579, 179.785, -1.396, -98.03);
        JointPos p5Joint = new JointPos(49.283, -82.423, 81.993, -90.861, -89.427, -122.678);
        DescPose p6Desc = new DescPose(-296.307, -385.991, 484.492, -178.637, -0.057, -107.059);
        JointPos p6Joint = new JointPos(40.141, -92.742, 91.41, -87.978, -88.824, -122.808);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        JointPos[] posJ = new JointPos[]{p1Joint, p2Joint, p3Joint, p4Joint, p5Joint, p6Joint};
        DescPose coordRtn = new DescPose();
        int rtn = robot.ComputeToolCoordWithPoints(0, posJ, coordRtn);
        System.out.println("ComputeToolCoordWithPoints :" + rtn + ",coord is:" + rtn + "," + coordRtn.tran.x + "," + coordRtn.tran.y + "," + coordRtn.tran.z + "," + coordRtn.rpy.rx + "," + coordRtn.rpy.ry + "," + coordRtn.rpy.rz);
        robot.MoveJ(p1Joint, p1Desc, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetTcp4RefPoint(1);
        robot.MoveJ(p2Joint, p2Desc, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetTcp4RefPoint(2);
        robot.MoveJ(p3Joint, p3Desc, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetTcp4RefPoint(3);
        robot.MoveJ(p4Joint, p4Desc, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetTcp4RefPoint(4);
        robot.ComputeTcp4(coordRtn);
        System.out.println("ComputeTcp4 : " + rtn + ", coord is: " + coordRtn.tran.x + "," + coordRtn.tran.y + "," + coordRtn.tran.z + "," + coordRtn.rpy.rx + "," + coordRtn.rpy.ry + "," + coordRtn.rpy.rz);
    }

    public static void TestArcWeldTraceChange(Robot robot) {
        DescPose p1Desc = new DescPose(-72.912, -587.664, 31.849, 43.283, -6.731, 15.068);
        JointPos p1Joint = new JointPos(74.62, -80.903, 94.608, -109.882, -90.436, -13.432);
        DescPose p2Desc = new DescPose(-104.915, -483.712, -25.231, 42.228, -6.572, 18.433);
        JointPos p2Joint = new JointPos(66.431, -92.875, 116.362, -120.516, -88.627, -24.731);
        DescPose p3Desc = new DescPose(-242.834, -498.697, -23.681, 46.576, -5.286, 8.318);
        JointPos p3Joint = new JointPos(57.153, -82.046, 104.06, -116.659, -92.478, -24.735);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.WeldingSetVoltage(1, 19.0, 0, 0);
        robot.WeldingSetCurrent(1, 190.0, 0, 0);
        robot.MoveJ(p1Joint, p1Desc, 1, 1, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.MoveL(p2Joint, p2Desc, 1, 1, 100.0, 100.0, 50.0, -1.0, exaxisPos, 0, 0, offdese, 0, 10);
        robot.ARCStart(1, 0, 10000);
        robot.ArcWeldTraceControl(1, 0.0, 1, 0.06, 5.0, 5.0, 60.0, 1, 0.06, 5.0, 5.0, 60.0, 0, 0, 4.0, 1.0, 10.0, 2, 2);
        robot.WeaveStart(0);
        robot.MoveL(p3Joint, p3Desc, 1, 1, 100.0, 100.0, 1.0, -1.0, exaxisPos, 0, 0, offdese, 0, 10);
        robot.WeaveEnd(0);
        robot.ArcWeldTraceControl(0, 0.0, 1, 0.06, 5.0, 5.0, 60.0, 1, 0.06, 5.0, 5.0, 60.0, 0, 0, 4.0, 1.0, 10.0, 2, 2);
        robot.ARCEnd(1, 0, 10000);
    }

    public static void TestWeaveChange(Robot robot) {
        DescPose p1Desc = new DescPose(119.177, -441.689, 141.839, 176.589, 0.429, -164.096);
        JointPos p1Joint = new JointPos(92.385, -85.428, 120.698, -121.854, -90.376, -13.519);
        DescPose p2Desc = new DescPose(-266.579, -405.885, 144.155, 178.329, -2.696, 149.434);
        JointPos p2Joint = new JointPos(45.845, -82.478, 117.685, -124.215, -93.014, -13.524);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.WeldingSetVoltage(0, 19.0, 0, 0);
        robot.WeldingSetCurrent(0, 190.0, 0, 0);
        robot.MoveJ(p2Joint, p2Desc, 1, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.WeaveStart(0);
        robot.WeaveChangeStart(1);
        robot.MoveL(p1Joint, p1Desc, 1, 0, 10.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 10);
        robot.WeaveChangeEnd();
        robot.WeaveEnd(0);
    }

    public static void TestTCP6(Robot robot) {
        DescPose p1Desc = new DescPose(-394.073, -276.405, 399.451, -133.692, 7.657, -139.047);
        JointPos p1Joint = new JointPos(15.234, -88.178, 96.583, -68.314, -52.303, -122.926);
        DescPose p2Desc = new DescPose(-187.141, -444.908, 432.425, 148.662, 15.483, -90.637);
        JointPos p2Joint = new JointPos(61.796, -91.959, 101.693, -102.417, -124.511, -122.767);
        DescPose p3Desc = new DescPose(-368.695, -485.023, 426.64, -162.588, 31.433, -97.036);
        JointPos p3Joint = new JointPos(43.896, -64.59, 60.087, -50.269, -94.663, -122.652);
        DescPose p4Desc = new DescPose(-291.069, -376.976, 467.56, -179.272, -2.326, -107.757);
        JointPos p4Joint = new JointPos(39.559, -94.731, 96.307, -93.141, -88.131, -122.673);
        DescPose p5Desc = new DescPose(-284.14, -488.041, 478.579, 179.785, -1.396, -98.03);
        JointPos p5Joint = new JointPos(49.283, -82.423, 81.993, -90.861, -89.427, -122.678);
        DescPose p6Desc = new DescPose(-296.307, -385.991, 484.492, -178.637, -0.057, -107.059);
        JointPos p6Joint = new JointPos(40.141, -92.742, 91.41, -87.978, -88.824, -122.808);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        JointPos[] posJ = new JointPos[]{p1Joint, p2Joint, p3Joint, p4Joint, p5Joint, p6Joint};
        DescPose coordRtn = new DescPose();
        int rtn = robot.ComputeToolCoordWithPoints(1, posJ, coordRtn);
        System.out.println("ComputeToolCoordWithPoints: " + rtn + ", coord is :" + coordRtn.tran.x + "," + coordRtn.tran.y + "," + coordRtn.tran.z + "," + coordRtn.rpy.rx + "," + coordRtn.rpy.ry + "," + coordRtn.rpy.rz);
        robot.MoveJ(p1Joint, p1Desc, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetToolPoint(1);
        robot.MoveJ(p2Joint, p2Desc, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetToolPoint(2);
        robot.MoveJ(p3Joint, p3Desc, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetToolPoint(3);
        robot.MoveJ(p4Joint, p4Desc, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetToolPoint(4);
        robot.MoveJ(p5Joint, p5Desc, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetToolPoint(5);
        robot.MoveJ(p6Joint, p6Desc, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetToolPoint(6);
        robot.ComputeTool(coordRtn);
        System.out.println("ComputeTool :" + rtn + ",coord is :" + coordRtn.tran.x + "," + coordRtn.tran.y + "," + coordRtn.tran.z + "," + coordRtn.rpy.rx + "," + coordRtn.rpy.ry + "," + coordRtn.rpy.rz);
    }

    public static void TestWObj(Robot robot) {
        DescPose p1Desc = new DescPose(-275.046, -293.122, 28.747, 174.533, -1.301, -112.101);
        JointPos p1Joint = new JointPos(35.207, -95.35, 133.703, -132.403, -93.897, -122.768);
        DescPose p2Desc = new DescPose(-280.339, -396.053, 29.762, 174.621, -3.448, -102.901);
        JointPos p2Joint = new JointPos(44.304, -85.02, 123.889, -134.679, -92.658, -122.768);
        DescPose p3Desc = new DescPose(-270.597, -290.603, 83.034, 179.314, 0.808, -114.171);
        JointPos p3Joint = new JointPos(32.975, -99.175, 125.966, -116.484, -91.014, -122.857);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose[] posTCP = new DescPose[]{p1Desc, p2Desc, p3Desc};
        DescPose coordRtn = new DescPose();
        int rtn = robot.ComputeWObjCoordWithPoints(0, posTCP, 0, coordRtn);
        System.out.println("ComputeToolCoordWithPoints :" + rtn + ",coord is :" + coordRtn.tran.x + "," + coordRtn.tran.y + "," + coordRtn.tran.z + "," + coordRtn.rpy.rx + "," + coordRtn.rpy.ry + "," + coordRtn.rpy.rz);
        robot.MoveJ(p1Joint, p1Desc, 1, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetWObjCoordPoint(1);
        robot.MoveJ(p2Joint, p2Desc, 1, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetWObjCoordPoint(2);
        robot.MoveJ(p3Joint, p3Desc, 1, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.SetWObjCoordPoint(3);
        robot.ComputeWObjCoord(0, 0, coordRtn);
        System.out.println("ComputeTool :" + rtn + "coord is :" + coordRtn.tran.x + "," + coordRtn.tran.y + "," + coordRtn.tran.z + "," + coordRtn.rpy.rx + "," + coordRtn.rpy.ry + "," + coordRtn.rpy.rz);
    }

    public static void ExtAxisLaserTracking(Robot robot) {
        DescPose p1Desc = new DescPose(381.07, -177.767, 227.851, 20.031, -2.455, -111.479);
        JointPos p1Joint = new JointPos(8.383, -44.801, -111.05, -97.707, 78.144, 27.709);
        DescPose p2Desc = new DescPose(381.077, -177.762, 217.865, 20.014, -0.131, -110.631);
        JointPos p2Joint = new JointPos(1.792, -44.574, -113.176, -93.687, 82.384, 21.154);
        DescPose p3Desc = new DescPose(381.07, -177.767, 227.851, 20.031, -2.455, -111.479);
        JointPos p3Joint = new JointPos(8.383, -44.801, -111.05, -97.707, 78.144, 27.709);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        ExaxisPos exaxisPosStart = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        robot.MoveJ(p1Joint, p1Desc, 8, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.ExtAxisMove(exaxisPosStart, 50.0);
        robot.MoveL(p2Joint, p2Desc, 8, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 10);
        robot.LaserSensorRecord(4, 1, 10, 2, 35.0, 0.1, 100.0);
        ExaxisPos exaxisPosTarget = new ExaxisPos(0.0, 400.015, 0.0, 0.0);
        robot.ExtAxisMove(exaxisPosTarget, 10.0);
        robot.LaserSensorRecord(0, 1, 10, 2, 35.0, 0.1, 100.0);
        robot.MoveJ(p3Joint, p3Desc, 8, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        robot.ExtAxisMove(exaxisPosStart, 50.0);
    }

    private static void TestWeave(Robot robot) {
        DescPose desc_p1 = new DescPose(-299.979, -399.974, 74.979, 0.009, 0.001, -41.53);
        DescPose desc_p2 = new DescPose(-49.985, -399.956, 74.978, 0.009, 0.005, -41.53);
        JointPos j1 = new JointPos(41.476, -77.3, 118.714, -131.405, -90.002, -51.993);
        JointPos j2 = new JointPos(68.366, -89.562, 133.018, -133.446, -90.002, -25.105);
        ExaxisPos epos = new ExaxisPos();
        DescPose offset_pos = new DescPose();
        robot.WeaveSetPara(0, 4, 2.0, 0, 10.0, 0.0, 0.0, 0, 0, 0, 0, 0, 60.0);
        robot.MoveJ(j1, desc_p1, 13, 0, 100.0, 100.0, 100.0, epos, -1.0, 0, offset_pos);
        robot.WeaveStart(0);
        robot.MoveL(j2, desc_p2, 13, 0, 10.0, 100.0, 100.0, -1.0, epos, 0, 0, offset_pos, 0, 100);
        robot.WeaveEnd(0);
        robot.WeaveSetPara(0, 0, 1.0, 0, 10.0, 0.0, 0.0, 0, 0, 0, 0, 0, 30.0);
        robot.MoveJ(j1, desc_p1, 13, 0, 100.0, 100.0, 100.0, epos, -1.0, 0, offset_pos);
        robot.WeaveStart(0);
        robot.MoveL(j2, desc_p2, 13, 0, 10.0, 100.0, 100.0, -1.0, epos, 0, 0, offset_pos, 0, 100);
        robot.WeaveEnd(0);
    }

    private static void TrajectoryJ(Robot robot) {
        ForceTorque tor = new ForceTorque(10.0, 10.0, 10.0, 10.0, 10.0, 10.0);
        robot.SetTrajectoryJForceTorque(tor);
        robot.SetTrajectoryJForceFx(2.0);
        robot.SetTrajectoryJForceFy(2.0);
        robot.SetTrajectoryJForceFz(2.0);
        robot.SetTrajectoryJTorqueTx(2.0);
        robot.SetTrajectoryJTorqueTy(2.0);
        robot.SetTrajectoryJTorqueTz(2.0);
        robot.LoadTrajectoryJ("/fruser/traj/test1011002.txt", 20.0, 1);
        DescPose startPos = new DescPose();
        robot.GetTrajectoryStartPose("/fruser/traj/test1011002.txt", startPos);
        robot.MoveCart(startPos, 0, 0, 40.0, 100.0, 100.0, -1.0, -1);
        ROBOT_STATE_PKG pkg = robot.GetRobotRealTimeState();
        System.out.println("Trajectory point num is " + pkg.trajectory_pnum);
        robot.SetTrajectoryJSpeed(40.0);
        robot.MoveTrajectoryJ();
    }

    private static void PointTableTest(Robot robot) {
    }

    private static void RobotStateTest(Robot robot) {
        ROBOT_STATE_PKG pkg = robot.GetRobotRealTimeState();
        System.out.println("Tool pos " + pkg.tl_cur_pos[0] + "  " + pkg.tl_cur_pos[1] + "  " + pkg.tl_cur_pos[2] + "  " + pkg.tl_cur_pos[3] + "  " + pkg.tl_cur_pos[4] + "  " + pkg.tl_cur_pos[5] + "  ");
        System.out.println("Joint pos " + pkg.jt_cur_pos[0] + "  " + pkg.jt_cur_pos[1] + "  " + pkg.jt_cur_pos[2] + "  " + pkg.jt_cur_pos[3] + "  " + pkg.jt_cur_pos[4] + "  " + pkg.jt_cur_pos[5] + "  ");
        System.out.println("Flange pos " + pkg.flange_cur_pos[0] + "  " + pkg.flange_cur_pos[1] + "  " + pkg.flange_cur_pos[2] + "  " + pkg.flange_cur_pos[3] + "  " + pkg.flange_cur_pos[4] + "  " + pkg.flange_cur_pos[5] + "  ");
        System.out.println("Tool " + pkg.tool);
        System.out.println("WObj " + pkg.user);
        System.out.println("Mode " + pkg.robot_mode);
        System.out.println("Enable " + pkg.rbtEnableState);
        System.out.println("CI " + pkg.cl_dgt_input_h);
        System.out.println("AI " + Arrays.toString(pkg.cl_analog_input));
    }

    private static void GripperTest(Robot robot) {
        int company = 3;
        int device = 0;
        int softversion = 0;
        int bus = 1;
        int deviceID = -1;
        DeviceConfig gripperConfig = new DeviceConfig(company, device, softversion, bus);
        robot.SetGripperConfig(gripperConfig);
        robot.Sleep(1000);
        DeviceConfig getConfig = new DeviceConfig();
        robot.GetGripperConfig(getConfig);
        System.out.println("gripper \u5382\u5546:" + getConfig.company + " , \u7c7b\u578b: " + getConfig.device + " , \u8f6f\u4ef6\u7248\u672c: " + getConfig.softwareVersion);
        int rtn = -1;
        rtn = robot.ConveyorPointIORecord();
        System.out.println("ConveyorPointIORecord: rtn " + rtn);
        rtn = robot.ConveyorPointARecord();
        System.out.println("ConveyorPointARecord: rtn " + rtn);
        rtn = robot.ConveyorRefPointRecord();
        System.out.println("ConveyorRefPointRecord: rtn  " + rtn);
        rtn = robot.ConveyorPointBRecord();
        System.out.println("ConveyorPointBRecord: rtn " + rtn);
        robot.ConveyorSetParam(1, 10000, 2.0, 1, 1, 20.0, 0, 0, 100);
        System.out.println("ConveyorSetParam: rtn  " + rtn);
        DescPose pos1 = new DescPose(-351.549, 87.914, 354.176, -179.679, -0.134, 2.468);
        DescPose pos2 = new DescPose(-351.203, -213.393, 351.054, -179.932, -0.508, 2.472);
        Object[] cmp = new Object[]{0.0, 0.0, 0.0};
        rtn = robot.ConveyorCatchPointComp(cmp);
        if (rtn != 0) {
            return;
        }
        System.out.println("ConveyorCatchPointComp: rtn  " + rtn);
        rtn = robot.MoveCart(pos1, 1, 0, 30.0, 180.0, 100.0, -1.0, -1);
        System.out.println("MoveCart: rtn  " + rtn);
        rtn = robot.ConveyorIODetect(10000);
        System.out.println("ConveyorIODetect: rtn   " + rtn);
        robot.ConveyorGetTrackData(1);
        rtn = robot.ConveyorTrackStart(1);
        System.out.println("ConveyorTrackStart: rtn  " + rtn);
        rtn = robot.ConveyorTrackMoveL("cvrCatchPoint", 1, 0, 100.0, 0.0, 100.0, -1.0);
        System.out.println("ConveyorTrackMoveL: rtn  " + rtn);
        rtn = robot.MoveGripper(1, 60, 60, 30, 30000, 0, 0, 0.0, 0, 0);
        System.out.println("MoveGripper: rtn  {rtn}");
        rtn = robot.ConveyorTrackMoveL("cvrRaisePoint", 1, 0, 100.0, 0.0, 100.0, -1.0);
        System.out.println("ConveyorTrackMoveL: rtn   " + rtn);
        rtn = robot.ConveyorTrackEnd();
        System.out.println("ConveyorTrackEnd: rtn  " + rtn);
        rtn = robot.MoveCart(pos2, 1, 0, 30.0, 180.0, 100.0, -1.0, -1);
        System.out.println("MoveCart: rtn  " + rtn);
        rtn = robot.MoveGripper(1, 100, 60, 30, 30000, 0, 0, 0.0, 0, 0);
        System.out.println("MoveGripper: rtn  " + rtn);
    }

    private static void Stable(Robot robot) {
        int count = 0;
        while (true) {
            ++count;
            DescPose desc_p1 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            DescPose desc_p2 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            DescPose desc_p3 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            desc_p1.tran.x = -104.846;
            desc_p1.tran.y = 309.573;
            desc_p1.tran.z = 336.647;
            desc_p1.rpy.rx = 179.681;
            desc_p1.rpy.ry = -0.419;
            desc_p1.rpy.rz = -92.692;
            desc_p2.tran.x = -318.287;
            desc_p2.tran.y = 158.502;
            desc_p2.tran.z = 346.184;
            desc_p2.rpy.rx = 179.602;
            desc_p2.rpy.ry = 1.081;
            desc_p2.rpy.rz = -46.342;
            desc_p3.tran.x = -67.635;
            desc_p3.tran.y = -387.487;
            desc_p3.tran.z = 283.656;
            desc_p3.rpy.rx = -175.639;
            desc_p3.rpy.ry = 0.886;
            desc_p3.rpy.rz = 93.416;
            JointPos j1 = new JointPos();
            JointPos j2 = new JointPos();
            JointPos j3 = new JointPos();
            robot.GetInverseKin(0, desc_p1, -1, j1);
            robot.GetInverseKin(0, desc_p2, -1, j2);
            robot.GetInverseKin(0, desc_p3, -1, j3);
            ExaxisPos epos = new ExaxisPos();
            DescPose offset_pos = new DescPose();
            robot.MoveJ(j1, desc_p1, 0, 0, 100.0, 100.0, 100.0, epos, -1.0, 0, offset_pos);
            ROBOT_STATE_PKG pkg = robot.GetRobotRealTimeState();
            System.out.println("cur pos is " + Arrays.toString(pkg.jt_cur_pos) + "  motiondone state " + pkg.motion_done);
            robot.MoveJ(j2, desc_p2, 0, 0, 100.0, 100.0, 100.0, epos, -1.0, 0, offset_pos);
            pkg = robot.GetRobotRealTimeState();
            System.out.println("cur pos is " + Arrays.toString(pkg.jt_cur_pos) + "  motiondone state " + pkg.motion_done + "  count is   " + count);
        }
    }

    private static void Welding(Robot robot) {
        robot.WeldingSetCurrent(0, 500.0, 0, 0);
        robot.WeldingSetVoltage(0, 60.0, 1, 0);
        robot.WeaveSetPara(0, 0, 2.0, 0, 0.0, 0.0, 0.0, 0, 100, 100, 50, 50, 1.0);
        DescPose desc_p1 = new DescPose(688.259, -566.358, -139.354, -158.206, 0.324, -117.817);
        DescPose desc_p2 = new DescPose(700.078, -224.752, -149.191, -158.2, 0.239, -94.978);
        JointPos j1 = new JointPos(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        JointPos j2 = new JointPos(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.GetInverseKin(0, desc_p1, -1, j1);
        robot.GetInverseKin(0, desc_p2, -1, j2);
        ExaxisPos epos = new ExaxisPos();
        DescPose offset_pos = new DescPose();
        robot.MoveL(j1, desc_p1, 3, 0, 30.0, 100.0, 100.0, -1.0, epos, 0, 0, offset_pos, 0, 100);
        robot.WeaveSetPara(0, 0, 1.0, 0, 10.0, 0.0, 0.0, 0, 100, 100, 50, 50, 1.0);
        robot.ARCStart(0, 0, 10000);
        robot.WeaveStart(0);
        robot.MoveL(j2, desc_p2, 3, 0, 10.0, 100.0, 100.0, -1.0, epos, 0, 0, offset_pos, 0, 100);
        robot.ARCEnd(0, 0, 10000);
        robot.WeaveEnd(0);
    }

    private static void TPD(Robot robot) {
        int type = 1;
        String name = "tpd_2024";
        int period_ms = 2;
        int di_choose = 0;
        int do_choose = 0;
        robot.SetTPDDelete(name);
        robot.SetTPDParam(type, name, period_ms, di_choose, do_choose);
        robot.Mode(1);
        robot.Sleep(1000);
        robot.DragTeachSwitch(1);
        robot.SetTPDStart(type, name, period_ms, di_choose, do_choose);
        robot.Sleep(10000);
        robot.SetWebTPDStop();
        robot.DragTeachSwitch(0);
        int tool = 0;
        int user = 0;
        double vel = 30.0;
        double acc = 100.0;
        double ovl = 100.0;
        double blendT = -1.0;
        int config = -1;
        int blend = 1;
        DescPose desc_pose = new DescPose();
        robot.GetTPDStartPose(name, desc_pose);
        robot.SetTrajectoryJSpeed(100.0);
        robot.LoadTPD(name);
        robot.MoveCart(desc_pose, tool, user, vel, acc, ovl, blendT, config);
        robot.MoveTPD(name, blend, 80.0);
    }

    private static void RobotState(Robot robot) {
        robot.SetRobotInstallAngle(23.4, 56.7);
        List<Number> rtnArr = robot.GetRobotInstallAngle();
        System.out.println("\u5b89\u88c5\u89d2\u5ea6: " + rtnArr.get(1) + "  " + rtnArr.get(2));
        robot.SetRobotInstallAngle(0.0, 0.0);
    }

    private static void RobotSafety(Robot robot) {
    }

    private static void CommonSets(Robot robot) {
        JointPos j1 = new JointPos(-114.756, -109.423, 87.751, -65.834, -52.21, 92.992);
        JointPos j2 = new JointPos(-51.811, -91.53, 74.859, -81.58, -121.913, 92.99);
        JointPos j3 = new JointPos(-105.35, -65.747, 32.346, -26.434, -60.784, 92.992);
        JointPos j4 = new JointPos(-79.015, -81.54, 47.786, -57.729, -88.577, 92.991);
        JointPos j5 = new JointPos(-102.647, -99.334, 68.842, -59.256, -88.407, 92.937);
        JointPos j6 = new JointPos(-78.99, -78.608, 38.428, -51.812, -88.31, 92.939);
        DescPose desc_p1 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose desc_p2 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose desc_p3 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose desc_p4 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose desc_p5 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose desc_p6 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.GetForwardKin(j1, desc_p1);
        robot.GetForwardKin(j2, desc_p2);
        robot.GetForwardKin(j3, desc_p3);
        robot.GetForwardKin(j4, desc_p4);
        robot.GetForwardKin(j5, desc_p5);
        robot.GetForwardKin(j6, desc_p6);
        ExaxisPos epos = new ExaxisPos();
        DescPose offset_pos = new DescPose();
    }

    private static void IOTest(Robot robot) {
        int i;
        robot.SetDO(8, 1, 0, 0);
        robot.Sleep(3000);
        robot.SetDO(8, 0, 0, 0);
        robot.SetToolDO(0, 1, 0, 0);
        robot.Sleep(3000);
        robot.SetToolDO(0, 0, 0, 0);
        for (i = 0; i < 90; ++i) {
            robot.SetAO(0, i + 1, 0);
            robot.SetAO(1, i + 1, 0);
            robot.Sleep(50);
        }
        robot.SetAO(0, 0.0, 0);
        robot.SetAO(1, 0.0, 0);
        for (i = 0; i < 99; ++i) {
            robot.SetToolAO(0, i + 1, 0);
            robot.Sleep(50);
        }
        robot.SetToolAO(0, 0.0, 0);
        System.out.println("wait  start ");
        robot.WaitDI(1, 1, 10000, 0);
        robot.WaitMultiDI(0, 6, 6, 10000, 0);
        robot.WaitToolDI(0, 1, 5000, 0);
        robot.WaitAI(0, 0, 8.0, 5000, 0);
        robot.WaitToolAI(0, 0, 20.0, 5000, 0);
        System.out.println("wait  end ");
    }

    private static void Moves(Robot robot) {
        DescPose tcoord = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose desc_p1 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose desc_p2 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose desc_p3 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose desc_p4 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        desc_p1.tran.x = -104.846;
        desc_p1.tran.y = 309.573;
        desc_p1.tran.z = 336.647;
        desc_p1.rpy.rx = 179.681;
        desc_p1.rpy.ry = -0.419;
        desc_p1.rpy.rz = -92.692;
        desc_p2.tran.x = -318.287;
        desc_p2.tran.y = 158.502;
        desc_p2.tran.z = 346.184;
        desc_p2.rpy.rx = 179.602;
        desc_p2.rpy.ry = 1.081;
        desc_p2.rpy.rz = -46.342;
        desc_p3.tran.x = -352.414;
        desc_p3.tran.y = 24.059;
        desc_p3.tran.z = 395.376;
        desc_p3.rpy.rx = 179.755;
        desc_p3.rpy.ry = -1.045;
        desc_p3.rpy.rz = -23.877;
        desc_p4.tran.x = 195.474;
        desc_p4.tran.y = 423.278;
        desc_p4.tran.z = 228.509;
        desc_p4.rpy.rx = -179.199;
        desc_p4.rpy.ry = -0.567;
        desc_p4.rpy.rz = -130.209;
        JointPos j1 = new JointPos();
        JointPos j2 = new JointPos();
        JointPos j3 = new JointPos();
        JointPos j4 = new JointPos();
        robot.GetInverseKin(0, desc_p1, -1, j1);
        robot.GetInverseKin(0, desc_p2, -1, j2);
        robot.GetInverseKin(0, desc_p3, -1, j3);
        robot.GetInverseKin(0, desc_p4, -1, j4);
        ExaxisPos epos = new ExaxisPos();
        DescPose offset_pos = new DescPose();
        JointPos JP1 = new JointPos(117.408, -86.777, 81.499, -87.788, -92.964, 92.959);
        DescPose DP1 = new DescPose(327.359, -420.973, 518.377, -177.199, 3.209, 114.449);
        JointPos JP2 = new JointPos(72.515, -86.774, 81.525, -87.724, -91.964, 92.958);
        DescPose DP2 = new DescPose(-63.512, -529.698, 517.946, -178.192, 3.07, 69.554);
        robot.MoveJ(JP1, DP1, 0, 0, 30.0, 30.0, 100.0, epos, -1.0, 0, offset_pos);
        robot.MoveJ(JP2, DP2, 0, 0, 30.0, 100.0, 100.0, epos, -1.0, 0, offset_pos);
    }

    private static void Standard(Robot robot) {
        String[] ip = new String[]{""};
        String version = "";
        boolean state = false;
        version = robot.GetSDKVersion();
        System.out.println("SDK version : " + version);
        int rtn = robot.GetControllerIP(ip);
        System.out.println("controller ip : " + ip[0] + "  " + rtn);
        robot.Mode(1);
        robot.Sleep(1000);
        robot.DragTeachSwitch(1);
        robot.Sleep(1000);
        ROBOT_STATE_PKG pkg = robot.GetRobotRealTimeState();
        System.out.println("drag state : " + pkg.robot_state);
        robot.Sleep(1000);
        robot.DragTeachSwitch(0);
        robot.Sleep(1000);
        pkg = robot.GetRobotRealTimeState();
        System.out.println("drag state : " + pkg.robot_state);
        if (pkg.robot_state == 4) {
            System.out.println("\u62d6\u52a8\u6a21\u5f0f");
        } else {
            System.out.println("\u975e\u62d6\u52a8\u6a21\u5f0f");
        }
    }

    private static void ForceSensor(Robot robot) {
        int flag = 1;
        int sensor_id = 2;
        Object[] select = new Object[]{0, 0, 1, 0, 0, 0};
        Object[] max_threshold = new Object[]{0.01, 0.01, 5.01, 0.01, 0.01, 0.01};
        Object[] min_threshold = new Object[]{0.01, 0.01, 5.01, 0.01, 0.01, 0.01};
        ForceTorque ft = new ForceTorque(1.0, 0.0, 2.0, 0.0, 0.0, 0.0);
        DescPose desc_p1 = new DescPose(-280.5, -474.534, 320.677, 177.986, 1.498, -118.235);
        DescPose desc_p2 = new DescPose(-283.273, -468.668, 172.905, 177.986, 1.498, -118.235);
        int[] safetyMargin = new int[]{5, 5, 5, 5, 5, 5};
        robot.SetCollisionStrategy(5, 1000, 150, 150, safetyMargin);
        int rtn = robot.FT_Guard(flag, sensor_id, select, ft, max_threshold, min_threshold);
        System.out.println("FT_Guard start rtn " + rtn);
        robot.MoveCart(desc_p1, 0, 0, 20.0, 100.0, 100.0, -1.0, -1);
        robot.MoveCart(desc_p2, 0, 0, 20.0, 100.0, 100.0, -1.0, -1);
        flag = 0;
        rtn = robot.FT_Guard(flag, sensor_id, select, ft, max_threshold, min_threshold);
        System.out.println("FT_Guard end rtn " + rtn);
    }

    static void DOReset(Robot robot) {
        robot.SetAO(0, 60.0, 0);
        robot.SetToolAO(0, 60.0, 0);
        robot.Sleep(2000);
        robot.SetOutputResetCtlBoxDO(1);
        robot.SetOutputResetAxleDO(1);
        robot.SetOutputResetCtlBoxAO(1);
        robot.SetOutputResetAxleAO(1);
        JointPos j1 = new JointPos(-81.684, -106.159, -74.447, -86.33, 94.725, 41.639);
        JointPos j2 = new JointPos(-102.804, -106.159, -74.449, -86.328, 94.715, 41.639);
        DescPose desc_p1 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose desc_p2 = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.GetForwardKin(j1, desc_p1);
        robot.GetForwardKin(j2, desc_p2);
        ExaxisPos epos = new ExaxisPos();
        DescPose offset_pos = new DescPose();
        robot.MoveL(j1, desc_p1, 0, 0, 30.0, 100.0, 100.0, -1.0, epos, 0, 0, offset_pos, 0, 100);
        robot.SetAuxAO(0, 1234.0, false);
        robot.SetAuxAO(1, 2345.0, false);
        robot.SetAuxAO(2, 3456.0, false);
        robot.SetAuxAO(3, 1111.0, false);
        robot.SetOutputResetExtDO(1);
        robot.SetOutputResetExtAO(1);
    }

    private static void UDPAxisSyncMove(Robot robot) {
    }

    private static void UDPAxis(Robot robot) {
        UDPComParam param = new UDPComParam("192.168.58.88", 2021, 2, 100, 3, 100, 1, 100, 10);
        robot.ExtDevSetUDPComParam(param);
        UDPComParam getParam = new UDPComParam();
        robot.ExtDevGetUDPComParam(getParam);
        System.out.println(" " + getParam.ip + " ,   " + getParam.port + " ,   " + getParam.period + " ,  " + getParam.lossPkgTime + " ,   " + getParam.lossPkgNum + " ,   " + getParam.disconnectTime + " ,   " + getParam.reconnectEnable + " ,   " + getParam.reconnectPeriod + " ,   " + getParam.reconnectNum);
        robot.ExtDevUnloadUDPDriver();
        robot.Sleep(1000);
        robot.ExtDevLoadUDPDriver();
        robot.Sleep(1000);
    }

    private static void TestUDPWireSearch(Robot robot) {
        UDPComParam param = new UDPComParam("192.168.58.88", 2021, 2, 100, 3, 100, 1, 100, 10);
        robot.ExtDevSetUDPComParam(param);
        robot.SetWireSearchExtDIONum(0, 0);
        int rtn2 = 0;
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose descStart = new DescPose(-158.767, -510.596, 271.709, -179.427, -0.745, -137.349);
        JointPos jointStart = new JointPos(61.667, -79.848, 108.639, -119.682, -89.7, -70.985);
        DescPose descEnd = new DescPose(0.332, -516.427, 270.688, 178.165, 0.017, -119.989);
        JointPos jointEnd = new JointPos(79.021, -81.839, 110.752, -118.298, -91.729, -70.981);
        robot.MoveL(jointStart, descStart, 1, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 100);
        robot.MoveL(jointEnd, descEnd, 1, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 100);
        DescPose descREF0A = new DescPose(-66.106, -560.746, 270.381, 176.479, -0.126, -126.745);
        JointPos jointREF0A = new JointPos(73.531, -75.588, 102.941, -116.25, -93.347, -69.689);
        DescPose descREF0B = new DescPose(-66.109, -528.44, 270.407, 176.479, -0.129, -126.744);
        JointPos jointREF0B = new JointPos(72.534, -79.625, 108.046, -117.379, -93.366, -70.687);
        DescPose descREF1A = new DescPose(72.975, -473.242, 270.399, 176.479, -0.129, -126.744);
        JointPos jointREF1A = new JointPos(87.169, -86.509, 115.71, -117.341, -92.993, -56.034);
        DescPose descREF1B = new DescPose(31.355, -473.238, 270.405, 176.48, -0.13, -126.745);
        JointPos jointREF1B = new JointPos(82.117, -87.146, 116.47, -117.737, -93.145, -61.09);
        int rtn0 = robot.WireSearchStart(0, 10.0, 100, 0, 10.0, 100, 0);
        robot.MoveL(jointREF0A, descREF0A, 1, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 100);
        robot.MoveL(jointREF0B, descREF0B, 1, 0, 10.0, 100.0, 100.0, -1.0, exaxisPos, 1, 0, offdese, 0, 100);
        int rtn1 = robot.WireSearchWait("REF0");
        rtn2 = robot.WireSearchEnd(0, 10.0, 100, 0, 10.0, 100, 0);
        rtn0 = robot.WireSearchStart(0, 10.0, 100, 0, 10.0, 100, 0);
        robot.MoveL(jointREF1A, descREF1A, 1, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 100);
        robot.MoveL(jointREF1B, descREF1B, 1, 0, 10.0, 100.0, 100.0, -1.0, exaxisPos, 1, 0, offdese, 0, 100);
        rtn1 = robot.WireSearchWait("REF1");
        rtn2 = robot.WireSearchEnd(0, 10.0, 100, 0, 10.0, 100, 0);
        rtn0 = robot.WireSearchStart(0, 10.0, 100, 0, 10.0, 100, 0);
        robot.MoveL(jointREF0A, descREF0A, 1, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 100);
        robot.MoveL(jointREF0B, descREF0B, 1, 0, 10.0, 100.0, 100.0, -1.0, exaxisPos, 1, 0, offdese, 0, 100);
        rtn1 = robot.WireSearchWait("RES0");
        rtn2 = robot.WireSearchEnd(0, 10.0, 100, 0, 10.0, 100, 0);
        rtn0 = robot.WireSearchStart(0, 10.0, 100, 0, 10.0, 100, 0);
        robot.MoveL(jointREF1A, descREF1A, 1, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 100);
        robot.MoveL(jointREF1B, descREF1B, 1, 0, 10.0, 100.0, 100.0, -1.0, exaxisPos, 1, 0, offdese, 0, 100);
        rtn1 = robot.WireSearchWait("RES1");
        rtn2 = robot.WireSearchEnd(0, 10.0, 100, 0, 10.0, 100, 0);
        String[] varNameRef = new String[]{"REF0", "REF1", "#", "#", "#", "#"};
        String[] varNameRes = new String[]{"RES0", "RES1", "#", "#", "#", "#"};
        boolean offectFlag = false;
        DescOffset offset = new DescOffset();
        rtn0 = robot.GetWireSearchOffset(0, 0, varNameRef, varNameRes, offset);
        robot.PointsOffsetEnable(0, offset.offset);
        robot.MoveL(jointStart, descStart, 1, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 0, 100);
        robot.MoveL(jointEnd, descEnd, 1, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 1, 0, offdese, 0, 100);
        robot.PointsOffsetDisable();
    }

    private static void TestTractorMove(Robot robot) {
        UDPComParam param = new UDPComParam("192.168.58.88", 2021, 2, 100, 3, 100, 1, 100, 10);
        robot.ExtDevSetUDPComParam(param);
        robot.ExtAxisParamConfig(1, 0, 0, 50000.0, -50000.0, 1000.0, 1000.0, 6.28, 16384, 200.0, 0, 0, 0);
        robot.ExtAxisParamConfig(2, 0, 0, 50000.0, -50000.0, 1000.0, 1000.0, 6.28, 16384, 200.0, 0, 0, 0);
        robot.SetAxisDHParaConfig(5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.TractorEnable(false);
        robot.Sleep(2000);
        robot.TractorEnable(true);
        robot.Sleep(2000);
        robot.TractorHoming();
        robot.Sleep(2000);
        robot.TractorMoveL(100.0, 20.0);
        robot.Sleep(5000);
        robot.TractorMoveL(-100.0, 20.0);
        robot.Sleep(5000);
        robot.TractorMoveC(300.0, 90.0, 20.0);
        robot.Sleep(2000);
        robot.TractorStop();
        robot.TractorMoveC(300.0, -90.0, 20.0);
    }

    private static void TestWeldmechineMode(Robot robot) {
        int i;
        UDPComParam param = new UDPComParam("192.168.58.88", 2021, 2, 50, 5, 50, 1, 50, 10);
        robot.ExtDevSetUDPComParam(param);
        robot.ExtDevLoadUDPDriver();
        robot.SetWeldMachineCtrlModeExtDoNum(17);
        for (i = 0; i < 5; ++i) {
            robot.SetWeldMachineCtrlMode(0);
            robot.Sleep(500);
            robot.SetWeldMachineCtrlMode(1);
            robot.Sleep(500);
        }
        robot.SetWeldMachineCtrlModeExtDoNum(18);
        for (i = 0; i < 5; ++i) {
            robot.SetWeldMachineCtrlMode(0);
            robot.Sleep(500);
            robot.SetWeldMachineCtrlMode(1);
            robot.Sleep(500);
        }
        robot.SetWeldMachineCtrlModeExtDoNum(19);
        for (i = 0; i < 5; ++i) {
            robot.SetWeldMachineCtrlMode(0);
            robot.Sleep(500);
            robot.SetWeldMachineCtrlMode(1);
            robot.Sleep(500);
        }
    }

    private static void Program(Robot robot) {
        robot.LuaDownLoad("1010TestLUA.lua", "D://LUA/");
    }

    static int SegmentWeld(Robot robot) {
        DescPose startdescPose = new DescPose(185.859, -520.154, 193.129, -177.129, 1.339, -137.789);
        JointPos startjointPos = new JointPos(-60.989, -94.515, -89.479, -83.514, 91.957, -13.124);
        DescPose enddescPose = new DescPose(-243.7033, -543.868, 143.199, -177.954, 1.528, 177.758);
        JointPos endjointPos = new JointPos(-105.479, -101.919, -87.979, -78.455, 91.955, -13.183);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.SegmentWeldStart(startdescPose, enddescPose, startjointPos, endjointPos, 80.0, 40.0, 0, 0, 5000, true, 0, 3, 0, 30.0, 30.0, 100.0, -1.0, exaxisPos, 0, 0, offdese);
        return 0;
    }

    static int TestAuxServo(Robot robot) {
        robot.AuxServoEnable(1, 0);
        robot.Sleep(1000);
        robot.AuxServoSetControlMode(1, 0);
        robot.Sleep(2000);
        robot.AuxServoEnable(1, 1);
        robot.Sleep(2000);
        robot.AuxServoHoming(1, 1, 10.0, 10.0, 100.0);
        robot.Sleep(4000);
        while (true) {
            robot.AuxServoSetAcc(500.0, 500.0);
            robot.AuxServoSetTargetPos(1, 1000.0, 100.0, 50.0);
            robot.Sleep(2000);
            robot.AuxServoSetTargetPos(1, 0.0, 500.0, 50.0);
            robot.Sleep(3000);
            robot.AuxServoSetTargetPos(1, 1000.0, 500.0, 30.0);
            robot.Sleep(5000);
            robot.AuxServoSetTargetPos(1, 0.0, 500.0, 30.0);
            robot.Sleep(5000);
        }
    }

    private static void TestEndLuaGripper(Robot robot) {
        ROBOT_STATE_PKG pkg = new ROBOT_STATE_PKG();
        AxleComParam param = new AxleComParam(7, 8, 1, 0, 5, 3, 1);
        robot.SetAxleCommunicationParam(param);
        AxleComParam getParam = new AxleComParam();
        robot.GetAxleCommunicationParam(getParam);
        robot.SetAxleLuaEnable(1);
        int[] luaEnableStatus = new int[5];
        robot.GetAxleLuaEnableStatus(luaEnableStatus);
        robot.SetAxleLuaEnableDeviceType(0, 1, 0);
        int[] type = new int[10];
        robot.GetAxleLuaEnableDeviceType(type);
        int[] func = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
        robot.SetAxleLuaGripperFunc(1, func);
        int[] getFunc = new int[16];
        robot.GetAxleLuaGripperFunc(1, getFunc);
        int[] forceEnable = new int[16];
        int[] gripperEnable = new int[16];
        int[] ioEnable = new int[16];
        robot.GetAxleLuaEnableDevice(forceEnable, gripperEnable, ioEnable);
        boolean pos = false;
    }

    private static void EndLuaUpload(Robot robot) {
    }

    private static void TestEndLuaForce(Robot robot) {
        ROBOT_STATE_PKG pkg = new ROBOT_STATE_PKG();
        AxleComParam param = new AxleComParam(7, 8, 1, 0, 5, 3, 1);
        robot.SetAxleCommunicationParam(param);
        AxleComParam getParam = new AxleComParam();
        robot.GetAxleCommunicationParam(getParam);
        robot.SetAxleLuaEnable(1);
        int[] luaEnableStatus = new int[5];
        robot.GetAxleLuaEnableStatus(luaEnableStatus);
        robot.SetAxleLuaEnableDeviceType(1, 0, 0);
        int[] type = new int[10];
        robot.GetAxleLuaEnableDeviceType(type);
        int[] forceEnable = new int[16];
        int[] gripperEnable = new int[16];
        int[] ioEnable = new int[16];
        robot.GetAxleLuaEnableDevice(forceEnable, gripperEnable, ioEnable);
        robot.Sleep(1000);
        Object[] M = new Object[]{15.0, 15.0, 15.0, 0.5, 0.5, 0.1};
        Object[] B = new Object[]{150.0, 150.0, 150.0, 5.0, 5.0, 1.0};
        Object[] K = new Object[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        Object[] F = new Object[]{10.0, 10.0, 10.0, 1.0, 1.0, 1.0};
        robot.EndForceDragControl(1, 0, 0, 0, M, B, K, F, 50.0, 100.0);
        robot.Sleep(2000);
        robot.EndForceDragControl(0, 0, 0, 0, M, B, K, F, 50.0, 100.0);
    }

    public static void TestSingularAvoidEArc(Robot robot) {
        DescPose startdescPose = new DescPose(-57.17, -690.147, 370.969, 176.438, -8.32, 169.881);
        JointPos startjointPos = new JointPos(78.017, -62.036, 69.561, -94.199, -98.416, -1.36);
        DescPose middescPose = new DescPose(-71.044, -743.395, 375.996, -179.499, -5.398, 168.739);
        JointPos midjointPos = new JointPos(77.417, -55.0, 58.732, -94.36, -95.385, -1.376);
        DescPose enddescPose = new DescPose(-439.979, -512.743, 396.472, 178.112, 3.625, 146.576);
        JointPos endjointPos = new JointPos(40.243, -65.402, 70.802, -92.565, -87.055, -16.465);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.MoveL(startjointPos, startdescPose, 0, 0, 30.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        robot.SingularAvoidStart(2, 10.0, 5.0, 5.0);
        robot.MoveC(midjointPos, middescPose, 0, 0, 30.0, 100.0, exaxisPos, 0, offdese, endjointPos, enddescPose, 0, 0, 30.0, 100.0, exaxisPos, 0, offdese, 100.0, -1.0);
        robot.SingularAvoidEnd();
    }

    public static void TestSingularAvoidSArc(Robot robot) {
        robot.SingularAvoidEnd();
        int rtn = 0;
        DescPose startdescPose = new DescPose(299.993, -168.982, 299.998, 179.999, -0.002, -166.415);
        JointPos startjointPos = new JointPos(-12.16, -71.236, -131.775, -66.992, 90.0, 64.255);
        DescPose middescPose = new DescPose(249.985, -140.988, 299.929, 179.996, -0.013, -166.417);
        JointPos midjointPos = new JointPos(-8.604, -60.474, -137.494, -72.046, 89.999, 67.813);
        DescPose enddescPose = new DescPose(-249.991, -168.98, 299.981, 179.999, 0.004, -107.386);
        JointPos endjointPos = new JointPos(-126.186, -63.401, -136.126, -70.477, 89.998, -108.8);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        rtn = robot.MoveL(startjointPos, startdescPose, 0, 0, 30.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        rtn = robot.SingularAvoidStart(2, 30.0, 5.0, 5.0);
        rtn = robot.MoveC(midjointPos, middescPose, 0, 0, 30.0, 100.0, exaxisPos, 0, offdese, endjointPos, enddescPose, 0, 0, 30.0, 100.0, exaxisPos, 0, offdese, 100.0, -1.0);
        rtn = robot.SingularAvoidEnd();
        System.out.println("robot moving rtn is " + rtn);
    }

    public static void TestSingularAvoidWLin(Robot robot) {
        DescPose startdescPose = new DescPose(-352.574, -685.606, 479.415, -15.926, -54.905, 130.693);
        JointPos startjointPos = new JointPos(49.63, -56.597, 60.013, -57.99, 42.725, 146.834);
        DescPose enddescPose = new DescPose(-653.655, -235.943, 434.585, -176.403, -54.513, -66.719);
        JointPos endjointPos = new JointPos(5.072, -58.92, 55.28, -57.939, -41.207, 146.834);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.MoveL(startjointPos, startdescPose, 0, 0, 30.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        robot.SingularAvoidStart(2, 30.0, 10.0, 3.0);
        robot.MoveL(endjointPos, enddescPose, 0, 0, 30.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        robot.SingularAvoidEnd();
    }

    public static void TestSingularAvoidWArc(Robot robot) {
        DescPose startdescPose = new DescPose(-352.575, -685.604, 479.38, -15.933, -54.906, 130.699);
        JointPos startjointPos = new JointPos(49.63, -56.597, 60.017, -57.989, 42.725, 146.834);
        DescPose middescPose = new DescPose(-437.302, -372.046, 366.764, -133.489, -62.309, -94.994);
        JointPos midjointPos = new JointPos(21.202, -72.442, 84.164, -51.66, -29.88, 146.823);
        DescPose enddescPose = new DescPose(-653.649, -235.926, 434.525, -176.386, -54.515, -66.734);
        JointPos endjointPos = new JointPos(5.07, -58.92, 55.287, -57.937, -41.207, 146.834);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.MoveL(startjointPos, startdescPose, 0, 0, 30.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        robot.SingularAvoidStart(2, 10.0, 5.0, 4.0);
        robot.MoveC(midjointPos, middescPose, 0, 0, 30.0, 100.0, exaxisPos, 0, offdese, endjointPos, enddescPose, 0, 0, 30.0, 100.0, exaxisPos, 0, offdese, 100.0, -1.0);
        robot.SingularAvoidEnd();
    }

    public static void TestSingularAvoidSLin(Robot robot) {
        DescPose startdescPose = new DescPose(300.002, -102.991, 299.994, 180.0, -0.001, -166.416);
        JointPos startjointPos = new JointPos(-0.189, -66.345, -134.615, -69.042, 90.0, 76.227);
        DescPose enddescPose = new DescPose(-300.0, -103.001, 299.994, 179.998, 0.003, -107.384);
        JointPos endjointPos = new JointPos(-142.292, -66.345, -134.615, -69.042, 89.997, -124.908);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        robot.MoveL(startjointPos, startdescPose, 0, 0, 30.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        robot.SingularAvoidStart(2, 30.0, 10.0, 3.0);
        robot.MoveL(endjointPos, enddescPose, 0, 0, 30.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        robot.SingularAvoidEnd();
    }

    public static void UploadTrajectoryJ(Robot robot) {
        robot.TrajectoryJDelete("testA.txt");
        robot.TrajectoryJUpLoad("D://zUP/testA.txt");
        int retval = 0;
        String traj_file_name = "/fruser/traj/testA.txt";
        retval = robot.LoadTrajectoryJ(traj_file_name, 100.0, 1);
        System.out.println("LoadTrajectoryJ %s, retval is:" + traj_file_name + retval);
        DescPose traj_start_pose = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        retval = robot.GetTrajectoryStartPose(traj_file_name, traj_start_pose);
        System.out.println("GetTrajectoryStartPose is: %d" + retval);
        System.out.println("desc_pos:(" + traj_start_pose.tran.x + "," + traj_start_pose.tran.y + "," + traj_start_pose.tran.z + "," + traj_start_pose.rpy.rx + "," + traj_start_pose.rpy.ry + "," + traj_start_pose.rpy.rz + ")");
        robot.SetSpeed(30);
        robot.MoveCart(traj_start_pose, 1, 0, 100.0, 100.0, 100.0, -1.0, -1);
        robot.Sleep(5000);
        int traj_num = 0;
        ROBOT_STATE_PKG pkg = robot.GetRobotRealTimeState();
        traj_num = pkg.trajectory_pnum;
        System.out.println("GetTrajectoryStartPose traj num is:" + traj_num);
        retval = robot.MoveTrajectoryJ();
        System.out.println("MoveTrajectoryJ retval is:" + retval);
    }

    public static void UploadTrajectoryB(Robot robot) {
        robot.TrajectoryJDelete("testB.txt");
        robot.TrajectoryJUpLoad("D://zUP/testB.txt");
        int retval = 0;
        String traj_file_name = "/fruser/traj/testB.txt";
        retval = robot.LoadTrajectoryJ(traj_file_name, 100.0, 1);
        System.out.println("LoadTrajectoryJ " + traj_file_name + ", retval is:" + retval);
        DescPose traj_start_pose = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        retval = robot.GetTrajectoryStartPose(traj_file_name, traj_start_pose);
        System.out.println("GetTrajectoryStartPose is:" + retval);
        System.out.println("desc_pos:" + traj_start_pose.tran.x + "," + traj_start_pose.tran.y + "," + traj_start_pose.tran.z + "," + traj_start_pose.rpy.rx + "," + traj_start_pose.rpy.ry + "," + traj_start_pose.rpy.rz);
        robot.SetSpeed(30);
        robot.MoveCart(traj_start_pose, 1, 0, 100.0, 100.0, 100.0, -1.0, -1);
        robot.Sleep(5000);
        int traj_num = 0;
        ROBOT_STATE_PKG pkg = robot.GetRobotRealTimeState();
        traj_num = pkg.trajectory_pnum;
        System.out.println("GetTrajectoryStartPose traj num is:" + traj_num);
        retval = robot.MoveTrajectoryJ();
        System.out.println("MoveTrajectoryJ retval is:" + retval);
    }

    public static void MoveRotGripper(Robot robot, int pos, double rotPos) {
        robot.ResetAllError();
        robot.ActGripper(1, 1);
        robot.Sleep(1000);
        int rtn = robot.MoveGripper(1, pos, 50, 50, 5000, 1, 1, rotPos, 50, 100);
        System.out.println("move gripper rtn is:" + rtn);
        while (true) {
            ROBOT_STATE_PKG pkg = robot.GetRobotRealTimeState();
            if ((double)Math.abs(pkg.gripper_position - pos) < 1.5) break;
            System.out.println("cur gripper pos is:" + pkg.gripper_position);
            robot.Sleep(10);
        }
        System.out.println("Gripper Motion Done:" + pos);
    }

    public static void SetAO(Robot robot, float value) {
        robot.SetAO(0, value, 0);
        robot.SetAO(1, value, 0);
        robot.SetToolAO(0, value, 0);
        while (true) {
            ROBOT_STATE_PKG pkg = robot.GetRobotRealTimeState();
            if (Math.abs((double)pkg.cl_analog_output[0] / 40.96 - (double)value) < 0.5) break;
            System.out.println("cur AO value is" + pkg.cl_analog_output[0]);
            robot.Sleep(1);
        }
        System.out.println("setAO Done:" + value);
    }

    public static void FIRArc(Robot robot, boolean enable) {
        DescPose startdescPose = new DescPose(-366.397, -572.427, 418.339, -178.972, 1.829, -142.97);
        JointPos startjointPos = new JointPos(43.651, -70.284, 91.057, -109.075, -88.768, -83.382);
        DescPose middescPose = new DescPose(-569.71, -132.595, 395.147, 178.418, -1.893, 171.051);
        JointPos midjointPos = new JointPos(-2.334, -79.3, 108.196, -120.594, -91.79, -83.386);
        DescPose enddescPose = new DescPose(-608.42, 610.692, 314.93, -176.438, -1.756, 117.333);
        JointPos endjointPos = new JointPos(-56.153, -46.964, 68.015, -113.2, -86.661, -83.479);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (enable) {
            robot.LinArcFIRPlanningStart(1000.0, 1000.0, 1000.0, 1000.0);
            robot.MoveL(startjointPos, startdescPose, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
            robot.MoveC(midjointPos, middescPose, 0, 0, 100.0, 100.0, exaxisPos, 0, offdese, endjointPos, enddescPose, 0, 0, 100.0, 100.0, exaxisPos, 0, offdese, 100.0, -1.0);
            robot.LinArcFIRPlanningEnd();
        } else {
            robot.MoveL(startjointPos, startdescPose, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
            robot.MoveC(midjointPos, middescPose, 0, 0, 100.0, 100.0, exaxisPos, 0, offdese, endjointPos, enddescPose, 0, 0, 100.0, 100.0, exaxisPos, 0, offdese, 100.0, -1.0);
        }
    }

    public static void FIRLin(Robot robot, boolean enable) {
        DescPose startdescPose = new DescPose(-569.71, -132.595, 395.147, 178.418, -1.893, 171.051);
        JointPos startjointPos = new JointPos(-2.334, -79.3, 108.196, -120.594, -91.79, -83.386);
        DescPose enddescPose = new DescPose(-366.397, -572.427, 418.339, -178.972, 1.829, -142.97);
        JointPos endjointPos = new JointPos(43.651, -70.284, 91.057, -109.075, -88.768, -83.382);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (enable) {
            robot.LinArcFIRPlanningStart(5000.0, 5000.0, 5000.0, 5000.0);
            robot.MoveL(startjointPos, startdescPose, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
            robot.MoveL(endjointPos, enddescPose, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
            robot.LinArcFIRPlanningEnd();
        } else {
            robot.MoveL(startjointPos, startdescPose, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
            robot.MoveL(endjointPos, enddescPose, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        }
    }

    public static void FIRLinL(Robot robot, boolean enable) {
        DescPose startdescPose = new DescPose(-608.42, 610.692, 314.93, -176.438, -1.756, 117.333);
        JointPos startjointPos = new JointPos(-56.153, -46.964, 68.015, -113.2, -86.661, -83.479);
        DescPose enddescPose = new DescPose(-366.397, -572.427, 418.339, -178.972, 1.829, -142.97);
        JointPos endjointPos = new JointPos(43.651, -70.284, 91.057, -109.075, -88.768, -83.382);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (enable) {
            robot.LinArcFIRPlanningStart(5000.0, 5000.0, 5000.0, 5000.0);
            robot.MoveL(startjointPos, startdescPose, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
            robot.MoveL(endjointPos, enddescPose, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
            robot.LinArcFIRPlanningEnd();
        } else {
            robot.MoveL(startjointPos, startdescPose, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
            robot.MoveL(endjointPos, enddescPose, 0, 0, 100.0, 100.0, 100.0, -1.0, exaxisPos, 0, 0, offdese, 1, 1);
        }
    }

    public static void FIRPTP(Robot robot, boolean enable) {
        DescPose startdescPose = new DescPose(-569.71, -132.595, 395.147, 178.418, -1.893, 171.051);
        JointPos startjointPos = new JointPos(-2.334, -79.3, 108.196, -120.594, -91.79, -83.386);
        DescPose enddescPose = new DescPose(-366.397, -572.427, 418.339, -178.972, 1.829, -142.97);
        JointPos endjointPos = new JointPos(43.651, -70.284, 91.057, -109.075, -88.768, -83.382);
        ExaxisPos exaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        DescPose offdese = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        if (enable) {
            robot.PtpFIRPlanningStart(1000.0);
            robot.MoveJ(startjointPos, startdescPose, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
            robot.MoveJ(endjointPos, enddescPose, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
            robot.PtpFIRPlanningEnd();
        } else {
            robot.MoveJ(startjointPos, startdescPose, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
            robot.MoveJ(endjointPos, enddescPose, 0, 0, 100.0, 100.0, 100.0, exaxisPos, -1.0, 0, offdese);
        }
    }
}

