/*
 * Decompiled with CFR 0.152.
 */
package fairino;

import fairino.Axis485Param;
import fairino.AxleComParam;
import fairino.Coord;
import fairino.DescOffset;
import fairino.DescPose;
import fairino.DescTran;
import fairino.DeviceConfig;
import fairino.ExaxisPos;
import fairino.FRLog;
import fairino.ForceTorque;
import fairino.FrLogLevel;
import fairino.FrLogType;
import fairino.JointPos;
import fairino.MassCenter;
import fairino.ROBOT_STATE_PKG;
import fairino.RobotStateRoutineThread;
import fairino.SpiralParam;
import fairino.TCPClient;
import fairino.UDPComParam;
import fairino.WeldCurrentAORelation;
import fairino.WeldVoltageAORelation;
import fairino.WeldingProcessParam;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class Robot {
    String SDK_VERSION = "JavaSDK V1.0.9  WebApp V3.7.5";
    private String robotIp = "192.168.58.2";
    int ROBOT_CMD_PORT = 8080;
    int MAX_UPLOAD_FILE_SIZE = 524288000;
    private int PauseMotionCnt = 0;
    private int ResumeMotionCnt = 0;
    private boolean isSendCmd = false;
    private String sendBuf = "";
    private boolean reconnEnable = true;
    private int reconnTimes = 20;
    private int reconnPeriod = 2000;
    XmlRpcClientConfigImpl config;
    XmlRpcClient client;
    FRLog log;
    RobotStateRoutineThread robotStateRoutineThread;
    int sockErr = 0;
    TCPClient clientCmd;
    private static int cnt = 0;

    public int RPC(String ip) {
        try {
            this.robotIp = ip;
            this.config = new XmlRpcClientConfigImpl();
            this.config.setServerURL(new URL("http://" + ip + ":20003/RPC2"));
            this.config.setEnabledForExtensions(true);
            this.config.setConnectionTimeout(1000000);
            this.client = new XmlRpcClient();
            this.client.setConfig((XmlRpcClientConfig)this.config);
            this.sockErr = 0;
            this.robotStateRoutineThread = new RobotStateRoutineThread(this.robotIp);
            this.robotStateRoutineThread.start();
            this.Sleep(1000);
            if (this.robotStateRoutineThread != null) {
                this.robotStateRoutineThread.SetReconnectParam(this.reconnEnable, this.reconnTimes, this.reconnPeriod);
                this.robotStateRoutineThread.clientRobotState.SetLog(this.log);
            }
            if (this.IsSockComError()) {
                return this.sockErr;
            }
            this.clientCmd = new TCPClient(this.robotIp, this.ROBOT_CMD_PORT);
            boolean rtn = this.clientCmd.Connect();
            if (!rtn) {
                this.sockErr = -2;
                return this.sockErr;
            }
            return this.sockErr;
        }
        catch (Throwable e) {
            System.out.println("RPC exception   " + e.getMessage());
            return -2;
        }
    }

    public int CloseRPC() {
        this.robotStateRoutineThread.getRobotRealTimeFlag = false;
        this.robotStateRoutineThread.interrupt();
        this.sockErr = 0;
        if (this.clientCmd != null) {
            this.clientCmd.Close();
        }
        if (this.log != null) {
            this.log.LogInfo("Close RPC");
        }
        if (this.log != null) {
            this.log.LogClose();
        }
        return 0;
    }

    public String GetSDKVersion() {
        if (this.log != null) {
            this.log.LogInfo("GetSDKVersion(" + this.SDK_VERSION + ")");
        }
        return this.SDK_VERSION;
    }

    public int SetReconnectParam(boolean enable, int times, int period) {
        try {
            this.reconnEnable = enable;
            this.reconnTimes = times;
            this.reconnPeriod = period;
            if (this.robotStateRoutineThread != null) {
                this.robotStateRoutineThread.SetReconnectParam(enable, times, period);
            }
            if (this.log != null) {
                this.log.LogInfo("SetReconnectParam(" + enable + "," + times + "," + period + ") : " + 0);
            }
        }
        finally {
            return 0;
        }
        {
        }
    }

    public int GetControllerIP(String[] ip) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetControllerIP", params);
            int rtn = (Integer)result[0];
            ip[0] = (String)result[1];
            if (this.log != null) {
                this.log.LogInfo("GetControllerIP(" + ip[0] + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int Mode(int mode) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{mode};
            int rtn = (Integer)this.client.execute("Mode", params);
            if (this.log != null) {
                this.log.LogInfo("Mode(" + mode + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.Mode(mode);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception" + e.getMessage() + "  " + e.getClass().getName());
            }
            return -4;
        }
    }

    public int DragTeachSwitch(int state) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{state};
            int rtn = (Integer)this.client.execute("DragTeachSwitch", params);
            if (this.log != null) {
                this.log.LogInfo("DragTeachSwitch(" + state + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.DragTeachSwitch(state);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int RobotEnable(int state) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{state};
            int rtn = (Integer)this.client.execute("RobotEnable", params);
            if (this.log != null) {
                this.log.LogInfo("RobotEnable(" + state + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.RobotEnable(state);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int StartJOG(int refType, int nb, int dir, double vel, double acc, double max_dis) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{refType, nb, dir, vel, acc, max_dis};
            int rtn = (Integer)this.client.execute("StartJOG", params);
            if (this.log != null) {
                this.log.LogInfo("StartJOG(" + refType + ", " + nb + ", " + dir + ", " + vel + ", " + acc + ", " + max_dis + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int StopJOG(int stopType) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{stopType};
            int rtn = (Integer)this.client.execute("StopJOG", params);
            if (this.log != null) {
                this.log.LogInfo("StopJOG(" + stopType + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.StopJOG(stopType);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ImmStopJOG() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ImmStopJOG", params);
            if (this.log != null) {
                this.log.LogInfo("ImmStopJOG() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.ImmStopJOG();
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveJ(JointPos joint_pos, DescPose desc_pos, int tool, int user, double vel, double acc, double ovl, ExaxisPos epos, double blendT, int offset_flag, DescPose offset_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] joint = new Object[]{joint_pos.J1, joint_pos.J2, joint_pos.J3, joint_pos.J4, joint_pos.J5, joint_pos.J6};
            Object[] desc = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] exteraxis = new Object[]{epos.axis1, epos.axis2, epos.axis3, epos.axis4};
            Object[] offect = new Object[]{offset_pos.tran.x, offset_pos.tran.y, offset_pos.tran.z, offset_pos.rpy.rx, offset_pos.rpy.ry, offset_pos.rpy.rz};
            Object[] params = new Object[]{joint, desc, tool, user, vel, acc, ovl, exteraxis, blendT, offset_flag, offect};
            int rtn = (Integer)this.client.execute("MoveJ", params);
            if (this.log != null) {
                this.log.LogInfo("MoveJ(" + joint[0] + "," + joint[1] + "," + joint[2] + "," + joint[3] + "," + joint[4] + "," + joint[5] + "," + desc[0] + "," + desc[1] + "," + desc[2] + "," + desc[3] + "," + desc[4] + "," + desc[5] + "," + tool + "," + user + "," + vel + "," + acc + "," + ovl + "," + epos.axis1 + "," + epos.axis2 + "," + epos.axis3 + "," + epos.axis4 + "," + blendT + "," + offset_flag + "," + offect[0] + "," + offect[1] + "," + offect[2] + "," + offect[3] + "," + offect[4] + "," + offect[5] + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.MoveJ(joint_pos, desc_pos, tool, user, vel, acc, ovl, epos, blendT, offset_flag, offset_pos);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage() + "  " + Thread.currentThread().getStackTrace()[1].getLineNumber());
            }
            return -4;
        }
    }

    public int MoveL(JointPos joint_pos, DescPose desc_pos, int tool, int user, double vel, double acc, double ovl, double blendR, ExaxisPos epos, int search, int offset_flag, DescPose offset_pos, int overSpeedStrategy, int speedPercent) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            int rtn = -1;
            if (overSpeedStrategy > 1) {
                Object[] paramProtectStart = new Object[]{overSpeedStrategy, speedPercent};
                rtn = (Integer)this.client.execute("JointOverSpeedProtectStart", paramProtectStart);
                if (this.log != null) {
                    this.log.LogInfo("JointOverSpeedProtectStart(" + overSpeedStrategy + "," + speedPercent + ") : " + rtn);
                }
                if (rtn != 0) {
                    return rtn;
                }
            }
            Object[] joint = new Object[]{joint_pos.J1, joint_pos.J2, joint_pos.J3, joint_pos.J4, joint_pos.J5, joint_pos.J6};
            Object[] desc = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] exteraxis = new Object[]{epos.axis1, epos.axis2, epos.axis3, epos.axis4};
            Object[] offect = new Object[]{offset_pos.tran.x, offset_pos.tran.y, offset_pos.tran.z, offset_pos.rpy.rx, offset_pos.rpy.ry, offset_pos.rpy.rz};
            Object[] params = new Object[]{joint, desc, tool, user, vel, acc, ovl, blendR, exteraxis, search, offset_flag, offect};
            rtn = (Integer)this.client.execute("MoveL", params);
            if (this.log != null) {
                this.log.LogInfo("MoveL(" + joint[0] + "," + joint[1] + "," + joint[2] + "," + joint[3] + "," + joint[4] + "," + joint[5] + "," + desc[0] + "," + desc[1] + "," + desc[2] + "," + desc[3] + "," + desc[4] + "," + desc[5] + "," + tool + "," + user + "," + vel + "," + acc + "," + ovl + "," + blendR + epos.axis1 + "," + epos.axis2 + "," + epos.axis3 + "," + epos.axis4 + "," + search + "," + offset_flag + "," + offect[0] + "," + offect[1] + "," + offect[2] + "," + offect[3] + "," + offect[4] + "," + offect[5] + ") : " + rtn);
            }
            if (overSpeedStrategy > 1) {
                Object[] paramProtectStart = new Object[]{};
                rtn = (Integer)this.client.execute("JointOverSpeedProtectEnd", params);
                if (this.log != null) {
                    this.log.LogInfo("JointOverSpeedProtectEnd() : " + rtn);
                }
                if (rtn != 0) {
                    return rtn;
                }
            }
            return rtn;
        }
        catch (Throwable e) {
            if (!this.IsSockComError()) {
                return this.MoveL(joint_pos, desc_pos, tool, user, vel, acc, ovl, blendR, epos, search, offset_flag, offset_pos, overSpeedStrategy, speedPercent);
            }
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveC(JointPos joint_pos_p, DescPose desc_pos_p, int ptool, int puser, double pvel, double pacc, ExaxisPos epos_p, int poffset_flag, DescPose offset_pos_p, JointPos joint_pos_t, DescPose desc_pos_t, int ttool, int tuser, double tvel, double tacc, ExaxisPos epos_t, int toffset_flag, DescPose offset_pos_t, double ovl, double blendR) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] jointP = new Object[]{joint_pos_p.J1, joint_pos_p.J2, joint_pos_p.J3, joint_pos_p.J4, joint_pos_p.J5, joint_pos_p.J6};
            Object[] descP = new Object[]{desc_pos_p.tran.x, desc_pos_p.tran.y, desc_pos_p.tran.z, desc_pos_p.rpy.rx, desc_pos_p.rpy.ry, desc_pos_p.rpy.rz};
            Object[] exteraxisP = new Object[]{epos_p.axis1, epos_p.axis2, epos_p.axis3, epos_p.axis4};
            Object[] offectP = new Object[]{offset_pos_p.tran.x, offset_pos_p.tran.y, offset_pos_p.tran.z, offset_pos_p.rpy.rx, offset_pos_p.rpy.ry, offset_pos_p.rpy.rz};
            Object[] controlP = new Object[]{(double)ptool, (double)puser, pvel, pacc};
            Object[] jointT = new Object[]{joint_pos_t.J1, joint_pos_t.J2, joint_pos_t.J3, joint_pos_t.J4, joint_pos_t.J5, joint_pos_t.J6};
            Object[] descT = new Object[]{desc_pos_t.tran.x, desc_pos_t.tran.y, desc_pos_t.tran.z, desc_pos_t.rpy.rx, desc_pos_t.rpy.ry, desc_pos_t.rpy.rz};
            Object[] exteraxisT = new Object[]{epos_t.axis1, epos_t.axis2, epos_t.axis3, epos_t.axis4};
            Object[] offectT = new Object[]{offset_pos_t.tran.x, offset_pos_t.tran.y, offset_pos_t.tran.z, offset_pos_t.rpy.rx, offset_pos_t.rpy.ry, offset_pos_t.rpy.rz};
            Object[] controlT = new Object[]{(double)ttool, (double)tuser, tvel, tacc};
            Object[] params = new Object[]{jointP, descP, controlP, exteraxisP, poffset_flag, offectP, jointT, descT, controlT, exteraxisT, toffset_flag, offectT, ovl, blendR};
            int rtn = (Integer)this.client.execute("MoveC", params);
            if (this.log != null) {
                this.log.LogInfo("MoveC(" + jointP[0] + "," + jointP[1] + "," + jointP[2] + "," + jointP[3] + "," + jointP[4] + "," + jointP[5] + "," + descP[0] + "," + descP[1] + "," + descP[2] + "," + descP[3] + "," + descP[4] + "," + descP[5] + "," + ptool + "," + puser + "," + pvel + "," + pacc + "," + epos_p.axis1 + "," + epos_p.axis2 + "," + epos_p.axis3 + "," + epos_p.axis4 + "," + poffset_flag + "," + offectP[0] + "," + offectP[1] + "," + offectP[2] + "," + offectP[3] + "," + offectP[4] + "," + offectP[5] + ",) " + jointT[0] + "," + jointT[1] + "," + jointT[2] + "," + jointT[3] + "," + jointT[4] + "," + jointT[5] + "," + descT[0] + "," + descT[1] + "," + descT[2] + "," + descT[3] + "," + descT[4] + "," + descT[5] + "," + ttool + "," + tuser + "," + tvel + "," + tacc + "," + epos_t.axis1 + "," + epos_t.axis2 + "," + epos_t.axis3 + "," + epos_t.axis4 + "," + toffset_flag + "," + offectT[0] + "," + offectT[1] + "," + offectT[2] + "," + offectT[3] + "," + offectT[4] + "," + offectT[5] + "," + ovl + "," + blendR + " ): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.MoveC(joint_pos_p, desc_pos_p, ptool, puser, pvel, pacc, epos_p, poffset_flag, offset_pos_p, joint_pos_t, desc_pos_t, ttool, tuser, tvel, tacc, epos_t, toffset_flag, offset_pos_t, ovl, blendR);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int Circle(JointPos joint_pos_p, DescPose desc_pos_p, int ptool, int puser, double pvel, double pacc, ExaxisPos epos_p, JointPos joint_pos_t, DescPose desc_pos_t, int ttool, int tuser, double tvel, double tacc, ExaxisPos epos_t, double ovl, int offset_flag, DescPose offset_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] jointP = new Object[]{joint_pos_p.J1, joint_pos_p.J2, joint_pos_p.J3, joint_pos_p.J4, joint_pos_p.J5, joint_pos_p.J6};
            Object[] descP = new Object[]{desc_pos_p.tran.x, desc_pos_p.tran.y, desc_pos_p.tran.z, desc_pos_p.rpy.rx, desc_pos_p.rpy.ry, desc_pos_p.rpy.rz};
            Object[] exteraxisP = new Object[]{epos_p.axis1, epos_p.axis2, epos_p.axis3, epos_p.axis4};
            Object[] offect = new Object[]{offset_pos.tran.x, offset_pos.tran.y, offset_pos.tran.z, offset_pos.rpy.rx, offset_pos.rpy.ry, offset_pos.rpy.rz};
            Object[] controlP = new Object[]{(double)ptool * 1.0, (double)puser * 1.0, pvel, pacc};
            Object[] jointT = new Object[]{joint_pos_t.J1, joint_pos_t.J2, joint_pos_t.J3, joint_pos_t.J4, joint_pos_t.J5, joint_pos_t.J6};
            Object[] descT = new Object[]{desc_pos_t.tran.x, desc_pos_t.tran.y, desc_pos_t.tran.z, desc_pos_t.rpy.rx, desc_pos_t.rpy.ry, desc_pos_t.rpy.rz};
            Object[] exteraxisT = new Object[]{epos_t.axis1, epos_t.axis2, epos_t.axis3, epos_t.axis4};
            Object[] controlT = new Object[]{(double)ttool * 1.0, (double)tuser * 1.0, tvel, tacc};
            Object[] params = new Object[]{jointP, descP, controlP, exteraxisP, jointT, descT, controlT, exteraxisT, ovl, offset_flag, offect};
            int rtn = (Integer)this.client.execute("Circle", params);
            if (this.log != null) {
                this.log.LogInfo("Circle(" + jointP[0] + "," + jointP[1] + "," + jointP[2] + "," + jointP[3] + "," + jointP[4] + "," + jointP[5] + "," + descP[0] + "," + descP[1] + "," + descP[2] + "," + descP[3] + "," + descP[4] + "," + descP[5] + "," + ptool + "," + puser + "," + pvel + "," + pacc + "," + epos_p.axis1 + "," + epos_p.axis2 + "," + epos_p.axis3 + "," + epos_p.axis4 + ",) " + jointT[0] + "," + jointT[1] + "," + jointT[2] + "," + jointT[3] + "," + jointT[4] + "," + jointT[5] + "," + descT[0] + "," + descT[1] + "," + descT[2] + "," + descT[3] + "," + descT[4] + "," + descT[5] + "," + ttool + "," + tuser + "," + tvel + "," + tacc + "," + epos_t.axis1 + "," + epos_t.axis2 + "," + epos_t.axis3 + "," + epos_t.axis4 + "," + ovl + "," + offset_flag + "," + offect[0] + "," + offect[1] + "," + offect[2] + "," + offect[3] + "," + offect[4] + "," + offect[5] + " : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.Circle(joint_pos_p, desc_pos_p, ptool, puser, pvel, pacc, epos_p, joint_pos_t, desc_pos_t, ttool, tuser, tvel, tacc, epos_t, ovl, offset_flag, offset_pos);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int NewSpiral(JointPos joint_pos, DescPose desc_pos, int tool, int user, double vel, double acc, ExaxisPos epos, double ovl, int offset_flag, DescPose offset_pos, SpiralParam spiral_param) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] jointPos = new Object[]{joint_pos.J1, joint_pos.J2, joint_pos.J3, joint_pos.J4, joint_pos.J5, joint_pos.J6};
            Object[] descPos = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] exteraxisPos = new Object[]{epos.axis1, epos.axis2, epos.axis3, epos.axis4};
            Object[] offectPos = new Object[]{offset_pos.tran.x, offset_pos.tran.y, offset_pos.tran.z, offset_pos.rpy.rx, offset_pos.rpy.ry, offset_pos.rpy.rz};
            Object[] spiralParam = new Object[]{(double)spiral_param.circle_num * 1.0, spiral_param.circle_angle, spiral_param.rad_init, spiral_param.rad_add, spiral_param.rotaxis_add, (double)spiral_param.rot_direction * 1.0};
            Object[] params = new Object[]{jointPos, descPos, tool, user, vel, acc, exteraxisPos, ovl, offset_flag, offectPos, spiralParam};
            int rtn = (Integer)this.client.execute("NewSpiral", params);
            if (this.log != null) {
                this.log.LogInfo("NewSpiral(" + jointPos[0] + "," + jointPos[1] + "," + jointPos[2] + "," + jointPos[3] + "," + jointPos[4] + "," + jointPos[5] + "," + descPos[0] + "," + descPos[1] + "," + descPos[2] + "," + descPos[3] + "," + descPos[4] + "," + descPos[5] + "," + tool + "," + user + "," + vel + "," + acc + "," + epos.axis1 + "," + epos.axis2 + "," + epos.axis3 + "," + epos.axis4 + "," + ovl + "," + offset_flag + ",) " + offectPos[0] + "," + offectPos[1] + "," + offectPos[2] + "," + offectPos[3] + "," + offectPos[4] + "," + offectPos[5] + "," + spiralParam[0] + "," + spiralParam[1] + "," + spiralParam[2] + "," + spiralParam[3] + "," + spiralParam[4] + "," + spiralParam[5] + " : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.NewSpiral(joint_pos, desc_pos, tool, user, vel, acc, epos, ovl, offset_flag, offset_pos, spiral_param);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ServoMoveStart() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ServoMoveStart", params);
            if (this.log != null) {
                this.log.LogInfo("ServoMoveStart(" + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.ServoMoveStart();
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ServoMoveEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ServoMoveEnd", params);
            if (this.log != null) {
                this.log.LogInfo("ServoMoveEnd(" + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.ServoMoveEnd();
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ServoJ(JointPos joint_pos, ExaxisPos axisPos, double acc, double vel, double cmdT, double filterT, double gain) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] jointPos = new Object[]{joint_pos.J1, joint_pos.J2, joint_pos.J3, joint_pos.J4, joint_pos.J5, joint_pos.J6};
            Object[] axis = new Object[]{axisPos.axis1, axisPos.axis2, axisPos.axis3, axisPos.axis4};
            Object[] params = new Object[]{jointPos, axis, acc, vel, cmdT, filterT, gain};
            int rtn = (Integer)this.client.execute("ServoJ", params);
            if (this.log != null) {
                this.log.LogInfo("ServoJ(" + Arrays.toString(jointPos) + "," + Arrays.toString(axis) + "," + acc + "," + vel + "," + cmdT + "," + filterT + "," + gain + " ): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.ServoJ(joint_pos, axisPos, acc, vel, cmdT, filterT, gain);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ServoCart(int mode, DescPose desc_pose, Object[] pos_gain, double acc, double vel, double cmdT, double filterT, double gain) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] descPos = new Object[]{desc_pose.tran.x, desc_pose.tran.y, desc_pose.tran.z, desc_pose.rpy.rx, desc_pose.rpy.ry, desc_pose.rpy.rz};
            Object[] params = new Object[]{mode, descPos, pos_gain, acc, vel, cmdT, filterT, gain};
            int rtn = (Integer)this.client.execute("ServoCart", params);
            if (this.log != null) {
                this.log.LogInfo("ServoCart(" + mode + "," + descPos[0] + "," + descPos[1] + "," + descPos[2] + "," + descPos[3] + "," + descPos[4] + "," + descPos[5] + "," + pos_gain[0] + "," + pos_gain[1] + "," + pos_gain[2] + "," + pos_gain[3] + "," + pos_gain[4] + "," + pos_gain[5] + "," + acc + "," + vel + "," + cmdT + "," + filterT + "," + gain + " : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.ServoCart(mode, desc_pose, pos_gain, acc, vel, cmdT, filterT, gain);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveCart(DescPose desc_pos, int tool, int user, double vel, double acc, double ovl, double blendT, int config) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] descPos = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] params = new Object[]{descPos, tool, user, vel, acc, ovl, blendT, config};
            int rtn = (Integer)this.client.execute("MoveCart", params);
            if (this.log != null) {
                this.log.LogInfo("MoveCart(" + descPos[0] + "," + descPos[1] + "," + descPos[2] + "," + descPos[3] + "," + descPos[4] + "," + descPos[5] + "," + tool + "," + user + "," + vel + "," + acc + "," + ovl + "," + blendT + "," + config + " ): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.MoveCart(desc_pos, tool, user, vel, acc, ovl, blendT, config);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SplineStart() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("SplineStart", params);
            if (this.log != null) {
                this.log.LogInfo("SplineStart(" + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.SplineStart();
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SplinePTP(JointPos joint_pos, DescPose desc_pos, int tool, int user, double vel, double acc, double ovl) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] jointPos = new Object[]{joint_pos.J1, joint_pos.J2, joint_pos.J3, joint_pos.J4, joint_pos.J5, joint_pos.J6};
            Object[] descPos = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] params = new Object[]{jointPos, descPos, tool, user, vel, acc, ovl};
            int rtn = (Integer)this.client.execute("SplinePTP", params);
            if (this.log != null) {
                this.log.LogInfo("SplinePTP(" + jointPos[0] + "," + jointPos[1] + "," + jointPos[2] + "," + jointPos[3] + "," + jointPos[4] + "," + jointPos[5] + "," + descPos[0] + "," + descPos[1] + "," + descPos[2] + "," + descPos[3] + "," + descPos[4] + "," + descPos[5] + "," + tool + "," + user + "," + vel + "," + acc + "," + ovl + " : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.SplinePTP(joint_pos, desc_pos, tool, user, vel, acc, ovl);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SplineEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("SplineEnd", params);
            if (this.log != null) {
                this.log.LogInfo("SplineEnd() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.SplineEnd();
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int NewSplineStart(int type, int averageTime) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{type, averageTime};
            int rtn = (Integer)this.client.execute("NewSplineStart", params);
            if (this.log != null) {
                this.log.LogInfo("NewSplineStart() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.NewSplineStart(type, averageTime);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int NewSplinePoint(JointPos joint_pos, DescPose desc_pos, int tool, int user, double vel, double acc, double ovl, double blendR, int lastFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] jointPos = new Object[]{joint_pos.J1, joint_pos.J2, joint_pos.J3, joint_pos.J4, joint_pos.J5, joint_pos.J6};
            Object[] descPos = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] params = new Object[]{jointPos, descPos, tool, user, vel, acc, ovl, blendR, lastFlag};
            int rtn = (Integer)this.client.execute("NewSplinePoint", params);
            if (this.log != null) {
                this.log.LogInfo("NewSplinePoint(" + jointPos[0] + "," + jointPos[1] + "," + jointPos[2] + "," + jointPos[3] + "," + jointPos[4] + "," + jointPos[5] + "," + descPos[0] + "," + descPos[1] + "," + descPos[2] + "," + descPos[3] + "," + descPos[4] + "," + descPos[5] + "," + tool + "," + user + "," + vel + "," + acc + "," + ovl + "," + blendR + "," + lastFlag + " : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.NewSplinePoint(joint_pos, desc_pos, tool, user, vel, acc, ovl, blendR, lastFlag);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int NewSplineEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("NewSplineEnd", params);
            if (this.log != null) {
                this.log.LogInfo("NewSplineEnd() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.NewSplineEnd();
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int StopMotion() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("StopMotion", params);
            if (this.log != null) {
                this.log.LogInfo("StopMotion() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.StopMotion();
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int PauseMotion() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            this.sendBuf = "/f/bIII" + this.PauseMotionCnt + "III103III5IIIPAUSEIII/b/f";
            int rtn = this.clientCmd.Send(this.sendBuf);
            this.Sleep(20);
            byte[] recvBuf = new byte[1024];
            this.clientCmd.Recv(recvBuf);
            String recvStr = new String(recvBuf).split("/b/f")[0];
            if (this.log != null) {
                this.log.LogInfo("PauseMotion() : " + this.sockErr + "   " + this.sendBuf + "  recv  " + recvStr + "/b/f");
            }
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
        return 0;
    }

    public int ResumeMotion() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            this.sendBuf = "/f/bIII" + this.ResumeMotionCnt + "III104III6IIIRESUMEIII/b/f";
            this.clientCmd.Send(this.sendBuf);
            this.Sleep(20);
            byte[] recvBuf = new byte[1024];
            this.clientCmd.Recv(recvBuf);
            ++this.ResumeMotionCnt;
            this.isSendCmd = true;
            String recvStr = new String(recvBuf).split("/b/f")[0];
            if (this.log != null) {
                this.log.LogInfo("ResumeMotion() : " + this.sockErr + "   " + this.sendBuf + "  recv  " + recvStr + "/b/f");
            }
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
        return 0;
    }

    public int PointsOffsetEnable(int flag, DescPose offset_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] offectPos = new Object[]{offset_pos.tran.x, offset_pos.tran.y, offset_pos.tran.z, offset_pos.rpy.rx, offset_pos.rpy.ry, offset_pos.rpy.rz};
            Object[] params = new Object[]{flag, offectPos};
            int rtn = (Integer)this.client.execute("PointsOffsetEnable", params);
            if (this.log != null) {
                this.log.LogInfo("PointsOffsetEnable(" + flag + "," + offectPos[0] + "," + offectPos[1] + "," + offectPos[2] + "," + offectPos[3] + "," + offectPos[4] + "," + offectPos[5] + " : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.PointsOffsetEnable(flag, offset_pos);
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int PointsOffsetDisable() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("PointsOffsetDisable", params);
            if (this.log != null) {
                this.log.LogInfo("PointsOffsetDisable() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (e.getMessage().contains("Connection timed out") || e.getMessage().contains("connect timed out")) {
                this.PointsOffsetDisable();
            } else if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetDO(int id, int status, int smooth, int block) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, status, smooth, block};
            int rtn = (Integer)this.client.execute("SetDO", params);
            if (this.log != null) {
                this.log.LogInfo("SetDO(" + id + "," + status + "," + smooth + "," + block + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetToolDO(int id, int status, int smooth, int block) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, status, smooth, block};
            int rtn = (Integer)this.client.execute("SetToolDO", params);
            if (this.log != null) {
                this.log.LogInfo("SetToolDO(" + id + "," + status + "," + smooth + "," + block + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAO(int id, double value, int block) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, value * 40.95, block};
            int rtn = (Integer)this.client.execute("SetAO", params);
            if (this.log != null) {
                this.log.LogInfo("SetAO(" + id + "," + value + "," + block + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetToolAO(int id, double value, int block) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, value * 40.95, block};
            int rtn = (Integer)this.client.execute("SetToolAO", params);
            if (this.log != null) {
                this.log.LogInfo("SetToolAO(" + id + "," + value + "," + block + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WaitDI(int id, int status, int max_time, int opt) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, status, max_time, opt};
            int rtn = (Integer)this.client.execute("WaitDI", params);
            if (this.log != null) {
                this.log.LogInfo("WaitDI(" + id + "," + status + "," + max_time + "," + opt + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WaitMultiDI(int mode, int id, int status, int max_time, int opt) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{mode, id, status, max_time, opt};
            int rtn = (Integer)this.client.execute("WaitMultiDI", params);
            if (this.log != null) {
                this.log.LogInfo("WaitMultiDI(" + id + "," + status + "," + max_time + "," + opt + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WaitToolDI(int id, int status, int max_time, int opt) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id + 1, status, max_time, opt};
            int rtn = (Integer)this.client.execute("WaitToolDI", params);
            if (this.log != null) {
                this.log.LogInfo("WaitToolDI(" + id + "," + status + "," + max_time + "," + opt + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WaitAI(int id, int sign, double value, int max_time, int opt) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, sign, value * 40.95, max_time, opt};
            int rtn = (Integer)this.client.execute("WaitAI", params);
            if (this.log != null) {
                this.log.LogInfo("WaitAI(" + id + "," + sign + "," + id + "," + value + "," + max_time + "," + opt + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WaitToolAI(int id, int sign, double value, int max_time, int opt) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, sign, value * 40.95, max_time, opt};
            int rtn = (Integer)this.client.execute("WaitToolAI", params);
            if (this.log != null) {
                this.log.LogInfo("WaitToolAI(" + id + "," + sign + "," + id + "," + value + "," + max_time + "," + opt + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetSpeed(int vel) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{vel};
            int rtn = (Integer)this.client.execute("SetSpeed", params);
            if (this.log != null) {
                this.log.LogInfo("SetSpeed(" + vel + " ) : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetSysVarValue(int id, double value) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, value};
            int rtn = (Integer)this.client.execute("SetSysVarValue", params);
            if (this.log != null) {
                this.log.LogInfo("SetSysVarValue(" + id + "," + value + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetToolPoint(int point_num) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{point_num};
            int rtn = (Integer)this.client.execute("SetToolPoint", params);
            if (this.log != null) {
                this.log.LogInfo("SetToolPoint(" + point_num + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ComputeTool(DescPose tcp_pose) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("ComputeTool", params);
            if ((Integer)result[0] == 0) {
                tcp_pose.tran.x = (Double)result[1];
                tcp_pose.tran.y = (Double)result[2];
                tcp_pose.tran.z = (Double)result[3];
                tcp_pose.rpy.rx = (Double)result[4];
                tcp_pose.rpy.ry = (Double)result[5];
                tcp_pose.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("ComputeTool(" + tcp_pose.tran.x + "," + tcp_pose.tran.y + "," + tcp_pose.tran.z + "," + tcp_pose.rpy.rx + "," + tcp_pose.rpy.ry + "," + tcp_pose.rpy.rz + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTcp4RefPoint(int point_num) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{point_num};
            int rtn = (Integer)this.client.execute("SetTcp4RefPoint", params);
            if (this.log != null) {
                this.log.LogInfo("SetTcp4RefPoint(" + point_num + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ComputeTcp4(DescPose tcp_pose) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("ComputeTcp4", params);
            if ((Integer)result[0] == 0) {
                tcp_pose.tran.x = (Double)result[1];
                tcp_pose.tran.y = (Double)result[2];
                tcp_pose.tran.z = (Double)result[3];
                tcp_pose.rpy.rx = (Double)result[4];
                tcp_pose.rpy.ry = (Double)result[5];
                tcp_pose.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("ComputeTcp4(" + tcp_pose.tran.x + "," + tcp_pose.tran.y + ", " + tcp_pose.tran.z + "," + tcp_pose.rpy.rx + "," + tcp_pose.rpy.ry + "," + tcp_pose.rpy.rz + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ComputeToolCoordWithPoints(int method, JointPos[] pos, DescPose tool_pose) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params;
            Object[] result;
            Object[] jointPos1 = new Object[]{pos[0].J1, pos[0].J2, pos[0].J3, pos[0].J4, pos[0].J5, pos[0].J6};
            Object[] jointPos2 = new Object[]{pos[1].J1, pos[1].J2, pos[1].J3, pos[1].J4, pos[1].J5, pos[1].J6};
            Object[] jointPos3 = new Object[]{pos[2].J1, pos[2].J2, pos[2].J3, pos[2].J4, pos[2].J5, pos[2].J6};
            Object[] jointPos4 = new Object[]{pos[3].J1, pos[3].J2, pos[3].J3, pos[3].J4, pos[3].J5, pos[3].J6};
            Object[] jointPos5 = new Object[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            Object[] jointPos6 = new Object[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            if (method == 1) {
                jointPos5 = new Object[]{pos[4].J1, pos[4].J2, pos[4].J3, pos[4].J4, pos[4].J5, pos[4].J6};
                jointPos6 = new Object[]{pos[5].J1, pos[5].J2, pos[5].J3, pos[5].J4, pos[5].J5, pos[5].J6};
            }
            if ((Integer)(result = (Object[])this.client.execute("ComputeToolCoordWithPoints", params = new Object[]{method, jointPos1, jointPos2, jointPos3, jointPos4, jointPos5, jointPos6}))[0] == 0) {
                tool_pose.tran.x = (Double)result[1];
                tool_pose.tran.y = (Double)result[2];
                tool_pose.tran.z = (Double)result[3];
                tool_pose.rpy.rx = (Double)result[4];
                tool_pose.rpy.ry = (Double)result[5];
                tool_pose.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("ComputeToolCoordWithPoints(" + method + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ComputeWObjCoordWithPoints(int method, DescPose[] pos, int refFrame, DescPose tcp_pose) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] param1 = new Object[]{pos[0].tran.x, pos[0].tran.y, pos[0].tran.z, pos[0].rpy.rx, pos[0].rpy.ry, pos[0].rpy.rz};
            Object[] param2 = new Object[]{pos[1].tran.x, pos[1].tran.y, pos[1].tran.z, pos[1].rpy.rx, pos[1].rpy.ry, pos[1].rpy.rz};
            Object[] param3 = new Object[]{pos[2].tran.x, pos[2].tran.y, pos[2].tran.z, pos[2].rpy.rx, pos[2].rpy.ry, pos[2].rpy.rz};
            Object[] params = new Object[]{method, param1, param2, param3, refFrame};
            Object[] result = (Object[])this.client.execute("ComputeWObjCoordWithPoints", params);
            if ((Integer)result[0] == 0) {
                tcp_pose.tran.x = (Double)result[1];
                tcp_pose.tran.y = (Double)result[2];
                tcp_pose.tran.z = (Double)result[3];
                tcp_pose.rpy.rx = (Double)result[4];
                tcp_pose.rpy.ry = (Double)result[5];
                tcp_pose.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("ComputeWObjCoordWithPoints(" + method + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeldingSetCheckArcInterruptionParam(int checkEnable, int arcInterruptTimeLength) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{checkEnable, arcInterruptTimeLength};
            int rtn = (Integer)this.client.execute("WeldingSetCheckArcInterruptionParam", params);
            if (this.log != null) {
                this.log.LogInfo("WeldingSetCheckArcInterruptionParam() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Integer> WeldingGetCheckArcInterruptionParam() {
        int rtn = -1;
        int checkEnable = 0;
        int arcInterruptTimeLength = 0;
        ArrayList<Integer> rtnArray = new ArrayList<Integer>(){};
        rtnArray.add(rtn);
        rtnArray.add(checkEnable);
        rtnArray.add(arcInterruptTimeLength);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("WeldingGetCheckArcInterruptionParam", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Integer)result[1]);
                rtnArray.set(2, (Integer)result[2]);
            }
            if (this.log != null) {
                this.log.LogInfo("WeldingGetCheckArcInterruptionParam(" + result[1] + ",  " + result[2] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int WeldingSetReWeldAfterBreakOffParam(int enable, double length, double velocity, int moveType) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{enable, length, velocity, moveType};
            int rtn = (Integer)this.client.execute("WeldingSetReWeldAfterBreakOffParam", params);
            if (this.log != null) {
                this.log.LogInfo("WeldingSetReWeldAfterBreakOffParam(" + enable + "," + length + "," + velocity + "," + moveType + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Number> WeldingGetReWeldAfterBreakOffParam() {
        int rtn = -1;
        int enable = 0;
        double length = 0.0;
        double velocity = 0.0;
        int moveType = 0;
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(rtn);
        rtnArray.add(enable);
        rtnArray.add(length);
        rtnArray.add(velocity);
        rtnArray.add(moveType);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("WeldingGetReWeldAfterBreakOffParam", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Integer)result[1]);
                rtnArray.set(2, (Double)result[2]);
                rtnArray.set(3, (Double)result[3]);
                rtnArray.set(4, (Integer)result[4]);
            }
            if (this.log != null) {
                this.log.LogInfo("WeldingGetReWeldAfterBreakOffParam(" + result[1] + ",  " + result[2] + ",  " + result[3] + ",  " + result[4] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int WeldingStartReWeldAfterBreakOff() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("WeldingStartReWeldAfterBreakOff", params);
            if (this.log != null) {
                this.log.LogInfo("WeldingStartReWeldAfterBreakOff: " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeldingAbortWeldAfterBreakOff() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("WeldingAbortWeldAfterBreakOff", params);
            if (this.log != null) {
                this.log.LogInfo("WeldingAbortWeldAfterBreakOff: " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetToolCoord(int id, DescPose coord, int type, int install, int toolID, int loadNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] descCoord = new Object[]{coord.tran.x, coord.tran.y, coord.tran.z, coord.rpy.rx, coord.rpy.ry, coord.rpy.rz};
            Object[] params = new Object[]{id, descCoord, type, install, toolID, loadNum};
            int rtn = (Integer)this.client.execute("SetToolCoord", params);
            if (this.log != null) {
                this.log.LogInfo("SetToolCoord(" + id + "," + descCoord[0] + "," + descCoord[1] + "," + descCoord[2] + "," + descCoord[3] + "," + descCoord[4] + "," + descCoord[5] + "," + type + "," + install + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetToolList(int id, DescPose coord, int type, int install, int loadNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] descCoord = new Object[]{coord.tran.x, coord.tran.y, coord.tran.z, coord.rpy.rx, coord.rpy.ry, coord.rpy.rz};
            Object[] params = new Object[]{id, descCoord, type, install, loadNum};
            int rtn = (Integer)this.client.execute("SetToolList", params);
            if (this.log != null) {
                this.log.LogInfo("SetToolList(" + id + "," + descCoord[0] + "," + descCoord[1] + "," + descCoord[2] + "," + descCoord[3] + "," + descCoord[4] + "," + descCoord[5] + "," + type + "," + install + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetExTCPPoint(int point_num) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{point_num};
            int rtn = (Integer)this.client.execute("SetExTCPPoint", params);
            if (this.log != null) {
                this.log.LogInfo("SetExTCPPoint(" + point_num + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ComputeExTCF(DescPose tcp_pose) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("ComputeExTCF", params);
            if ((Integer)result[0] == 0) {
                tcp_pose.tran.x = (Double)result[1];
                tcp_pose.tran.y = (Double)result[2];
                tcp_pose.tran.z = (Double)result[3];
                tcp_pose.rpy.rx = (Double)result[4];
                tcp_pose.rpy.ry = (Double)result[5];
                tcp_pose.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("ComputeExTCF(" + tcp_pose.tran.x + "," + tcp_pose.tran.y + "," + tcp_pose.tran.z + "," + tcp_pose.rpy.rx + "," + tcp_pose.rpy.ry + "," + tcp_pose.rpy.rz + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetExToolCoord(int id, DescPose etcp, DescPose etool) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] descEtcp = new Object[]{etcp.tran.x, etcp.tran.y, etcp.tran.z, etcp.rpy.rx, etcp.rpy.ry, etcp.rpy.rz};
            Object[] descEtool = new Object[]{etool.tran.x, etool.tran.y, etool.tran.z, etool.rpy.rx, etool.rpy.ry, etool.rpy.rz};
            Object[] params = new Object[]{id, descEtcp, descEtool};
            int rtn = (Integer)this.client.execute("SetExToolCoord", params);
            if (this.log != null) {
                this.log.LogInfo("SetExToolCoord(" + id + "," + descEtcp[0] + "," + descEtcp[1] + "," + descEtcp[2] + "," + descEtcp[3] + "," + descEtcp[4] + "," + descEtcp[5] + "," + descEtool[0] + "," + descEtool[1] + "," + descEtool[2] + "," + descEtool[3] + "," + descEtool[4] + "," + descEtool[5] + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetExToolList(int id, DescPose etcp, DescPose etool) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] descEtcp = new Object[]{etcp.tran.x, etcp.tran.y, etcp.tran.z, etcp.rpy.rx, etcp.rpy.ry, etcp.rpy.rz};
            Object[] descEtool = new Object[]{etool.tran.x, etool.tran.y, etool.tran.z, etool.rpy.rx, etool.rpy.ry, etool.rpy.rz};
            Object[] params = new Object[]{id, descEtcp, descEtool};
            int rtn = (Integer)this.client.execute("SetExToolList", params);
            if (this.log != null) {
                this.log.LogInfo("SetExToolList(" + id + "," + descEtcp[0] + "," + descEtcp[1] + "," + descEtcp[2] + "," + descEtcp[3] + "," + descEtcp[4] + "," + descEtcp[5] + "," + descEtool[0] + "," + descEtool[1] + "," + descEtool[2] + "," + descEtool[3] + "," + descEtool[4] + "," + descEtool[5] + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetWObjCoordPoint(int point_num) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{point_num};
            int rtn = (Integer)this.client.execute("SetWObjCoordPoint", params);
            if (this.log != null) {
                this.log.LogInfo("SetWObjCoordPoint(" + point_num + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ComputeWObjCoord(int method, int refFrame, DescPose wobj_pose) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{method, refFrame};
            Object[] result = (Object[])this.client.execute("ComputeWObjCoord", params);
            if ((Integer)result[0] == 0) {
                wobj_pose.tran.x = (Double)result[1];
                wobj_pose.tran.y = (Double)result[2];
                wobj_pose.tran.z = (Double)result[3];
                wobj_pose.rpy.rx = (Double)result[4];
                wobj_pose.rpy.ry = (Double)result[5];
                wobj_pose.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("ComputeWObjCoord(" + wobj_pose.tran.x + "," + wobj_pose.tran.y + "," + wobj_pose.tran.z + "," + wobj_pose.rpy.rx + "," + wobj_pose.rpy.ry + "," + wobj_pose.rpy.rz + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LaserSensorRecord(int status, int delayMode, int delayTime, int delayDisExAxisNum, double delayDis, double sensitivePara, double speed) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{status, delayMode, delayTime, delayDisExAxisNum, delayDis, sensitivePara, speed};
            int rtn = (Integer)this.client.execute("LaserSensorRecord", params);
            if (this.log != null) {
                this.log.LogInfo("LaserSensorRecord() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LaserTrackingLaserOn(int weldId) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weldId};
            int rtn = (Integer)this.client.execute("LaserTrackingLaserOn", params);
            if (this.log != null) {
                this.log.LogInfo("LaserTrackingLaserOn(" + weldId + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LaserTrackingLaserOff() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("LaserTrackingLaserOff", params);
            if (this.log != null) {
                this.log.LogInfo("LaserTrackingLaserOff() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LaserTrackingTrackOn(int coordId) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{coordId};
            int rtn = (Integer)this.client.execute("LaserTrackingTrackOn", params);
            if (this.log != null) {
                this.log.LogInfo("LaserTrackingTrackOn() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LaserTrackingTrackOff() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("LaserTrackingTrackOff", params);
            if (this.log != null) {
                this.log.LogInfo("LaserTrackingTrackOff() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LaserTrackingSearchStart(int direction, DescTran directionPoint, int vel, int distance, int timeout, int posSensorNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{direction, directionPoint.x, directionPoint.y, directionPoint.z, vel, distance, timeout, posSensorNum};
            int rtn = (Integer)this.client.execute("LaserTrackingSearchStart", params);
            if (this.log != null) {
                this.log.LogInfo("LaserTrackingSearchStart() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LaserTrackingSearchStop() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("LaserTrackingSearchStop", params);
            if (this.log != null) {
                this.log.LogInfo("LaserTrackingSearchStop() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetWObjCoord(int id, DescPose coord, int refFrame) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] descCoord = new Object[]{coord.tran.x, coord.tran.y, coord.tran.z, coord.rpy.rx, coord.rpy.ry, coord.rpy.rz};
            Object[] params = new Object[]{id, descCoord, refFrame};
            int rtn = (Integer)this.client.execute("SetWObjCoord", params);
            if (this.log != null) {
                this.log.LogInfo("SetWObjCoord(" + id + "," + descCoord[0] + "," + descCoord[1] + "," + descCoord[2] + "," + descCoord[3] + "," + descCoord[4] + "," + descCoord[5] + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetWObjList(int id, DescPose coord, int refFrame) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] descCoord = new Object[]{coord.tran.x, coord.tran.y, coord.tran.z, coord.rpy.rx, coord.rpy.ry, coord.rpy.rz};
            Object[] params = new Object[]{id, descCoord, refFrame};
            int rtn = (Integer)this.client.execute("SetWObjList", params);
            if (this.log != null) {
                this.log.LogInfo("SetWObjList(" + id + "," + descCoord[0] + "," + descCoord[1] + "," + descCoord[2] + "," + descCoord[3] + "," + descCoord[4] + "," + descCoord[5] + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetLoadWeight(int loadNum, double weight) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{loadNum, weight};
            int rtn = (Integer)this.client.execute("SetLoadWeight", params);
            if (this.log != null) {
                this.log.LogInfo("SetLoadWeight(" + weight + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetLoadCoord(DescTran coord) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{coord.x, coord.y, coord.z};
            int rtn = (Integer)this.client.execute("SetLoadCoord", params);
            if (this.log != null) {
                this.log.LogInfo("SetLoadCoord(" + coord.x + "," + coord.y + "," + coord.z + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetRobotInstallPos(int install) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{install};
            int rtn = (Integer)this.client.execute("SetRobotInstallPos", params);
            if (this.log != null) {
                this.log.LogInfo("SetRobotInstallPos(" + install + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetRobotInstallAngle(double yangle, double zangle) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{yangle, zangle};
            int rtn = (Integer)this.client.execute("SetRobotInstallAngle", params);
            if (this.log != null) {
                this.log.LogInfo("SetRobotInstallAngle(" + yangle + "," + zangle + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WaitMs(int t_ms) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{t_ms};
            int rtn = (Integer)this.client.execute("WaitMs", params);
            if (this.log != null) {
                this.log.LogInfo("WaitMs(" + t_ms + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAnticollision(int mode, Object[] level, int config) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] collisionLevel = mode == 1 ? level : level;
            Object[] params = new Object[]{mode, collisionLevel, config};
            int rtn = (Integer)this.client.execute("SetAnticollision", params);
            if (this.log != null) {
                this.log.LogInfo("SetAnticollision(" + mode + "," + collisionLevel[0] + "," + collisionLevel[1] + "," + collisionLevel[2] + "," + collisionLevel[3] + "," + collisionLevel[4] + "," + collisionLevel[5] + "," + config + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetCollisionStrategy(int strategy, int safeTime, int safeDistance, int safeVel, int[] safetyMargin) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] safety = new Object[]{safetyMargin[0], safetyMargin[1], safetyMargin[2], safetyMargin[3], safetyMargin[4], safetyMargin[5]};
            Object[] params = new Object[]{strategy, safeTime, safeDistance, safeVel, safety};
            System.out.println(Arrays.toString(safetyMargin));
            int rtn = (Integer)this.client.execute("SetCollisionStrategy", params);
            if (this.log != null) {
                this.log.LogInfo("SetCollisionStrategy(" + strategy + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetLimitPositive(Object[] limit) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{limit};
            int rtn = (Integer)this.client.execute("SetLimitPositive", params);
            if (this.log != null) {
                this.log.LogInfo("SetLimitPositive(" + Arrays.toString(limit) + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetLimitNegative(Object[] limit) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{limit};
            int rtn = (Integer)this.client.execute("SetLimitNegative", params);
            if (this.log != null) {
                this.log.LogInfo("SetLimitNegative(" + Arrays.toString(limit) + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ResetAllError() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ResetAllError", params);
            if (this.log != null) {
                this.log.LogInfo("ResetAllError() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FrictionCompensationOnOff(int state) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{state};
            int rtn = (Integer)this.client.execute("FrictionCompensationOnOff", params);
            if (this.log != null) {
                this.log.LogInfo("FrictionCompensationOnOff(" + state + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetFrictionValue_level(Object[] coeff) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{coeff};
            int rtn = (Integer)this.client.execute("SetFrictionValue_level", params);
            if (this.log != null) {
                this.log.LogInfo("SetFrictionValue_level(" + Arrays.toString(coeff) + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetFrictionValue_wall(Object[] coeff) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{coeff};
            int rtn = (Integer)this.client.execute("SetFrictionValue_wall", params);
            if (this.log != null) {
                this.log.LogInfo("SetFrictionValue_wall(" + Arrays.toString(coeff) + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetFrictionValue_ceiling(Object[] coeff) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{coeff};
            int rtn = (Integer)this.client.execute("SetFrictionValue_ceiling", params);
            if (this.log != null) {
                this.log.LogInfo("SetFrictionValue_ceiling(" + Arrays.toString(coeff) + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetFrictionValue_freedom(Object[] coeff) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{coeff};
            int rtn = (Integer)this.client.execute("SetFrictionValue_freedom", params);
            if (this.log != null) {
                this.log.LogInfo("SetFrictionValue_freedom(" + Arrays.toString(coeff) + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Number> GetRobotInstallAngle() {
        int rtn = -1;
        double yAngle = 0.0;
        double zAngle = 0.0;
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(rtn);
        rtnArray.add(yAngle);
        rtnArray.add(zAngle);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetRobotInstallAngle", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Double)result[1]);
                rtnArray.set(2, (Double)result[2]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetRobotInstallAngle(" + result[1] + ",  " + result[2] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public List<Number> GetSysVarValue(int id) {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(-1);
        rtnArray.add(0.0);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{id};
            Object[] result = (Object[])this.client.execute("GetSysVarValue", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Double)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetSysVarValue(" + id + ",  " + result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int GetActualJointPosDegree(JointPos jPos) {
        int errcode = 0;
        if (this.sockErr == 0) {
            jPos.J1 = this.robotStateRoutineThread.pkg.jt_cur_pos[0];
            jPos.J2 = this.robotStateRoutineThread.pkg.jt_cur_pos[1];
            jPos.J3 = this.robotStateRoutineThread.pkg.jt_cur_pos[2];
            jPos.J4 = this.robotStateRoutineThread.pkg.jt_cur_pos[3];
            jPos.J5 = this.robotStateRoutineThread.pkg.jt_cur_pos[4];
            jPos.J6 = this.robotStateRoutineThread.pkg.jt_cur_pos[5];
        } else {
            errcode = this.sockErr;
        }
        if (this.log != null) {
            this.log.LogInfo("GetActualJointPosDegree(,  " + jPos.J1 + "," + jPos.J2 + "," + jPos.J3 + "," + jPos.J4 + ") : " + errcode);
        }
        return errcode;
    }

    public int GetActualJointSpeedsDegree(Object[] speed) {
        int errcode = 0;
        if (this.sockErr == 0) {
            for (int i = 0; i < 6; ++i) {
                speed[i] = this.robotStateRoutineThread.pkg.actual_qd[i];
            }
        } else {
            errcode = this.sockErr;
        }
        if (this.log != null) {
            this.log.LogInfo("GetActualJointSpeedsDegree(," + speed[0] + "," + speed[1] + ",  " + speed[2] + ",  " + speed[3] + ",  " + speed[4] + ",  " + speed[5] + ") : " + errcode);
        }
        return errcode;
    }

    public int GetActualTCPPose(DescPose desc_pos) {
        int errcode = 0;
        if (this.sockErr == 0) {
            desc_pos.tran.x = this.robotStateRoutineThread.pkg.tl_cur_pos[0];
            desc_pos.tran.y = this.robotStateRoutineThread.pkg.tl_cur_pos[1];
            desc_pos.tran.z = this.robotStateRoutineThread.pkg.tl_cur_pos[2];
            desc_pos.rpy.rx = this.robotStateRoutineThread.pkg.tl_cur_pos[3];
            desc_pos.rpy.ry = this.robotStateRoutineThread.pkg.tl_cur_pos[4];
            desc_pos.rpy.rz = this.robotStateRoutineThread.pkg.tl_cur_pos[5];
        } else {
            errcode = this.sockErr;
        }
        if (this.log != null) {
            this.log.LogInfo("GetActualTCPPose(,  " + desc_pos.tran.x + "," + desc_pos.tran.y + "," + desc_pos.tran.z + "," + desc_pos.rpy.rx + "," + desc_pos.rpy.ry + "," + desc_pos.rpy.rz + ",) : " + errcode);
        }
        return errcode;
    }

    public int GetInverseKin(int type, DescPose desc_pos, int config, JointPos joint_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] descPos = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] params = new Object[]{type, descPos, config};
            Object[] result = (Object[])this.client.execute("GetInverseKin", params);
            if ((Integer)result[0] == 0) {
                joint_pos.J1 = (Double)result[1];
                joint_pos.J2 = (Double)result[2];
                joint_pos.J3 = (Double)result[3];
                joint_pos.J4 = (Double)result[4];
                joint_pos.J5 = (Double)result[5];
                joint_pos.J6 = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("GetInverseKin(" + type + "," + descPos[0] + "," + descPos[1] + "," + descPos[2] + "," + descPos[3] + "," + descPos[4] + "," + descPos[5] + "," + config + "," + joint_pos.J1 + "," + joint_pos.J2 + ",  " + joint_pos.J3 + ",  " + joint_pos.J4 + ",  " + joint_pos.J5 + ",  " + joint_pos.J6 + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetInverseKinRef(int posMode, DescPose desc_pos, JointPos joint_pos_ref, JointPos joint_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] descPos = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] jointPos = new Object[]{joint_pos_ref.J1, joint_pos_ref.J2, joint_pos_ref.J3, joint_pos_ref.J4, joint_pos_ref.J5, joint_pos_ref.J6};
            Object[] params = new Object[]{posMode, descPos, jointPos};
            Object[] result = (Object[])this.client.execute("GetInverseKinRef", params);
            if ((Integer)result[0] == 0) {
                joint_pos.J1 = (Double)result[1];
                joint_pos.J2 = (Double)result[2];
                joint_pos.J3 = (Double)result[3];
                joint_pos.J4 = (Double)result[4];
                joint_pos.J5 = (Double)result[5];
                joint_pos.J6 = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("GetInverseKinRef(" + posMode + "," + descPos[0] + "," + descPos[1] + "," + descPos[2] + "," + descPos[3] + "," + descPos[4] + "," + descPos[5] + "," + jointPos[0] + "," + jointPos[1] + "," + jointPos[2] + "," + jointPos[3] + "," + jointPos[4] + "," + jointPos[5] + "," + joint_pos.J1 + "," + joint_pos.J2 + ", " + joint_pos.J3 + ", " + joint_pos.J4 + ", " + joint_pos.J5 + ", " + joint_pos.J6 + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Integer> GetInverseKinHasSolution(int posMode, DescPose desc_pos, JointPos joint_pos_ref) {
        ArrayList<Integer> rtnArray = new ArrayList<Integer>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] descPos = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] jointPos = new Object[]{joint_pos_ref.J1, joint_pos_ref.J2, joint_pos_ref.J3, joint_pos_ref.J4, joint_pos_ref.J5, joint_pos_ref.J6};
            Object[] params = new Object[]{posMode, descPos, jointPos};
            Object[] result = (Object[])this.client.execute("GetInverseKinHasSolution", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Boolean)result[1] != false ? 1 : 0);
            }
            if (this.log != null) {
                this.log.LogInfo("GetInverseKinHasSolution(" + posMode + ", " + desc_pos.tran.x + "," + desc_pos.tran.y + "," + desc_pos.tran.z + "," + desc_pos.rpy.rx + "," + desc_pos.rpy.ry + "," + desc_pos.rpy.rz + "," + jointPos[0] + "," + jointPos[1] + "," + jointPos[2] + "," + jointPos[3] + "," + jointPos[4] + "," + jointPos[5] + "," + (Boolean)result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int GetForwardKin(JointPos joint_pos, DescPose desc_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] jointPos = new Object[]{joint_pos.J1, joint_pos.J2, joint_pos.J3, joint_pos.J4, joint_pos.J5, joint_pos.J6};
            Object[] params = new Object[]{jointPos};
            Object[] result = (Object[])this.client.execute("GetForwardKin", params);
            if ((Integer)result[0] == 0) {
                desc_pos.tran.x = (Double)result[1];
                desc_pos.tran.y = (Double)result[2];
                desc_pos.tran.z = (Double)result[3];
                desc_pos.rpy.rx = (Double)result[4];
                desc_pos.rpy.ry = (Double)result[5];
                desc_pos.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("GetForwardKin(" + jointPos[0] + "," + jointPos[1] + "," + jointPos[2] + "," + jointPos[3] + "," + jointPos[4] + "," + jointPos[5] + ",  " + desc_pos.tran.x + "," + desc_pos.tran.y + "," + desc_pos.tran.z + "," + desc_pos.rpy.rx + "," + desc_pos.rpy.ry + "," + desc_pos.rpy.rz + ",) : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetJointTorques(int flag, Object[] torques) {
        int errcode = 0;
        if (this.sockErr == 0) {
            for (int i = 0; i < 6; ++i) {
                torques[i] = this.robotStateRoutineThread.pkg.jt_cur_tor[i];
            }
        } else {
            errcode = this.sockErr;
        }
        if (this.log != null) {
            this.log.LogInfo("GetJointTorques(" + flag + "," + Arrays.toString(torques) + ") : " + errcode);
        }
        return errcode;
    }

    public List<Number> GetTargetPayload(int flag) {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{flag};
            Object[] result = (Object[])this.client.execute("GetTargetPayload", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Double)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetTargetPayload(" + flag + ", " + (Double)result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int GetTargetPayloadCog(int flag, DescTran cog) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{flag};
            Object[] result = (Object[])this.client.execute("GetTargetPayloadCog", params);
            if ((Integer)result[0] == 0) {
                cog.x = (Double)result[1];
                cog.y = (Double)result[2];
                cog.z = (Double)result[3];
            }
            if (this.log != null) {
                this.log.LogInfo("GetTargetPayloadCog(" + flag + "," + cog.x + "," + cog.y + "," + cog.z + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetTCPOffset(int flag, DescPose desc_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{flag};
            Object[] result = (Object[])this.client.execute("GetTCPOffset", params);
            if ((Integer)result[0] == 0) {
                desc_pos.tran.x = (Double)result[1];
                desc_pos.tran.y = (Double)result[2];
                desc_pos.tran.z = (Double)result[3];
                desc_pos.rpy.rx = (Double)result[4];
                desc_pos.rpy.ry = (Double)result[5];
                desc_pos.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("GetTCPOffset(" + flag + "," + desc_pos.tran.x + "," + desc_pos.tran.y + "," + desc_pos.tran.z + "," + desc_pos.rpy.rx + "," + desc_pos.rpy.ry + "," + desc_pos.rpy.rz + ",) : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetWObjOffset(int flag, DescPose desc_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{flag};
            Object[] result = (Object[])this.client.execute("GetWObjOffset", params);
            if ((Integer)result[0] == 0) {
                desc_pos.tran.x = (Double)result[1];
                desc_pos.tran.y = (Double)result[2];
                desc_pos.tran.z = (Double)result[3];
                desc_pos.rpy.rx = (Double)result[4];
                desc_pos.rpy.ry = (Double)result[5];
                desc_pos.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("GetWObjOffset(" + flag + "," + desc_pos.tran.x + "," + desc_pos.tran.y + "," + desc_pos.tran.z + "," + desc_pos.rpy.rx + "," + desc_pos.rpy.ry + "," + desc_pos.rpy.rz + ",) : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetJointSoftLimitDeg(int flag, Object[] negative, Object[] positive) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{flag};
            Object[] result = (Object[])this.client.execute("GetJointSoftLimitDeg", params);
            if ((Integer)result[0] == 0) {
                negative[0] = (double)((Double)result[1]);
                positive[0] = (double)((Double)result[2]);
                negative[1] = (double)((Double)result[3]);
                positive[1] = (double)((Double)result[4]);
                negative[2] = (double)((Double)result[5]);
                positive[2] = (double)((Double)result[6]);
                negative[3] = (double)((Double)result[7]);
                positive[3] = (double)((Double)result[8]);
                negative[4] = (double)((Double)result[9]);
                positive[4] = (double)((Double)result[10]);
                negative[5] = (double)((Double)result[11]);
                positive[5] = (double)((Double)result[12]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetJointSoftLimitDeg(" + flag + "," + negative[0] + "," + negative[1] + "," + negative[2] + "," + negative[3] + "," + negative[4] + "," + negative[5] + "," + positive[0] + "," + positive[1] + "," + positive[2] + "," + positive[3] + "," + positive[4] + "," + positive[5] + ")");
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Number> GetSystemClock() {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetSystemClock", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Double)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetSystemClock( " + result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public List<Integer> GetRobotCurJointsConfig() {
        ArrayList<Integer> rtnArray = new ArrayList<Integer>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetRobotCurJointsConfig", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Integer)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetRobotCurJointsConfig(" + (Integer)result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public List<Number> GetDefaultTransVel() {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetDefaultTransVel", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Double)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetDefaultTransVel(" + (Double)result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public List<Number> GetRobotTeachingPoint(String name) {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        for (int i = 0; i < 21; ++i) {
            rtnArray.add(-1);
        }
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{name};
            Object[] result = (Object[])this.client.execute("GetRobotTeachingPoint", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                String paramStr = (String)result[1];
                String[] parS = paramStr.split(",");
                if (parS.length != 20) {
                    this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "get Teaching Point size fail");
                    rtnArray.set(0, -1);
                    return rtnArray;
                }
                for (int i = 0; i < 20; ++i) {
                    rtnArray.set(i + 1, Double.parseDouble(parS[i]));
                }
            }
            if (this.log != null) {
                this.log.LogInfo("GetRobotTeachingPoint(" + name + "," + rtnArray.get(0) + "," + rtnArray.get(1) + "," + rtnArray.get(2) + "," + rtnArray.get(3) + "," + rtnArray.get(4) + "," + rtnArray.get(5) + "," + rtnArray.get(6) + "," + rtnArray.get(7) + "," + rtnArray.get(8) + "," + rtnArray.get(9) + "," + rtnArray.get(10) + "," + rtnArray.get(11) + "," + rtnArray.get(12) + "," + rtnArray.get(13) + "," + rtnArray.get(14) + "," + rtnArray.get(15) + "," + rtnArray.get(16) + "," + rtnArray.get(17) + "," + rtnArray.get(18) + "," + rtnArray.get(19) + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int SetTPDParam(int type, String name, int period_ms, int di_choose, int do_choose) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{type, name, period_ms, di_choose, do_choose};
            int rtn = (Integer)this.client.execute("SetTPDParam", params);
            if (this.log != null) {
                this.log.LogInfo("SetTPDParam(" + type + "," + name + "," + period_ms + "," + di_choose + "," + do_choose + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTPDStart(int type, String name, int period_ms, int di_choose, int do_choose) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{type, name, period_ms, di_choose, do_choose};
            int rtn = (Integer)this.client.execute("SetTPDStart", params);
            if (this.log != null) {
                this.log.LogInfo("SetTPDStart(" + type + "," + name + "," + period_ms + "," + di_choose + "," + do_choose + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetWebTPDStop() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("SetWebTPDStop", params);
            if (this.log != null) {
                this.log.LogInfo("SetWebTPDStop() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTPDDelete(String name) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{name};
            int rtn = (Integer)this.client.execute("SetTPDDelete", params);
            if (this.log != null) {
                this.log.LogInfo("SetTPDDelete(" + name + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LoadTPD(String name) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{name};
            int rtn = (Integer)this.client.execute("LoadTPD", params);
            if (this.log != null) {
                this.log.LogInfo("LoadTPD(" + name + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetTPDStartPose(String name, DescPose desc_pose) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{name};
            Object[] result = (Object[])this.client.execute("GetTPDStartPose", params);
            if ((Integer)result[0] == 0) {
                desc_pose.tran.x = (Double)result[1];
                desc_pose.tran.y = (Double)result[2];
                desc_pose.tran.z = (Double)result[3];
                desc_pose.rpy.rx = (Double)result[4];
                desc_pose.rpy.ry = (Double)result[5];
                desc_pose.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("GetTrajectoryStartPose(" + desc_pose.tran.x + "," + desc_pose.tran.y + "," + desc_pose.tran.z + "," + desc_pose.rpy.rx + "," + desc_pose.rpy.ry + "," + desc_pose.rpy.rz + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveTPD(String name, int blend, double ovl) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{name, blend, ovl};
            int rtn = (Integer)this.client.execute("MoveTPD", params);
            if (this.log != null) {
                this.log.LogInfo("MoveTPD(" + name + ", " + blend + "," + ovl + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LoadTrajectoryJ(String name, double ovl, int opt) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{name, ovl, opt};
            int rtn = (Integer)this.client.execute("LoadTrajectoryJ", params);
            if (this.log != null) {
                this.log.LogInfo("LoadTrajectoryJ(" + name + ", " + ovl + "," + opt + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveTrajectoryJ() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("MoveTrajectoryJ", params);
            if (this.log != null) {
                this.log.LogInfo("MoveTrajectoryJ() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LoadTrajectoryLA(String name, int mode, double errorLim, int type, double precision, double vamx, double amax, double jmax) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{name, mode, errorLim, type, precision, vamx, amax, jmax};
            int rtn = (Integer)this.client.execute("LoadTrajectoryLA", params);
            if (this.log != null) {
                this.log.LogInfo("LoadTrajectoryLA(" + name + ", " + mode + "," + errorLim + "," + type + "," + precision + "," + vamx + amax + "," + jmax + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveTrajectoryLA() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("MoveTrajectoryLA", params);
            if (this.log != null) {
                this.log.LogInfo("MoveTrajectoryLA() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetTrajectoryStartPose(String name, DescPose desc_pose) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{name};
            Object[] result = (Object[])this.client.execute("GetTrajectoryStartPose", params);
            if ((Integer)result[0] == 0) {
                desc_pose.tran.x = (Double)result[1];
                desc_pose.tran.y = (Double)result[2];
                desc_pose.tran.z = (Double)result[3];
                desc_pose.rpy.rx = (Double)result[4];
                desc_pose.rpy.ry = (Double)result[5];
                desc_pose.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("GetTrajectoryStartPose(" + desc_pose.tran.x + "," + desc_pose.tran.y + "," + desc_pose.tran.z + "," + desc_pose.rpy.rx + "," + desc_pose.rpy.ry + "," + desc_pose.rpy.rz + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTrajectoryJSpeed(double ovl) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{ovl};
            int rtn = (Integer)this.client.execute("SetTrajectoryJSpeed", params);
            if (this.log != null) {
                this.log.LogInfo("SetTrajectoryJSpeed(" + ovl + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTrajectoryJForceTorque(ForceTorque ft) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] ftData = new Object[]{ft.fx, ft.fy, ft.fz, ft.tx, ft.ty, ft.tz};
            Object[] params = new Object[]{ftData};
            int rtn = (Integer)this.client.execute("SetTrajectoryJForceTorque", params);
            if (this.log != null) {
                this.log.LogInfo("SetTrajectoryJForceTorque(" + ftData[0] + "," + ftData[1] + "," + ftData[2] + "," + ftData[3] + "," + ftData[4] + "," + ftData[5] + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTrajectoryJForceFx(double fx) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{fx};
            int rtn = (Integer)this.client.execute("SetTrajectoryJForceFx", params);
            if (this.log != null) {
                this.log.LogInfo("SetTrajectoryJForceFx(" + fx + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTrajectoryJForceFy(double fy) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{fy};
            int rtn = (Integer)this.client.execute("SetTrajectoryJForceFy", params);
            if (this.log != null) {
                this.log.LogInfo("SetTrajectoryJForceFy(" + fy + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTrajectoryJForceFz(double fz) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{fz};
            int rtn = (Integer)this.client.execute("SetTrajectoryJForceFz", params);
            if (this.log != null) {
                this.log.LogInfo("SetTrajectoryJForceFz(" + fz + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTrajectoryJTorqueTx(double tx) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{tx};
            int rtn = (Integer)this.client.execute("SetTrajectoryJTorqueTx", params);
            if (this.log != null) {
                this.log.LogInfo("SetTrajectoryJTorqueTx(" + tx + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTrajectoryJTorqueTy(double ty) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{ty};
            int rtn = (Integer)this.client.execute("SetTrajectoryJTorqueTy", params);
            if (this.log != null) {
                this.log.LogInfo("SetTrajectoryJTorqueTy(" + ty + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetTrajectoryJTorqueTz(double tz) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{tz};
            int rtn = (Integer)this.client.execute("SetTrajectoryJTorqueTz", params);
            if (this.log != null) {
                this.log.LogInfo("SetTrajectoryJTorqueTz(" + tz + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LoadDefaultProgConfig(int flag, String program_name) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{flag, program_name};
            int rtn = (Integer)this.client.execute("LoadDefaultProgConfig", params);
            if (this.log != null) {
                this.log.LogInfo("LoadDefaultProgConfig(" + flag + "," + program_name + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ProgramLoad(String program_name) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{program_name};
            int rtn = (Integer)this.client.execute("ProgramLoad", params);
            if (this.log != null) {
                this.log.LogInfo("ProgramLoad(" + program_name + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetLoadedProgram(String[] program_name) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetLoadedProgram", params);
            if ((Integer)result[0] == 0) {
                program_name[0] = (String)result[1];
            }
            if (this.log != null) {
                this.log.LogInfo("GetLoadedProgram(" + program_name[0] + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Integer> GetCurrentLine() {
        ArrayList<Integer> rtnArray = new ArrayList<Integer>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetCurrentLine", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Integer)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetCurrentLine(" + (Integer)result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int ProgramRun() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ProgramRun", params);
            if (this.log != null) {
                this.log.LogInfo("ProgramRun() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ProgramPause() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ProgramPause", params);
            if (this.log != null) {
                this.log.LogInfo("ProgramPause() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ProgramResume() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ProgramResume", params);
            if (this.log != null) {
                this.log.LogInfo("ProgramResume() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ProgramStop() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ProgramStop", params);
            if (this.log != null) {
                this.log.LogInfo("ProgramStop() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetGripperConfig(DeviceConfig config) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{config.company, config.device, config.softwareVersion, config.bus};
            int rtn = (Integer)this.client.execute("SetGripperConfig", params);
            if (this.log != null) {
                this.log.LogInfo("SetGripperConfig(" + config.company + "," + config.device + "," + config.softwareVersion + "," + config.bus + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetGripperConfig(DeviceConfig config) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetGripperConfig", params);
            if ((Integer)result[0] == 0) {
                config.company = (Integer)result[2] + 1;
                config.device = (Integer)result[1];
                config.softwareVersion = (Integer)result[3];
                config.bus = (Integer)result[4];
            }
            if (this.log != null) {
                this.log.LogInfo("GetGripperConfig(" + config.company + "," + config.device + "," + config.softwareVersion + "," + config.bus + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ActGripper(int index, int act) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{index, act};
            int rtn = (Integer)this.client.execute("ActGripper", params);
            if (this.log != null) {
                this.log.LogInfo("ActGripper(" + index + "," + act + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveGripper(int index, int pos, int vel, int force, int max_time, int block, int type, double rotNum, int rotVel, int rotTorque) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{index, pos, vel, force, max_time, block, type, rotNum, rotVel, rotTorque};
            int rtn = (Integer)this.client.execute("MoveGripper", params);
            if (this.log != null) {
                this.log.LogInfo("MoveGripper(" + index + "," + pos + "," + vel + "," + force + "," + max_time + "," + block + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Integer> GetGripperMotionDone() {
        ArrayList<Integer> rtnArray = new ArrayList<Integer>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetGripperMotionDone", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Integer)result[1]);
                rtnArray.set(2, (Integer)result[2]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetGripperMotionDone( " + (Integer)result[1] + ", " + (Integer)result[2] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int ComputePrePick(DescPose desc_pos, double zlength, double zangle, DescPose pre_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] descPos = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] params = new Object[]{descPos, zlength, zangle};
            Object[] result = (Object[])this.client.execute("ComputePrePick", params);
            if ((Integer)result[0] == 0) {
                pre_pos.tran.x = (Double)result[1];
                pre_pos.tran.y = (Double)result[2];
                pre_pos.tran.z = (Double)result[3];
                pre_pos.rpy.rx = (Double)result[4];
                pre_pos.rpy.ry = (Double)result[5];
                pre_pos.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("ComputePrePick(" + descPos[0] + "," + descPos[1] + "," + descPos[2] + "," + descPos[3] + "," + descPos[4] + "," + descPos[5] + "," + zlength + "," + zangle + ",  " + pre_pos.tran.x + "," + pre_pos.tran.y + "," + pre_pos.tran.z + "," + pre_pos.rpy.rx + "," + pre_pos.rpy.ry + "," + pre_pos.rpy.rz + ",) : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ComputePostPick(DescPose desc_pos, double zlength, double zangle, DescPose post_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] descPos = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] params = new Object[]{descPos, zlength, zangle};
            Object[] result = (Object[])this.client.execute("ComputePostPick", params);
            if ((Integer)result[0] == 0) {
                post_pos.tran.x = (Double)result[1];
                post_pos.tran.y = (Double)result[2];
                post_pos.tran.z = (Double)result[3];
                post_pos.rpy.rx = (Double)result[4];
                post_pos.rpy.ry = (Double)result[5];
                post_pos.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("ComputePostPick(" + descPos[0] + "," + descPos[1] + "," + descPos[2] + "," + descPos[3] + "," + descPos[4] + "," + descPos[5] + "," + zlength + "," + zangle + ",  " + post_pos.tran.x + "," + post_pos.tran.y + "," + post_pos.tran.z + "," + post_pos.rpy.rx + "," + post_pos.rpy.ry + "," + post_pos.rpy.rz + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_SetConfig(DeviceConfig config) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{config.company, config.device, config.softwareVersion, config.bus};
            int rtn = (Integer)this.client.execute("FT_SetConfig", params);
            if (this.log != null) {
                this.log.LogInfo("FT_SetConfig(" + config.company + "," + config.device + "," + config.softwareVersion + "," + config.bus + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_GetConfig(DeviceConfig config) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("FT_GetConfig", params);
            if ((Integer)result[0] == 0) {
                config.device = (Integer)result[1];
                config.company = (Integer)result[2];
                config.softwareVersion = (Integer)result[3];
                config.bus = (Integer)result[4];
            }
            if (this.log != null) {
                this.log.LogInfo("FT_GetConfig(" + config.company + "," + config.device + "," + config.softwareVersion + "," + config.bus + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_Activate(int act) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{act};
            int rtn = (Integer)this.client.execute("FT_Activate", params);
            if (this.log != null) {
                this.log.LogInfo("FT_Activate(" + act + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_SetZero(int act) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{act};
            int rtn = (Integer)this.client.execute("FT_SetZero", params);
            if (this.log != null) {
                this.log.LogInfo("FT_SetZero(" + act + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_SetRCS(int type, DescPose coord) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] coords = new Object[]{coord.tran.x, coord.tran.y, coord.tran.z, coord.rpy.rx, coord.rpy.ry, coord.rpy.rz};
            Object[] params = new Object[]{type, coords};
            int rtn = (Integer)this.client.execute("FT_SetRCS", params);
            if (this.log != null) {
                this.log.LogInfo("FT_SetRCS(" + type + "," + coord.tran.x + "," + coord.tran.y + "," + coord.tran.z + "," + coord.rpy.rx + "," + coord.rpy.ry + "," + coord.rpy.rz + ",) : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_PdIdenRecord(int id) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id};
            int rtn = (Integer)this.client.execute("FT_PdIdenRecord", params);
            if (this.log != null) {
                this.log.LogInfo("FT_PdIdenRecord(" + id + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Number> FT_PdIdenCompute() {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("FT_PdIdenCompute", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Double)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("FT_PdIdenCompute(" + (Double)result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int FT_PdCogIdenRecord(int id, int index) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, index};
            int rtn = (Integer)this.client.execute("FT_PdCogIdenRecord", params);
            if (this.log != null) {
                this.log.LogInfo("FT_PdCogIdenRecord(" + id + "," + index + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_PdCogIdenCompute(DescTran cog) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("FT_PdCogIdenCompute", params);
            if ((Integer)result[0] == 0) {
                cog.x = (Double)result[1];
                cog.y = (Double)result[2];
                cog.z = (Double)result[3];
            }
            if (this.log != null) {
                this.log.LogInfo("FT_PdCogIdenCompute(" + cog.x + "," + cog.y + "," + cog.z + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_GetForceTorqueRCS(int flag, ForceTorque ft) {
        int errcode = 0;
        if (this.sockErr == 0) {
            ft.fx = this.robotStateRoutineThread.pkg.ft_sensor_data[0];
            ft.fy = this.robotStateRoutineThread.pkg.ft_sensor_data[1];
            ft.fz = this.robotStateRoutineThread.pkg.ft_sensor_data[2];
            ft.tx = this.robotStateRoutineThread.pkg.ft_sensor_data[3];
            ft.ty = this.robotStateRoutineThread.pkg.ft_sensor_data[4];
            ft.tz = this.robotStateRoutineThread.pkg.ft_sensor_data[5];
        } else {
            errcode = this.sockErr;
        }
        if (this.log != null) {
            this.log.LogInfo("FT_GetForceTorqueRCS(" + flag + "," + ft.fx + "," + ft.fy + "," + ft.fz + "," + ft.tx + "," + ft.ty + "," + ft.tz + ") : " + errcode);
        }
        return errcode;
    }

    public int FT_GetForceTorqueOrigin(int flag, ForceTorque ft) {
        int errcode = 0;
        if (this.sockErr == 0) {
            ft.fx = this.robotStateRoutineThread.pkg.ft_sensor_raw_data[0];
            ft.fy = this.robotStateRoutineThread.pkg.ft_sensor_raw_data[1];
            ft.fz = this.robotStateRoutineThread.pkg.ft_sensor_raw_data[2];
            ft.tx = this.robotStateRoutineThread.pkg.ft_sensor_raw_data[3];
            ft.ty = this.robotStateRoutineThread.pkg.ft_sensor_raw_data[4];
            ft.tz = this.robotStateRoutineThread.pkg.ft_sensor_raw_data[5];
        } else {
            errcode = this.sockErr;
        }
        if (this.log != null) {
            this.log.LogInfo("FT_GetForceTorqueOrigin(" + flag + "," + ft.fx + "," + ft.fy + "," + ft.fz + "," + ft.tx + "," + ft.ty + "," + ft.tz + ") : " + errcode);
        }
        return errcode;
    }

    public int FT_Guard(int flag, int sensor_id, Object[] select, ForceTorque ft, Object[] max_threshold, Object[] min_threshold) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] ftData = new Object[]{ft.fx, ft.fy, ft.fz, ft.tx, ft.ty, ft.tz};
            Object[] params = new Object[]{flag, sensor_id, select, ftData, max_threshold, min_threshold};
            int rtn = (Integer)this.client.execute("FT_Guard", params);
            if (this.log != null) {
                this.log.LogInfo("FT_Guard(" + flag + "," + sensor_id + "," + flag + "," + select[0] + "," + select[1] + "," + select[2] + "," + select[3] + "," + select[4] + "," + select[5] + "," + ft.fx + "," + ft.fy + "," + ft.fz + "," + ft.tx + "," + ft.ty + "," + ft.tz + "," + max_threshold[0] + "," + max_threshold[1] + "," + max_threshold[2] + "," + max_threshold[3] + "," + max_threshold[4] + "," + max_threshold[5] + "," + min_threshold[0] + "," + min_threshold[1] + "," + min_threshold[2] + "," + min_threshold[3] + "," + min_threshold[4] + "," + min_threshold[5] + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_Control(int flag, int sensor_id, Object[] select, ForceTorque ft, Object[] ft_pid, int adj_sign, int ILC_sign, double max_dis, double max_ang, int filter_Sign, int posAdapt_sign, int isNoBlock) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] ftData = new Object[]{ft.fx, ft.fy, ft.fz, ft.tx, ft.ty, ft.tz};
            Object[] params = new Object[]{flag, sensor_id, select, ftData, ft_pid, adj_sign, ILC_sign, max_dis, max_ang, filter_Sign, posAdapt_sign, isNoBlock};
            int rtn = (Integer)this.client.execute("FT_Control", params);
            if (this.log != null) {
                this.log.LogInfo("FT_Control(" + flag + "," + sensor_id + "," + flag + "," + select[0] + "," + select[1] + "," + select[2] + "," + select[3] + "," + select[4] + "," + select[5] + "," + ft.fx + "," + ft.fy + "," + ft.fz + "," + ft.tx + "," + ft.ty + "," + ft.tz + "," + ft_pid[0] + "," + ft_pid[1] + "," + ft_pid[2] + "," + ft_pid[3] + "," + ft_pid[4] + "," + ft_pid[5] + "," + adj_sign + "," + ILC_sign + "," + max_dis + "," + max_ang + "," + filter_Sign + "," + posAdapt_sign + "," + isNoBlock + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_ComplianceStart(double p, double force) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{p, force};
            int rtn = (Integer)this.client.execute("FT_ComplianceStart", params);
            if (this.log != null) {
                this.log.LogInfo("FT_ComplianceStart(" + p + "," + force + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int FT_ComplianceStop() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("FT_ComplianceStop", params);
            if (this.log != null) {
                this.log.LogInfo("FT_ComplianceStop() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LoadIdentifyDynFilterInit() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("LoadIdentifyDynFilterInit", params);
            if (this.log != null) {
                this.log.LogInfo("LoadIdentifyDynFilterInit() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LoadIdentifyDynVarInit() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("LoadIdentifyDynVarInit", params);
            if (this.log != null) {
                this.log.LogInfo("LoadIdentifyDynVarInit() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LoadIdentifyMain(Object[] joint_torque, Object[] joint_pos, double t) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{joint_torque, joint_pos, t};
            int rtn = (Integer)this.client.execute("LoadIdentifyMain", params);
            if (this.log != null) {
                this.log.LogInfo("LoadIdentifyMain(" + joint_torque[0] + "," + joint_torque[1] + "," + joint_torque[2] + "," + joint_torque[3] + "," + joint_torque[4] + "," + joint_torque[5] + "," + joint_pos[0] + "," + joint_pos[1] + "," + joint_pos[2] + "," + joint_pos[3] + "," + joint_pos[4] + "," + joint_pos[5] + "," + t + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Number> LoadIdentifyGetResult(Object[] gain) {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{gain};
            Object[] result = (Object[])this.client.execute("LoadIdentifyGetResult", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Double)result[1]);
                rtnArray.set(2, (Double)result[2]);
                rtnArray.set(3, (Double)result[3]);
                rtnArray.set(4, (Double)result[4]);
            }
            if (this.log != null) {
                this.log.LogInfo("LoadIdentifyGetResult(" + (Double)result[1] + "," + (Double)result[2] + "," + (Double)result[3] + "," + (Double)result[4] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int ConveyorStartEnd(int status) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{status};
            int rtn = (Integer)this.client.execute("ConveyorStartEnd", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorStartEnd(" + status + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorPointIORecord() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ConveyorPointIORecord", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorPointIORecord() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorPointARecord() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ConveyorPointARecord", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorPointARecord() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorRefPointRecord() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ConveyorRefPointRecord", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorRefPointRecord() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorPointBRecord() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ConveyorPointBRecord", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorPointBRecord() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorIODetect(int max_t) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{max_t};
            int rtn = (Integer)this.client.execute("ConveyorIODetect", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorIODetect(" + max_t + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorGetTrackData(int mode) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{mode};
            int rtn = (Integer)this.client.execute("ConveyorGetTrackData", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorGetTrackData(" + mode + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorTrackStart(int status) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{status};
            int rtn = (Integer)this.client.execute("ConveyorTrackStart", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorTrackStart(" + status + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorTrackEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ConveyorTrackEnd", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorTrackEnd() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorSetParam(int encChannel, int resolution, double lead, int wpAxis, int vision, double speedRadio, int followType, int startDis, int endDis) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] param = new Object[]{encChannel, resolution, lead, wpAxis, vision, speedRadio, followType, startDis, endDis};
            Object[] params = new Object[]{param};
            int rtn = (Integer)this.client.execute("ConveyorSetParam", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorSetParam(" + encChannel + "," + resolution + ")," + lead + "," + wpAxis + "," + vision + "," + speedRadio + " : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorPointComp(Object[] cmp) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{cmp};
            int rtn = (Integer)this.client.execute("ConveyorPointComp", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorPointComp(" + cmp + " : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorCatchPointComp(Object[] cmp) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{cmp};
            int rtn = (Integer)this.client.execute("ConveyorCatchPointComp", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorCatchPointComp(" + Arrays.toString(cmp) + " ): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorTrackMoveL(String name, int tool, int wobj, double vel, double acc, double ovl, double blendR) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{name, tool, wobj, vel, acc, ovl, blendR, 0, 0};
            int rtn = (Integer)this.client.execute("ConveyorTrackMoveL", params);
            if (this.log != null) {
                this.log.LogInfo("ConveyorTrackMoveL(" + name + "," + tool + "," + wobj + "," + vel + "," + acc + "," + ovl + "," + blendR + " : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetSSHKeygen(String[] keygen) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetSSHKeygen", params);
            if ((Integer)result[0] == 0) {
                keygen[0] = (String)result[1];
            }
            if (this.log != null) {
                this.log.LogInfo("GetSSHKeygen(" + Arrays.toString(keygen) + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ComputeFileMD5(String file_path, String md5) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{file_path};
            Object[] result = (Object[])this.client.execute("ComputeFileMD5", params);
            if ((Integer)result[0] == 0) {
                md5 = (String)result[1];
            }
            if (this.log != null) {
                this.log.LogInfo("ComputeFileMD5(" + file_path + ",  " + md5 + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetSDKComState() {
        int state = -1;
        if (this.sockErr == 0) {
            state = 0;
        } else if (this.sockErr == -2) {
            state = 1;
        }
        if (this.log != null) {
            this.log.LogInfo("GetSDKComState(" + state + ") : " + state);
        }
        return state;
    }

    public int GetDHCompensation(Object[] dhCompensation) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetDHCompensation", params);
            if ((Integer)result[0] == 0) {
                dhCompensation[0] = (double)((Double)result[1]);
                dhCompensation[1] = (double)((Double)result[2]);
                dhCompensation[2] = (double)((Double)result[3]);
                dhCompensation[3] = (double)((Double)result[4]);
                dhCompensation[4] = (double)((Double)result[5]);
                dhCompensation[5] = (double)((Double)result[6]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetDHCompensation(" + dhCompensation[0] + "," + dhCompensation[1] + "," + dhCompensation[2] + "," + dhCompensation[3] + "," + dhCompensation[4] + "," + dhCompensation[5] + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int PointTableDownLoad(String pointTableName, String saveFilePath) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            File savePathF = new File(saveFilePath);
            if (!savePathF.exists()) {
                if (this.log != null) {
                    this.log.LogInfo("point table down load save path not found");
                }
                return -6;
            }
            Object[] params = new Object[]{pointTableName};
            int rtn = (Integer)this.client.execute("PointTableDownload", params);
            if (rtn == -1) {
                return 130;
            }
            if (rtn != 0) {
                return rtn;
            }
            TCPClient clientPointTable = new TCPClient(this.robotIp, 20011);
            boolean connRtn = clientPointTable.Connect();
            if (!connRtn) {
                if (this.log != null) {
                    this.log.LogInfo("point table dowmload connect failed");
                }
                clientPointTable.Close();
                return -1;
            }
            byte[] totalbuffer = new byte[0x3200000];
            int totalSize = 0;
            String recvMd5 = "";
            int recvSize = 0;
            boolean findHeadFlag = false;
            do {
                byte[] buffer;
                int num;
                if ((num = clientPointTable.Recv(buffer = new byte[0x3200000])) < 1) {
                    if (this.log != null) {
                        this.log.LogInfo("point table dowmload recv failed");
                    }
                    return -1;
                }
                System.arraycopy(buffer, 0, totalbuffer, totalSize, num);
                String head = new String(this.subByte(totalbuffer, 0, 4));
                if (!findHeadFlag && (totalSize += num) > 4 && head.equals("/f/b")) {
                    findHeadFlag = true;
                }
                if (!findHeadFlag || totalSize <= 44) continue;
                String sizeString = new String(this.subByte(totalbuffer, 4, 8));
                recvSize = Integer.parseInt(sizeString);
                recvMd5 = new String(this.subByte(totalbuffer, 12, 32));
            } while (!findHeadFlag || totalSize != recvSize);
            byte[] fileBuffer = this.subByte(totalbuffer, 44, totalSize - 16 - 32);
            File file = new File(saveFilePath + pointTableName);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(saveFilePath + pointTableName);
            for (Object b : (String)fileBuffer) {
                out.write((int)b);
            }
            out.close();
            String checkMd5 = this.computeMD5(saveFilePath + pointTableName).toLowerCase();
            if (checkMd5.equals(recvMd5)) {
                clientPointTable.Send("SUCCESS");
                if (this.log != null) {
                    this.log.LogInfo("PointTableDownLoad(" + pointTableName + ", " + saveFilePath + " ) : Success");
                }
                return 0;
            }
            clientPointTable.Send("FAIL");
            file.delete();
            if (this.log != null) {
                this.log.LogInfo("PointTableDownLoad(" + pointTableName + ", " + saveFilePath + " + ) : Fail");
            }
            return -1;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int PointTableUpLoad(String pointTableFilePath) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            String resultStr;
            File fileInfo = new File(pointTableFilePath);
            if (!fileInfo.exists()) {
                return -7;
            }
            int tmpsize = this.GetFileSize(pointTableFilePath);
            int totalSize = this.GetFileSize(pointTableFilePath) + 16 + 32;
            if (totalSize > this.MAX_UPLOAD_FILE_SIZE) {
                System.out.println("Files larger than 2 MB are not supported!");
                return -1;
            }
            String pointTableName = fileInfo.getName();
            Object[] nameParams = new Object[]{pointTableName};
            int rtn = (Integer)this.client.execute("PointTableUpload", nameParams);
            if (rtn != 0) {
                return rtn;
            }
            TCPClient clientUpload = new TCPClient(this.robotIp, 20010);
            boolean bRtn = clientUpload.Connect();
            if (!bRtn) {
                this.log.LogError("PointTable Upload Connect fail");
                clientUpload.Close();
                return -1;
            }
            String sendMd5 = this.computeMD5(pointTableFilePath).toLowerCase();
            int num = clientUpload.Send("/f/b" + String.format("%8d", totalSize) + sendMd5);
            if (num < 1) {
                return -1;
            }
            byte[] bytes = Files.readAllBytes(Paths.get(pointTableFilePath, new String[0]));
            clientUpload.Send(bytes);
            num = clientUpload.Send("/b/f");
            if (num < 1) {
                return -1;
            }
            byte[] resultBuf = new byte[1024];
            this.Sleep(300);
            num = clientUpload.Recv(resultBuf);
            if (num < 1) {
                if (this.log != null) {
                    this.log.LogDebug("get result failed!");
                }
                return -1;
            }
            if (this.log != null) {
                this.log.LogDebug("recv success!");
            }
            if ((resultStr = new String(resultBuf, StandardCharsets.UTF_8).substring(0, 7)).equals("SUCCESS")) {
                if (this.log != null) {
                    this.log.LogInfo("point table upLoad(" + pointTableFilePath + ") : success");
                }
                return 0;
            }
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "upload get result fail!  :  " + resultStr);
            }
            if (this.log != null) {
                this.log.LogInfo("point table UpLoad(" + pointTableFilePath + ") : fail");
            }
            return -1;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int PointTableSwitch(String pointTableName, String errorStr) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{pointTableName};
            int rtn = (Integer)this.client.execute("PointTableSwitch", params);
            if (rtn != 0) {
                errorStr = rtn == 130 ? "PointTable not Found!" : "not defined error";
            } else {
                Thread.sleep(500L);
                errorStr = "success";
            }
            if (this.log != null) {
                this.log.LogInfo("PointTableSwitch(" + pointTableName + ") : " + errorStr);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int PointTableUpdateLua(String pointTableName, String luaFileName, String errorStr) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{pointTableName};
            int rtn = (Integer)this.client.execute("PointTableSwitch", params);
            if (rtn != 0) {
                errorStr = rtn == 130 ? "PointTable not Found!" : "not defined error";
                if (this.log != null) {
                    this.log.LogInfo("PointTableSwitch(" + pointTableName + ") : " + errorStr);
                }
                return rtn;
            }
            Thread.sleep(300L);
            Object[] updateParams = new Object[]{luaFileName};
            Object[] result = (Object[])this.client.execute("PointTableUpdateLua", updateParams);
            errorStr = (String)result[1];
            if (errorStr == "") {
                errorStr = "fail to update lua,please inspect pointtable";
            }
            if (this.log != null) {
                this.log.LogInfo("PointTableUpdateLua(" + luaFileName + ") : " + errorStr);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    private int[] subints(int[] src, int begin, int count) {
        int[] bs = new int[count];
        for (int i = begin; i < begin + count; ++i) {
            bs[i - begin] = src[i];
        }
        return bs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String computeMD5(String filePath) {
        FilterInputStream din = null;
        try {
            File file = new File(filePath);
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            din = new DigestInputStream(new BufferedInputStream(new FileInputStream(file)), md5);
            byte[] b = new byte[1024];
            while (din.read(b) != -1) {
            }
            byte[] digest = md5.digest();
            StringBuilder result = new StringBuilder(DatatypeConverter.printHexBinary((byte[])digest));
            String string = result.toString();
            return string;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (din != null) {
                    din.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private int GetFileSize(String sFullName) {
        long lSize = 0L;
        File file = new File(sFullName);
        if (file.exists()) {
            lSize = file.length();
        }
        return (int)lSize;
    }

    public int GetSoftwareVersion(String robotModel, String webVersion, String controllerVersion) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetSoftwareVersion", params);
            if ((Integer)result[0] == 0) {
                robotModel = (String)result[1];
                webVersion = (String)result[2];
                controllerVersion = (String)result[3];
            }
            if (this.log != null) {
                this.log.LogInfo("GetSoftwareVersion(" + robotModel + "," + webVersion + "," + controllerVersion + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetHardwareVersion(String ctrlBoxBoardVersion, String driver1Version, String driver2Version, String driver3Version, String driver4Version, String driver5Version, String driver6Version, String endBoardVersion) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetSlaveHardVersion", params);
            if ((Integer)result[0] == 0) {
                ctrlBoxBoardVersion = (String)result[1];
                driver1Version = (String)result[2];
                driver2Version = (String)result[3];
                driver3Version = (String)result[4];
                driver4Version = (String)result[5];
                driver5Version = (String)result[6];
                driver6Version = (String)result[7];
                endBoardVersion = (String)result[8];
            }
            if (this.log != null) {
                this.log.LogInfo("GetSlaveHardVersion(" + ctrlBoxBoardVersion + "," + driver1Version + "," + driver2Version + "," + driver3Version + "," + driver4Version + "," + driver5Version + "," + driver6Version + "," + endBoardVersion + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetFirmwareVersion(String ctrlBoxBoardVersion, String driver1Version, String driver2Version, String driver3Version, String driver4Version, String driver5Version, String driver6Version, String endBoardVersion) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetSlaveFirmVersion", params);
            if ((Integer)result[0] == 0) {
                ctrlBoxBoardVersion = (String)result[1];
                driver1Version = (String)result[2];
                driver2Version = (String)result[3];
                driver3Version = (String)result[4];
                driver4Version = (String)result[5];
                driver5Version = (String)result[6];
                driver6Version = (String)result[7];
                endBoardVersion = (String)result[8];
            }
            if (this.log != null) {
                this.log.LogInfo("GetSlaveFirmVersion(" + ctrlBoxBoardVersion + "," + driver1Version + "," + driver2Version + "," + driver3Version + "," + driver4Version + "," + driver5Version + "," + driver6Version + "," + endBoardVersion + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ARCStart(int ioType, int arcNum, int timeout) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{ioType, arcNum, timeout};
            int rtn = (Integer)this.client.execute("ARCStart", params);
            if (this.log != null) {
                this.log.LogInfo("ARCStart(" + ioType + "," + arcNum + "," + timeout + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ARCEnd(int ioType, int arcNum, int timeout) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{ioType, arcNum, timeout};
            int rtn = (Integer)this.client.execute("ARCEnd", params);
            if (this.log != null) {
                this.log.LogInfo("ARCEnd(" + ioType + "," + arcNum + "," + timeout + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeldingSetCurrentRelation(WeldCurrentAORelation relation) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{relation.currentMin, relation.currentMax, relation.outputVoltageMin, relation.outputVoltageMax, relation.AOIndex};
            int rtn = (Integer)this.client.execute("WeldingSetCurrentRelation", params);
            if (this.log != null) {
                this.log.LogInfo("WeldingSetCurrentRelation(" + relation.currentMin + "," + relation.currentMax + "," + relation.outputVoltageMin + "," + relation.outputVoltageMax + "," + relation.AOIndex + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeldingSetVoltageRelation(WeldVoltageAORelation relation) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{relation.weldVoltageMin, relation.weldVoltageMax, relation.outputVoltageMin, relation.outputVoltageMax, relation.AOIndex};
            int rtn = (Integer)this.client.execute("WeldingSetVoltageRelation", params);
            if (this.log != null) {
                this.log.LogInfo("WeldingSetVoltageRelation(" + relation.weldVoltageMin + "," + relation.weldVoltageMax + "," + relation.outputVoltageMin + "," + relation.outputVoltageMax + "," + relation.AOIndex + " ): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeldingGetCurrentRelation(WeldCurrentAORelation relation) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("WeldingGetCurrentRelation", params);
            if ((Integer)result[0] == 0) {
                relation.currentMin = (Double)result[1];
                relation.currentMax = (Double)result[2];
                relation.outputVoltageMin = (Double)result[3];
                relation.outputVoltageMax = (Double)result[4];
                relation.AOIndex = (Integer)result[5];
            }
            if (this.log != null) {
                this.log.LogInfo("WeldingGetCurrentRelation(" + relation.currentMin + "," + relation.currentMax + "," + relation.outputVoltageMin + "," + relation.outputVoltageMax + "," + relation.AOIndex + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeldingGetVoltageRelation(WeldVoltageAORelation relation) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("WeldingGetVoltageRelation", params);
            if ((Integer)result[0] == 0) {
                relation.weldVoltageMin = (Double)result[1];
                relation.weldVoltageMax = (Double)result[2];
                relation.outputVoltageMin = (Double)result[3];
                relation.outputVoltageMax = (Double)result[4];
                relation.AOIndex = (Integer)result[5];
            }
            if (this.log != null) {
                this.log.LogInfo("WeldingGetVoltageRelation(" + relation.weldVoltageMin + "," + relation.weldVoltageMax + "," + relation.outputVoltageMin + "," + relation.outputVoltageMax + "," + relation.AOIndex + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeldingSetCurrent(int ioType, double current, int AOIndex, int blend) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{ioType, current, AOIndex, blend};
            int rtn = (Integer)this.client.execute("WeldingSetCurrent", params);
            if (this.log != null) {
                this.log.LogInfo("WeldingSetCurrent(" + ioType + "," + current + "," + AOIndex + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeldingSetVoltage(int ioType, double voltage, int AOIndex, int blend) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{ioType, voltage, AOIndex, blend};
            int rtn = (Integer)this.client.execute("WeldingSetVoltage", params);
            if (this.log != null) {
                this.log.LogInfo("WeldingSetVoltage(" + ioType + "," + voltage + "," + AOIndex + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeaveSetPara(int weaveNum, int weaveType, double weaveFrequency, int weaveIncStayTime, double weaveRange, double weaveLeftRange, double weaveRightRange, int additionalStayTime, int weaveLeftStayTime, int weaveRightStayTime, int weaveCircleRadio, int weaveStationary, double weaveYawAngle) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weaveNum, weaveType, weaveFrequency, weaveIncStayTime, weaveRange, weaveLeftRange, weaveRightRange, additionalStayTime, weaveLeftStayTime, weaveRightStayTime, weaveCircleRadio, weaveStationary, weaveYawAngle};
            int rtn = (Integer)this.client.execute("WeaveSetPara", params);
            if (this.log != null) {
                this.log.LogInfo("WeaveSetPara(" + weaveNum + "," + weaveType + "," + weaveFrequency + "," + weaveIncStayTime + "," + weaveRange + "," + weaveLeftRange + ", " + weaveRightRange + ", " + additionalStayTime + "," + weaveLeftStayTime + "," + weaveRightStayTime + "," + weaveCircleRadio + "," + weaveStationary + "," + weaveYawAngle + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeaveOnlineSetPara(int weaveNum, int weaveType, double weaveFrequency, int weaveIncStayTime, double weaveRange, int weaveLeftStayTime, int weaveRightStayTime, int weaveCircleRadio, int weaveStationary) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weaveNum, weaveType, weaveFrequency, weaveIncStayTime, weaveRange, weaveLeftStayTime, weaveRightStayTime, weaveCircleRadio, weaveStationary};
            int rtn = (Integer)this.client.execute("WeaveOnlineSetPara", params);
            if (this.log != null) {
                this.log.LogInfo("WeaveOnlineSetPara(" + weaveNum + "," + weaveType + "," + weaveFrequency + "," + weaveIncStayTime + "," + weaveRange + "," + weaveLeftStayTime + "," + weaveRightStayTime + "," + weaveCircleRadio + "," + weaveStationary + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeaveStart(int weaveNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weaveNum};
            int rtn = (Integer)this.client.execute("WeaveStart", params);
            if (this.log != null) {
                this.log.LogInfo("WeaveStart(" + weaveNum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage() + "  " + Thread.currentThread().getStackTrace()[1].getLineNumber());
            }
            return -4;
        }
    }

    public int WeaveEnd(int weaveNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weaveNum};
            int rtn = (Integer)this.client.execute("WeaveEnd", params);
            if (this.log != null) {
                this.log.LogInfo("WeaveEnd(" + weaveNum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetForwardWireFeed(int ioType, int wireFeed) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{ioType, wireFeed};
            int rtn = (Integer)this.client.execute("SetForwardWireFeed", params);
            if (this.log != null) {
                this.log.LogInfo("SetForwardWireFeed(" + ioType + "," + wireFeed + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetReverseWireFeed(int ioType, int wireFeed) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{ioType, wireFeed};
            int rtn = (Integer)this.client.execute("SetReverseWireFeed", params);
            if (this.log != null) {
                this.log.LogInfo("SetReverseWireFeed(" + ioType + "," + wireFeed + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAspirated(int ioType, int airControl) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{ioType, airControl};
            int rtn = (Integer)this.client.execute("SetAspirated", params);
            if (this.log != null) {
                this.log.LogInfo("SetAspirated(" + ioType + "," + airControl + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SegmentWeldStart(DescPose startDesePos, DescPose endDesePos, JointPos startJPos, JointPos endJPos, double weldLength, double noWeldLength, int weldIOType, int arcNum, int weldTimeout, boolean isWeave, int weaveNum, int tool, int user, double vel, double acc, double ovl, double blendR, ExaxisPos epos, int search, int offset_flag, DescPose offset_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            int rtn = 0;
            Object[] params = new Object[]{startDesePos.tran.x, startDesePos.tran.y, startDesePos.tran.z, endDesePos.tran.x, endDesePos.tran.y, endDesePos.tran.z};
            Object[] result = (Object[])this.client.execute("GetSegWeldDisDir", params);
            if ((Integer)result[0] != 0) {
                return (Integer)result[0];
            }
            double distance = (Double)result[1];
            double directionX = (Double)result[2];
            double directionY = (Double)result[3];
            double directionZ = (Double)result[4];
            rtn = this.MoveJ(startJPos, startDesePos, tool, user, vel, acc, ovl, epos, -1.0, offset_flag, offset_pos);
            if (rtn != 0) {
                return rtn;
            }
            int weldNum = 0;
            int noWeldNum = 0;
            for (int i = 0; i < (int)(distance / (weldLength + noWeldLength)) * 2 + 2; ++i) {
                Coord coord;
                JointPos tmpJoint;
                DescPose tmpWeldDesc;
                DescPose endOffPos;
                if (i % 2 == 0) {
                    if ((double)(++weldNum) * weldLength + (double)noWeldNum * noWeldLength > distance) {
                        rtn = this.ARCStart(weldIOType, arcNum, weldTimeout);
                        if (rtn != 0) {
                            return rtn;
                        }
                        if (isWeave && (rtn = this.WeaveStart(weaveNum)) != 0) {
                            return rtn;
                        }
                        rtn = this.MoveL(endJPos, endDesePos, tool, user, vel, acc, ovl, blendR, epos, search, 0, offset_pos, 0, 100);
                        if (rtn != 0) {
                            this.ARCEnd(weldIOType, arcNum, weldTimeout);
                            if (isWeave && (rtn = this.WeaveEnd(weaveNum)) != 0) {
                                return rtn;
                            }
                            return rtn;
                        }
                        rtn = this.ARCEnd(weldIOType, arcNum, weldTimeout);
                        if (rtn != 0) {
                            return rtn;
                        }
                        if (!isWeave || (rtn = this.WeaveEnd(weaveNum)) == 0) break;
                        return rtn;
                    }
                    endOffPos = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                    tmpWeldDesc = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                    tmpJoint = new JointPos(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                    coord = new Coord();
                    rtn = this.GetSegmentWeldPoint(startDesePos, endDesePos, (double)weldNum * weldLength + (double)noWeldNum * noWeldLength, tmpWeldDesc, tmpJoint, coord);
                    if (rtn != 0) {
                        return rtn;
                    }
                    rtn = this.ARCStart(weldIOType, arcNum, weldTimeout);
                    if (rtn != 0) {
                        return rtn;
                    }
                    if (isWeave && (rtn = this.WeaveStart(weaveNum)) != 0) {
                        return rtn;
                    }
                    rtn = this.MoveL(tmpJoint, tmpWeldDesc, coord.tool, coord.user, vel, acc, ovl, blendR, epos, search, 0, endOffPos, 0, 1000);
                    if (rtn != 0) {
                        this.ARCEnd(weldIOType, arcNum, weldTimeout);
                        if (isWeave && (rtn = this.WeaveEnd(weaveNum)) != 0) {
                            return rtn;
                        }
                        return rtn;
                    }
                    rtn = this.ARCEnd(weldIOType, arcNum, weldTimeout);
                    if (rtn != 0) {
                        return rtn;
                    }
                    if (!isWeave || (rtn = this.WeaveEnd(weaveNum)) == 0) continue;
                    return rtn;
                }
                if ((double)weldNum * weldLength + (double)(++noWeldNum) * noWeldLength > distance) {
                    rtn = this.MoveL(endJPos, endDesePos, tool, user, vel, acc, ovl, blendR, epos, search, 0, offset_pos, 0, 100);
                    if (rtn == 0) break;
                    return rtn;
                }
                endOffPos = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                tmpWeldDesc = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                tmpJoint = new JointPos(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
                coord = new Coord();
                rtn = this.GetSegmentWeldPoint(startDesePos, endDesePos, (double)weldNum * weldLength + (double)noWeldNum * noWeldLength, tmpWeldDesc, tmpJoint, coord);
                if (rtn != 0) {
                    return rtn;
                }
                rtn = this.MoveL(tmpJoint, tmpWeldDesc, coord.tool, coord.user, vel, acc, ovl, blendR, epos, search, 0, endOffPos, 0, 100);
                if (rtn == 0) continue;
                return rtn;
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetDIConfig(int[] CIConfig) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            String configStr = "SetDIConfig(" + CIConfig[0] + "," + CIConfig[1] + "," + CIConfig[2] + "," + CIConfig[3] + "," + CIConfig[4] + "," + CIConfig[5] + "," + CIConfig[6] + "," + CIConfig[7] + " + )";
            int configLength = configStr.length();
            while (this.isSendCmd) {
                Thread.sleep(10L);
            }
            this.sendBuf = "/f/bIII" + this.ResumeMotionCnt + " + III323III" + configLength + " + III" + configStr + " + III/b/f";
            if (this.log != null) {
                this.log.LogInfo("SetDIConfig(" + configStr + ") : " + this.sockErr);
            }
            ++this.ResumeMotionCnt;
            this.isSendCmd = true;
        }
        catch (Throwable e) {
            return -4;
        }
        return 0;
    }

    public int SetDIConfigLevel(int[] CIConfig) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            String configStr = "SetDIConfigLevel(" + CIConfig[0] + "," + CIConfig[1] + "," + CIConfig[2] + "," + CIConfig[3] + "," + CIConfig[4] + "," + CIConfig[5] + "," + CIConfig[6] + "," + CIConfig[7] + " + )";
            int configLength = configStr.length();
            while (this.isSendCmd) {
                Thread.sleep(10L);
            }
            this.sendBuf = "/f/bIII" + this.ResumeMotionCnt + " + III335III" + configLength + " + III" + configStr + " + III/b/f";
            if (this.log != null) {
                this.log.LogInfo("SetDIConfig(" + configStr + ") : " + this.sockErr);
            }
            ++this.ResumeMotionCnt;
            this.isSendCmd = true;
        }
        catch (Throwable e) {
            return -4;
        }
        return 0;
    }

    private int SegmentWeldEnd(int ioType, int arcNum, int timeout) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = this.ARCEnd(ioType, arcNum, timeout);
            if (rtn != 0) {
                return rtn;
            }
            rtn = this.StopMotion();
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LoggerInit(FrLogType logType, FrLogLevel logLevel, String filePath, int saveFileNum, int saveDays) {
        if (this.log != null) {
            this.log.LogInfo("log has already inited");
            return 0;
        }
        File logFile = new File(filePath);
        if (!logFile.exists()) {
            return -6;
        }
        if (saveDays < 1) {
            return 4;
        }
        this.log = new FRLog(logType, logLevel, filePath, saveFileNum, saveDays);
        this.log.LogInfo("LoggerInit(" + (Object)((Object)logType) + "," + (Object)((Object)logLevel) + "," + filePath + "," + saveFileNum + "," + saveDays + ") : " + 0);
        return 0;
    }

    public int SetLoggerLevel(FrLogLevel logLevel) {
        if (this.log != null) {
            this.log.SetLogLevel(logLevel);
        }
        if (this.log != null) {
            this.log.LogInfo("SetLogLevel(" + (Object)((Object)logLevel) + ") : " + 0);
        }
        return 0;
    }

    private boolean IsSockComError() {
        while (this.robotStateRoutineThread.clientRobotState.GetReconnState()) {
            this.Sleep(10);
        }
        if (this.robotStateRoutineThread.GetSockErr() != 0) {
            this.sockErr = this.robotStateRoutineThread.GetSockErr();
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "sdk socket error" + this.sockErr);
            }
            return true;
        }
        return false;
    }

    public boolean isConnected() {
        return this.IsSockComError();
    }

    private int FileDownLoad(int fileType, String fileName, String saveFilePath) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            File savePathF = new File(saveFilePath);
            if (!savePathF.exists()) {
                return -6;
            }
            Object[] params = new Object[]{fileType, fileName};
            int rtn = (Integer)this.client.execute("FileDownload", params);
            if (rtn != 0) {
                return rtn;
            }
            TCPClient clientDownLoad = new TCPClient(this.robotIp, 20011);
            this.Sleep(500);
            boolean bRtn = clientDownLoad.Connect();
            if (!bRtn) {
                if (this.log != null) {
                    this.log.LogInfo("download file connect fail");
                }
                clientDownLoad.Close();
                System.out.println("connect fail");
                return -1;
            }
            byte[] totalbuffer = new byte[0x3200000];
            int totalSize = 0;
            String recvMd5 = "";
            int recvSize = 0;
            boolean findHeadFlag = false;
            boolean cur = true;
            do {
                byte[] buffer;
                int num;
                if ((num = clientDownLoad.Recv(buffer = new byte[0x3200000])) < 1) {
                    if (this.log != null) {
                        this.log.LogInfo("recv file failed  " + num);
                    }
                    return -1;
                }
                System.arraycopy(buffer, 0, totalbuffer, totalSize, num);
                String head = new String(this.subByte(totalbuffer, 0, 4));
                if (!findHeadFlag && (totalSize += num) > 4 && head.equals("/f/b")) {
                    findHeadFlag = true;
                }
                if (!findHeadFlag || totalSize < 46) continue;
                Object fileSizeStr = new String(this.subByte(totalbuffer, 4, 10));
                fileSizeStr = ((String)fileSizeStr).trim();
                recvSize = Integer.parseInt((String)fileSizeStr);
                recvMd5 = new String(this.subByte(totalbuffer, 14, 32));
            } while (!findHeadFlag || totalSize != recvSize);
            byte[] fileBuffer = this.subByte(totalbuffer, 46, totalSize - 18 - 32);
            File saveFile = new File(saveFilePath + fileName);
            if (!saveFile.exists()) {
                saveFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(saveFilePath + fileName);
            for (Object b : (Object)fileBuffer) {
                out.write((int)b);
            }
            out.close();
            String checkMd5 = this.computeMD5(saveFilePath + fileName).toLowerCase();
            if (checkMd5.equals(recvMd5)) {
                clientDownLoad.Send("SUCCESS");
                if (this.log != null) {
                    this.log.LogInfo("FileDownLoad(" + fileName + ", " + saveFilePath + ") : success");
                }
                return 0;
            }
            clientDownLoad.Send("FAIL");
            saveFile = new File(saveFilePath + fileName);
            saveFile.delete();
            if (this.log != null) {
                this.log.LogInfo("PointTableDownLoad(" + fileName + ", " + saveFilePath + " + ) : FAIL");
            }
            return -1;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    private int FileDownLoad002(int fileType, String fileName, String saveFilePath) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            File savePathF = new File(saveFilePath);
            if (!savePathF.exists()) {
                return -6;
            }
            Object[] params = new Object[]{fileType, fileName};
            int rtn = (Integer)this.client.execute("FileDownload", params);
            if (rtn != 0) {
                return rtn;
            }
            TCPClient clientDownLoad = new TCPClient(this.robotIp, 20011);
            this.Sleep(500);
            if (!clientDownLoad.Connect()) {
                if (this.log != null) {
                    this.log.LogInfo("download file connect fail");
                }
                clientDownLoad.Close();
                return -2;
            }
            ByteArrayOutputStream totalBuffer = new ByteArrayOutputStream(0x3200000);
            String recvMd5 = "";
            int recvSize = 0;
            boolean findHeadFlag = false;
            long startTime = System.currentTimeMillis();
            long DOWNLOAD_TIMEOUT_MS = 15000L;
            byte[] buffer = new byte[8192];
            do {
                if (System.currentTimeMillis() - startTime > 15000L) {
                    if (this.log != null) {
                        this.log.LogError("FileDownLoad", 0, "Download timeout");
                    }
                    return -8;
                }
                int num = clientDownLoad.Recv(buffer);
                if (num < 0) {
                    if (this.log != null) {
                        this.log.LogError("FileDownLoad", 0, "Receive error, code: " + num);
                    }
                    return -8;
                }
                totalBuffer.write(buffer, 0, num);
                if (!findHeadFlag && totalBuffer.size() > 4) {
                    String head = new String(totalBuffer.toByteArray(), 0, 4);
                    if (head.equals("/f/b")) {
                        findHeadFlag = true;
                    } else {
                        if (this.log != null) {
                            this.log.LogError("FileDownLoad", 0, "Invalid file header");
                        }
                        return -8;
                    }
                }
                if (!findHeadFlag || totalBuffer.size() < 46) continue;
                String fileSizeStr = new String(totalBuffer.toByteArray(), 4, 10).trim();
                try {
                    recvSize = Integer.parseInt(fileSizeStr);
                    recvMd5 = new String(totalBuffer.toByteArray(), 14, 32);
                }
                catch (NumberFormatException e) {
                    if (this.log != null) {
                        this.log.LogError("FileDownLoad", 0, "Invalid file size format");
                    }
                    return -8;
                }
            } while (!findHeadFlag || totalBuffer.size() != recvSize);
            byte[] totalBytes = totalBuffer.toByteArray();
            byte[] fileContent = Arrays.copyOfRange(totalBytes, 46, totalBytes.length - 4);
            File saveFile = new File(saveFilePath + fileName);
            try (FileOutputStream out = new FileOutputStream(saveFile);){
                out.write(fileContent);
            }
            String checkMd5 = this.computeMD5(saveFilePath + fileName).toLowerCase();
            if (!checkMd5.equals(recvMd5)) {
                saveFile.delete();
                if (this.log != null) {
                    this.log.LogError("FileDownLoad", 0, "MD5 check failed");
                }
                return -9;
            }
            clientDownLoad.Send("SUCCESS");
            if (this.log != null) {
                this.log.LogInfo("FileDownLoad(" + fileName + ", " + saveFilePath + ") : success");
            }
            return 0;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError("FileDownLoad", 0, "Exception: " + e.getMessage());
            }
            return -4;
        }
    }

    private int FileUpLoad(int fileType, String filePath) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            String resultStr;
            int num;
            File fileInfo = new File(filePath);
            if (!fileInfo.exists()) {
                if (this.log != null) {
                    this.log.LogInfo("file not existed!");
                }
                return -7;
            }
            int totalSize = this.GetFileSize(filePath) + 4 + 46;
            if (totalSize > this.MAX_UPLOAD_FILE_SIZE) {
                if (this.log != null) {
                    this.log.LogInfo("Files larger than 2 MB are not supported!");
                }
                return -1;
            }
            if (this.log != null) {
                this.log.LogInfo("all upload file size is " + totalSize);
            }
            String fileName = fileInfo.getName();
            Object[] params = new Object[]{fileType, fileName};
            int rtn = (Integer)this.client.execute("FileUpload", params);
            if (rtn != 0) {
                if (this.log != null) {
                    this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "execute FileUpload fail : " + rtn);
                }
                return rtn;
            }
            TCPClient clientUpLoad = new TCPClient(this.robotIp, 20010);
            boolean bRtn = clientUpLoad.Connect();
            if (!bRtn) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "FileUpload TCP Connect fail : " + rtn);
                clientUpLoad.Close();
                return -1;
            }
            if (this.log != null) {
                this.log.LogInfo("Upload file connected!");
            }
            String sendMd5 = this.computeMD5(filePath).toLowerCase();
            if (this.log != null) {
                this.log.LogInfo("send Md5 is " + sendMd5);
            }
            if ((num = clientUpLoad.Send("/f/b" + String.format("%10d", totalSize) + sendMd5)) < 1) {
                if (this.log != null) {
                    this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "send head failed!");
                }
                clientUpLoad.Close();
                return -1;
            }
            byte[] bytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            clientUpLoad.Send(bytes);
            num = clientUpLoad.Send("/b/f");
            if (num < 1) {
                if (this.log != null) {
                    this.log.LogError("send end failed!");
                }
                return -1;
            }
            if (this.log != null) {
                this.log.LogError("send file end success!");
            }
            byte[] resultBuf = new byte[1024];
            num = 0;
            for (int i = 0; i < 20 && (num = clientUpLoad.Recv(resultBuf)) <= 0; ++i) {
                this.Sleep(500);
            }
            if (num < 1) {
                if (this.log != null) {
                    this.log.LogError("get result failed! rtn is " + num);
                }
                return -1;
            }
            if (this.log != null) {
                this.log.LogError("recv success!");
            }
            if ((resultStr = new String(resultBuf, StandardCharsets.UTF_8).substring(0, 7)).equals("SUCCESS")) {
                if (this.log != null) {
                    this.log.LogInfo("fileUpLoad(" + filePath + ") : success");
                }
                return 0;
            }
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "upload get result fail!  :  " + resultStr);
            }
            if (this.log != null) {
                this.log.LogError("fileUpLoad(" + filePath + ") : fail");
            }
            return -1;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    private int FileDelete(int fileType, String fileName) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{fileType, fileName};
            int rtn = (Integer)this.client.execute("FileDelete", params);
            if (this.log != null) {
                this.log.LogInfo("FileDelete(" + fileType + "," + fileName + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LuaUpload(String filePath, String errStr) {
        try {
            File fileInfo = new File(filePath);
            if (!fileInfo.exists()) {
                return -7;
            }
            int rtn = this.FileUpLoad(0, filePath);
            if (rtn == 0) {
                Object[] params = new Object[]{fileInfo.getName()};
                Object[] result = (Object[])this.client.execute("LuaUpLoadUpdate", params);
                errStr = (String)result[1];
                if ((Integer)result[0] != 0 && this.log != null) {
                    this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "LuaUpLoadUpdate(" + errStr + ")");
                }
                if (this.log != null) {
                    this.log.LogInfo("LuaUpLoadUpdate(" + filePath + ", " + errStr + ") : " + (Integer)result[0]);
                }
                return (Integer)result[0];
            }
            errStr = "Lua Upload Fail";
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "LuaUpLoadFail(" + filePath + ",  " + errStr + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public int LuaDownLoad(String fileName, String savePath) {
        try {
            int rtn = 0;
            String[] nameStrs = fileName.split("\\.");
            if (nameStrs.length > 2 && Objects.equals(nameStrs[1], "tar") && Objects.equals(nameStrs[2], "gz")) {
                Object[] params = new Object[]{fileName};
                rtn = (Integer)this.client.execute("LuaDownLoadPrepare", params);
                if (this.log != null) {
                    this.log.LogDebug("LuaDownLoad(" + fileName + " +  rtn " + rtn + " + )");
                }
                if (rtn != 0) {
                    return rtn;
                }
            }
            if ((rtn = this.FileDownLoad(0, fileName, savePath)) == -1) {
                return 144;
            }
            return rtn;
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public int LuaDelete(String fileName) {
        int rtn = this.FileDelete(0, fileName);
        return rtn;
    }

    public int GetLuaList(List<String> luaNames) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int luaNum = 0;
            String luaNameStr = "";
            Object[] result = (Object[])this.client.execute("GetLuaList", params);
            if ((Integer)result[0] == 0) {
                luaNum = (Integer)result[1];
                luaNameStr = (String)result[2];
                String[] names = luaNameStr.split(";");
                for (int i = 0; i < luaNum; ++i) {
                    luaNames.add(names[i]);
                }
            }
            if (this.log != null) {
                this.log.LogInfo("GetLuaList(" + luaNameStr + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServoSetParam(int servoId, Axis485Param param) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{servoId, param.servoCompany, param.servoModel, param.servoSoftVersion, param.servoResolution, param.axisMechTransRatio};
            int rtn = (Integer)this.client.execute("AuxServoSetParam", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServoSetParam(" + servoId + "," + param.servoCompany + "," + param.servoModel + "," + param.servoSoftVersion + "," + param.servoResolution + "," + param.axisMechTransRatio + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServoGetParam(int servoId, Axis485Param param) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{servoId};
            Object[] result = (Object[])this.client.execute("AuxServoGetParam", params);
            if ((Integer)result[0] == 0) {
                param.servoCompany = (Integer)result[1];
                param.servoModel = (Integer)result[2];
                param.servoSoftVersion = (Integer)result[3];
                param.servoResolution = (Integer)result[4];
                param.axisMechTransRatio = (Double)result[5];
            }
            if (this.log != null) {
                this.log.LogInfo("AuxServoGetParam(" + servoId + "," + param.servoCompany + "," + param.servoModel + "," + param.servoSoftVersion + "," + param.servoResolution + "," + param.axisMechTransRatio + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServoEnable(int servoId, int status) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{servoId, status};
            int rtn = (Integer)this.client.execute("AuxServoEnable", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServoEnable(" + servoId + "," + status + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServoSetControlMode(int servoId, int mode) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{servoId, mode};
            int rtn = (Integer)this.client.execute("AuxServoSetControlMode", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServoSetControlMode(" + servoId + "," + mode + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServoSetTargetPos(int servoId, double pos, double speed, double acc) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{servoId, pos, speed, acc};
            int rtn = (Integer)this.client.execute("AuxServoSetTargetPos", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServoSetTargetPos(" + servoId + "," + pos + "," + speed + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServoSetTargetSpeed(int servoId, double speed, double acc) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{servoId, speed, acc};
            int rtn = (Integer)this.client.execute("AuxServoSetTargetSpeed", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServoSetTargetSpeed(" + servoId + "," + speed + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServoSetTargetTorque(int servoId, double torque) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{servoId, torque};
            int rtn = (Integer)this.client.execute("AuxServoSetTargetTorque", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServoSetTargetTorque(" + servoId + "," + torque + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServoHoming(int servoId, int mode, double searchVel, double latchVel, double acc) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{servoId, mode, searchVel, latchVel, acc};
            int rtn = (Integer)this.client.execute("AuxServoHoming", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServoHoming(" + servoId + "," + mode + "," + searchVel + "," + latchVel + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServoClearError(int servoId) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{servoId};
            int rtn = (Integer)this.client.execute("AuxServoClearError", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServoClearError(" + servoId + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServosetStatusID(int servoId) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{servoId};
            int rtn = (Integer)this.client.execute("AuxServosetStatusID", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServosetStatusID(" + servoId + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public ROBOT_STATE_PKG GetRobotRealTimeState() {
        if (this.IsSockComError()) {
            return new ROBOT_STATE_PKG();
        }
        return this.robotStateRoutineThread.GetRobotRealTimeState();
    }

    public List<Integer> GetExDevProtocol() {
        ArrayList<Integer> rtnArray = new ArrayList<Integer>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetExDevProtocol", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Integer)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetExDevProtocol(" + (Integer)result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int SetExDevProtocol(int protocol) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{protocol};
            int rtn = (Integer)this.client.execute("SetExDevProtocol", params);
            if (this.log != null) {
                this.log.LogInfo("SetExDevProtocol(" + protocol + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetOaccScale(double acc) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{acc};
            int rtn = (Integer)this.client.execute("SetOaccScale", params);
            if (this.log != null) {
                this.log.LogInfo("SetOaccScale(" + acc + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveAOStart(int AONum, int maxTCPSpeed, int maxAOPercent, int zeroZoneCmp) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{AONum, maxTCPSpeed, maxAOPercent, zeroZoneCmp};
            int rtn = (Integer)this.client.execute("MoveAOStart", params);
            if (this.log != null) {
                this.log.LogInfo("MoveAOStart(" + AONum + ", " + maxTCPSpeed + ", " + maxAOPercent + ", " + zeroZoneCmp + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveAOStop() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("MoveAOStop", params);
            if (this.log != null) {
                this.log.LogInfo("MoveAOStop() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveToolAOStart(int AONum, int maxTCPSpeed, int maxAOPercent, int zeroZoneCmp) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{AONum, maxTCPSpeed, maxAOPercent, zeroZoneCmp};
            int rtn = (Integer)this.client.execute("MoveToolAOStart", params);
            if (this.log != null) {
                this.log.LogInfo("MoveToolAOStart(" + AONum + ", " + maxTCPSpeed + ", " + maxAOPercent + ", " + zeroZoneCmp + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MoveToolAOStop() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("MoveToolAOStop", params);
            if (this.log != null) {
                this.log.LogInfo("MoveToolAOStop() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtDevSetUDPComParam(UDPComParam param) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{param.ip, param.port, param.period, param.lossPkgTime, param.lossPkgNum, param.disconnectTime, param.reconnectEnable, param.reconnectPeriod, param.reconnectNum};
            int rtn = (Integer)this.client.execute("ExtDevSetUDPComParam", params);
            if (this.log != null) {
                this.log.LogInfo("ExtDevSetUDPComParam(" + param.ip + ", " + param.port + ", " + param.period + ", " + param.lossPkgTime + ", " + param.lossPkgNum + ", " + param.disconnectTime + ", " + param.reconnectEnable + ", " + param.reconnectPeriod + ", " + param.reconnectNum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtDevGetUDPComParam(UDPComParam param) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("ExtDevGetUDPComParam", params);
            if ((Integer)result[0] == 0) {
                param.ip = (String)result[1];
                param.port = (Integer)result[2];
                param.period = (Integer)result[3];
                param.lossPkgTime = (Integer)result[4];
                param.lossPkgNum = (Integer)result[5];
                param.disconnectTime = (Integer)result[6];
                param.reconnectEnable = (Integer)result[7];
                param.reconnectPeriod = (Integer)result[8];
                param.reconnectNum = (Integer)result[9];
            }
            if (this.log != null) {
                this.log.LogInfo("ExtDevGetUDPComParam(" + param.ip + ",  " + param.port + " , " + param.period + " , " + param.lossPkgTime + " , " + param.lossPkgNum + " , " + param.disconnectTime + " , " + param.reconnectEnable + " , " + param.reconnectPeriod + " , " + param.reconnectNum + " ) : " + (Integer)result[0] + " ");
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtDevLoadUDPDriver() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ExtDevLoadUDPDriver", params);
            if (this.log != null) {
                this.log.LogInfo("ExtDevLoadUDPDriver() : " + rtn + " ");
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtDevUnloadUDPDriver() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ExtDevUnloadUDPDriver", params);
            if (this.log != null) {
                this.log.LogInfo("ExtDevUnloadUDPDriver() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisSetHoming(int axisID, int mode, double searchVel, double latchVel) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{axisID, mode, searchVel, latchVel};
            int rtn = (Integer)this.client.execute("ExtAxisSetHoming", params);
            if (this.log != null) {
                this.log.LogInfo("ExtAxisSetHoming(" + axisID + ", " + mode + ", " + searchVel + ", " + latchVel + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisStartJog(int axisID, int direction, double vel, double acc, double maxDistance) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{6, axisID, direction, vel, acc, maxDistance};
            int rtn = (Integer)this.client.execute("ExtAxisStartJog", params);
            if (this.log != null) {
                this.log.LogInfo("ExtAxisStartJog(" + axisID + ", " + direction + ", " + vel + ", " + acc + ", " + maxDistance + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisStopJog(int axisID) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            while (this.isSendCmd) {
                Thread.sleep(10L);
            }
            this.sendBuf = "/f/bIII19III240III14IIIStopExtAxisJogIII/b/f";
            this.clientCmd.Send(this.sendBuf);
            byte[] recvBuf = new byte[1024];
            this.clientCmd.Recv(recvBuf);
            this.isSendCmd = true;
            if (this.log != null) {
                this.log.LogInfo("StopExtAxisJog() : " + this.sockErr);
            }
        }
        catch (Throwable e) {
            return -4;
        }
        return 0;
    }

    public int ExtAxisServoOn(int axisID, int status) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{axisID, status};
            int rtn = (Integer)this.client.execute("ExtAxisServoOn", params);
            if (this.log != null) {
                this.log.LogInfo("ExtAxisServoOn(" + axisID + ", " + status + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisMove(ExaxisPos pos, double ovl) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{0, pos.axis1, pos.axis2, pos.axis3, pos.axis4, ovl};
            int rtn = (Integer)this.client.execute("ExtAxisMoveJ", params);
            if (this.log != null) {
                this.log.LogInfo("ExtAxisMove(" + pos.axis1 + ", " + pos.axis2 + ", " + pos.axis3 + ", " + pos.axis4 + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAuxDO(int DONum, boolean bOpen, boolean smooth, boolean block) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            int openFlag = bOpen ? 1 : 0;
            int smoothFlag = smooth ? 1 : 0;
            int noBlockFlag = block ? 0 : 1;
            Object[] params = new Object[]{DONum, openFlag, smoothFlag, 0};
            int rtn = (Integer)this.client.execute("SetAuxDO", params);
            if (this.log != null) {
                this.log.LogInfo("SetAuxDO(" + DONum + ", " + openFlag + ", " + smoothFlag + ", " + noBlockFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAuxAO(int AONum, double value, boolean block) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            boolean noBlockFlag = !block;
            Object[] params = new Object[]{AONum, value, 0};
            int rtn = (Integer)this.client.execute("SetAuxAO", params);
            if (this.log != null) {
                this.log.LogInfo("SetAuxAO(" + AONum + ", " + value + ", " + block + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAuxDIFilterTime(int filterTime) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{filterTime};
            int rtn = (Integer)this.client.execute("SetAuxDIFilterTime", params);
            if (this.log != null) {
                this.log.LogInfo("SetAuxDIFilterTime(" + filterTime + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAuxAIFilterTime(int AONum, int filterTime) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{AONum, filterTime};
            int rtn = (Integer)this.client.execute("SetAuxAIFilterTime", params);
            if (this.log != null) {
                this.log.LogInfo("SetAuxAIFilterTime(" + AONum + "," + filterTime + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WaitAuxDI(int DINum, boolean bOpen, int time, boolean errorAlarm) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            int openFlag = bOpen ? 1 : 0;
            int errorAlarmFlag = errorAlarm ? 1 : 0;
            Object[] params = new Object[]{DINum, openFlag, time, errorAlarmFlag};
            int rtn = (Integer)this.client.execute("WaitAuxDI", params);
            if (this.log != null) {
                this.log.LogInfo("WaitAuxDI(" + DINum + ", " + bOpen + ", " + time + ", " + errorAlarm + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WaitAuxAI(int AINum, int sign, int value, int time, boolean errorAlarm) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            int errorAlarmFlag = errorAlarm ? 1 : 0;
            Object[] params = new Object[]{AINum, sign, value, time, errorAlarmFlag};
            int rtn = (Integer)this.client.execute("WaitAuxAI", params);
            if (this.log != null) {
                this.log.LogInfo("WaitAuxAI(" + AINum + ", " + sign + ", " + value + ", " + time + ", " + errorAlarm + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Integer> GetAuxAI(int AINum, boolean isNoBlock) {
        ArrayList<Integer> rtnArray = new ArrayList<Integer>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            int blockFlag = isNoBlock ? 0 : 1;
            Object[] params = new Object[]{AINum, blockFlag};
            Object[] result = (Object[])this.client.execute("GetAuxAI", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Integer)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetAuxAI(" + AINum + ", " + isNoBlock + ",  " + (Integer)result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int ExtDevUDPClientComReset() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ExtDevUDPClientComReset", params);
            if (this.log != null) {
                this.log.LogInfo("ExtDevUDPClientComReset() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtDevUDPClientComClose() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ExtDevUDPClientComClose", params);
            if (this.log != null) {
                this.log.LogInfo("ExtDevUDPClientComClose() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisParamConfig(int axisID, int axisType, int axisDirection, double axisMax, double axisMin, double axisVel, double axisAcc, double axisLead, int encResolution, double axisOffect, int axisCompany, int axisModel, int axisEncType) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{axisID, axisType, axisDirection, axisMax, axisMin, axisVel, axisAcc, axisLead, encResolution, axisOffect, axisCompany, axisModel, axisEncType};
            int rtn = (Integer)this.client.execute("ExtAxisParamConfig", params);
            if (this.log != null) {
                this.log.LogInfo("ExtAxisParamConfig(" + axisType + ", " + axisDirection + ", " + axisMax + ", " + axisMin + ", " + axisVel + ", " + axisAcc + ", " + axisLead + ", " + encResolution + ", " + axisOffect + ", " + axisCompany + ", " + axisModel + ", " + axisEncType + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    private List<Integer> GetExAxisDriverConfig(int axisId) {
        ArrayList<Integer> rtnArray = new ArrayList<Integer>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{axisId};
            Object[] result = (Object[])this.client.execute("GetExAxisDriverConfig", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Integer)result[1]);
                rtnArray.set(2, (Integer)result[2]);
                rtnArray.set(3, (Integer)result[3]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetExAxisDriverConfig(" + axisId + ",  " + (Integer)result[1] + ",  " + (Integer)result[2] + ",  " + (Integer)result[3] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int SetRobotPosToAxis(int installType) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{installType};
            int rtn = (Integer)this.client.execute("SetRobotPosToAxis", params);
            if (this.log != null) {
                this.log.LogInfo("SetRobotPosToAxis(" + installType + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAxisDHParaConfig(int axisConfig, double axisDHd1, double axisDHd2, double axisDHd3, double axisDHd4, double axisDHa1, double axisDHa2, double axisDHa3, double axisDHa4) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{axisConfig, axisDHd1, axisDHd2, axisDHd3, axisDHd4, axisDHa1, axisDHa2, axisDHa3, axisDHa4};
            int rtn = (Integer)this.client.execute("SetAxisDHParaConfig", params);
            if (this.log != null) {
                this.log.LogInfo("SetAxisDHParaConfig(" + axisConfig + ", " + axisDHd1 + ", " + axisDHd2 + ", " + axisDHd3 + ", " + axisDHd4 + ", " + axisDHa1 + ", " + axisDHa2 + ", " + axisDHa3 + ", " + axisDHa4 + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisSetRefPoint(int pointNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{pointNum};
            int rtn = (Integer)this.client.execute("ExtAxisSetRefPoint", params);
            if (this.log != null) {
                this.log.LogInfo("ExtAxisSetRefPoint(" + pointNum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisComputeECoordSys(DescPose coord) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("ExtAxisComputeECoordSys", params);
            if ((Integer)result[0] == 0) {
                coord.tran.x = (Double)result[1];
                coord.tran.y = (Double)result[2];
                coord.tran.z = (Double)result[3];
                coord.rpy.rx = (Double)result[4];
                coord.rpy.ry = (Double)result[5];
                coord.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("ExtAxisComputeECoordSys(" + coord.tran.x + ",  " + coord.tran.y + ",  " + coord.tran.z + ",  " + coord.rpy.rx + ",  " + coord.rpy.ry + ",  " + coord.rpy.rz + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisActiveECoordSys(int applyAxisId, int axisCoordNum, DescPose coord, int calibFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{applyAxisId, axisCoordNum, coord.tran.x, coord.tran.y, coord.tran.z, coord.rpy.rx, coord.rpy.ry, coord.rpy.rz, calibFlag};
            int rtn = (Integer)this.client.execute("ExtAxisActiveECoordSys", params);
            if (this.log != null) {
                this.log.LogInfo("ExtAxisActiveECoordSys(" + applyAxisId + ", " + axisCoordNum + ", " + coord.tran.x + ", " + coord.tran.y + ", " + coord.tran.z + ", " + coord.rpy.rx + ", " + coord.rpy.ry + ", " + coord.rpy.rz + ", " + calibFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetRefPointInExAxisEnd(DescPose pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{pos.tran.x, pos.tran.y, pos.tran.z, pos.rpy.rx, pos.rpy.ry, pos.rpy.rz};
            int rtn = (Integer)this.client.execute("SetRefPointInExAxisEnd", params);
            if (this.log != null) {
                this.log.LogInfo("SetRefPointInExAxisEnd(" + pos.tran.x + ", " + pos.tran.y + ", " + pos.tran.z + ", " + pos.rpy.rx + ", " + pos.rpy.ry + ", " + pos.rpy.rz + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int PositionorSetRefPoint(int pointNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{pointNum};
            int rtn = (Integer)this.client.execute("PositionorSetRefPoint", params);
            if (this.log != null) {
                this.log.LogInfo("PositionorSetRefPoint(" + pointNum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int PositionorComputeECoordSys(DescPose coord) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("PositionorComputeECoordSys", params);
            if ((Integer)result[0] == 0) {
                coord.tran.x = (Double)result[1];
                coord.tran.y = (Double)result[2];
                coord.tran.z = (Double)result[3];
                coord.rpy.rx = (Double)result[4];
                coord.rpy.ry = (Double)result[5];
                coord.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("PositionorComputeECoordSys(" + coord.tran.x + ",  " + coord.tran.y + ",  " + coord.tran.z + ",  " + coord.rpy.rx + ",  " + coord.rpy.ry + ",  " + coord.rpy.rz + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisSyncMoveJ(JointPos joint_pos, DescPose desc_pos, int tool, int user, double vel, double acc, double ovl, ExaxisPos epos, double blendT, int offset_flag, DescPose offset_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] joint = new Object[]{joint_pos.J1, joint_pos.J2, joint_pos.J3, joint_pos.J4, joint_pos.J5, joint_pos.J6};
            Object[] desc = new Object[]{desc_pos.tran.x, desc_pos.tran.y, desc_pos.tran.z, desc_pos.rpy.rx, desc_pos.rpy.ry, desc_pos.rpy.rz};
            Object[] offect = new Object[]{offset_pos.tran.x, offset_pos.tran.y, offset_pos.tran.z, offset_pos.rpy.rx, offset_pos.rpy.ry, offset_pos.rpy.rz};
            Object[] params = new Object[]{1, epos.axis1, epos.axis2, epos.axis3, epos.axis4, ovl};
            int rtn = (Integer)this.client.execute("ExtAxisMoveJ", params);
            if (rtn != 0) {
                if (this.log != null) {
                    this.log.LogInfo("ExtAxisSyncMoveJ(" + joint[0] + "," + joint[1] + "," + joint[2] + "," + joint[3] + "," + joint[4] + "," + joint[5] + "," + desc[0] + "," + desc[1] + "," + desc[2] + "," + desc[3] + "," + desc[4] + "," + desc[5] + "," + tool + "," + user + "," + vel + "," + acc + "," + ovl + "," + epos.axis1 + "," + epos.axis2 + "," + epos.axis3 + "," + epos.axis4 + "," + blendT + "," + offset_flag + "," + offect[0] + "," + offect[1] + "," + offect[2] + "," + offect[3] + "," + offect[4] + "," + offect[5] + ") : " + rtn);
                }
                return rtn;
            }
            rtn = this.MoveJ(joint_pos, desc_pos, tool, user, vel, acc, ovl, epos, blendT, offset_flag, offset_pos);
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisSyncMoveL(JointPos joint_pos, DescPose desc_pos, int tool, int user, double vel, double acc, double ovl, double blendR, ExaxisPos epos, int offset_flag, DescPose offset_pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            int rtn = -1;
            Object[] offect = new Object[]{offset_pos.tran.x, offset_pos.tran.y, offset_pos.tran.z, offset_pos.rpy.rx, offset_pos.rpy.ry, offset_pos.rpy.rz};
            Object[] params = new Object[]{1, epos.axis1, epos.axis2, epos.axis3, epos.axis4, ovl};
            rtn = (Integer)this.client.execute("ExtAxisMoveJ", params);
            if (rtn != 0) {
                if (this.log != null) {
                    this.log.LogInfo("ExtAxisMoveJ( " + epos.axis1 + "," + epos.axis2 + "," + epos.axis3 + "," + epos.axis4 + "," + offset_flag + "," + offect[0] + "," + offect[1] + "," + offect[2] + "," + offect[3] + "," + offect[4] + "," + offect[5] + ") : " + rtn);
                }
                return rtn;
            }
            Object[] axis = new Object[]{epos.axis1, epos.axis2, epos.axis3, epos.axis4};
            rtn = this.MoveL(joint_pos, desc_pos, tool, user, vel, acc, ovl, blendR, epos, 0, offset_flag, offset_pos, 0, 100);
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ExtAxisSyncMoveC(JointPos joint_pos_p, DescPose desc_pos_p, int ptool, int puser, double pvel, double pacc, ExaxisPos epos_p, int poffset_flag, DescPose offset_pos_p, JointPos joint_pos_t, DescPose desc_pos_t, int ttool, int tuser, double tvel, double tacc, ExaxisPos epos_t, int toffset_flag, DescPose offset_pos_t, double ovl, double blendR) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            int rtn = 0;
            Object[] params = new Object[]{1, epos_t.axis1, epos_t.axis2, epos_t.axis3, epos_t.axis4, ovl};
            rtn = (Integer)this.client.execute("ExtAxisMoveJ", params);
            if (rtn != 0) {
                if (this.log != null) {
                    this.log.LogInfo("ExtAxisMoveJ(" + epos_t.axis1 + "," + epos_t.axis2 + "," + epos_t.axis3 + "," + epos_t.axis4 + "," + blendR + " : " + rtn);
                }
                return rtn;
            }
            rtn = this.MoveC(joint_pos_p, desc_pos_p, ptool, puser, pvel, pacc, epos_p, poffset_flag, offset_pos_p, joint_pos_t, desc_pos_t, ttool, tuser, tvel, tacc, epos_t, toffset_flag, offset_pos_t, ovl, blendR);
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WireSearchStart(int refPos, double searchVel, int searchDis, int autoBackFlag, double autoBackVel, int autoBackDis, int offectFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{refPos, searchVel, searchDis, autoBackFlag, autoBackVel, autoBackDis, offectFlag};
            int rtn = (Integer)this.client.execute("WireSearchStart", params);
            if (this.log != null) {
                this.log.LogInfo("WireSearchStart(" + refPos + ", " + searchVel + ", " + searchDis + ", " + autoBackFlag + ", " + autoBackVel + ", " + autoBackDis + ", " + offectFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WireSearchEnd(int refPos, double searchVel, int searchDis, int autoBackFlag, double autoBackVel, int autoBackDis, int offectFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{refPos, searchVel, searchDis, autoBackFlag, autoBackVel, autoBackDis, offectFlag};
            int rtn = (Integer)this.client.execute("WireSearchEnd", params);
            if (this.log != null) {
                this.log.LogInfo("WireSearchEnd(" + refPos + ", " + searchVel + ", " + searchDis + ", " + autoBackFlag + ", " + autoBackVel + ", " + autoBackDis + ", " + offectFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetWireSearchOffset(int seamType, int method, String[] varNameRef, String[] varNameRes, DescOffset offset) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{seamType, method, varNameRef[0], varNameRef[1], varNameRef[2], varNameRef[3], varNameRef[4], varNameRef[5], varNameRes[0], varNameRes[1], varNameRes[2], varNameRes[3], varNameRes[4], varNameRes[5]};
            Object[] result = (Object[])this.client.execute("GetWireSearchOffset", params);
            if ((Integer)result[0] == 0) {
                offset.offsetFlag = (Integer)result[1];
                offset.offset.tran.x = (Double)result[2];
                offset.offset.tran.y = (Double)result[3];
                offset.offset.tran.z = (Double)result[4];
                offset.offset.rpy.rx = (Double)result[5];
                offset.offset.rpy.ry = (Double)result[6];
                offset.offset.rpy.rz = (Double)result[7];
            }
            if (this.log != null) {
                this.log.LogInfo("GetWireSearchOffect(" + seamType + ", " + method + ", " + varNameRef[0] + ", " + varNameRef[1] + ", " + varNameRef[2] + ", " + varNameRef[3] + ", " + varNameRef[4] + ", " + varNameRef[5] + ", " + varNameRes[0] + ", " + varNameRes[1] + ", " + varNameRes[2] + ", " + varNameRes[3] + ", " + varNameRes[4] + ", " + varNameRes[5] + ", " + offset.offsetFlag + ", " + offset.offset.tran.x + ",  " + offset.offset.tran.y + ",  " + offset.offset.tran.z + ",  " + offset.offset.rpy.rx + ",  " + offset.offset.rpy.ry + ",  " + offset.offset.rpy.rz + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WireSearchWait(String name) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{name};
            int rtn = (Integer)this.client.execute("WireSearchWait", params);
            if (this.log != null) {
                this.log.LogInfo("WireSearchWait(" + name + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetPointToDatabase(String varName, DescPose pos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] tmpPos = new Object[]{pos.tran.x, pos.tran.y, pos.tran.z, pos.rpy.rx, pos.rpy.ry, pos.rpy.rz};
            Object[] params = new Object[]{varName, tmpPos};
            int rtn = (Integer)this.client.execute("SetPointToDatabase", params);
            if (this.log != null) {
                this.log.LogInfo("SetPointToDatabase(" + varName + ", " + pos.tran.x + ", " + pos.tran.y + ", " + pos.tran.z + ", " + pos.rpy.rx + ", " + pos.rpy.ry + ", " + pos.rpy.rz + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ArcWeldTraceControl(int flag, double delaytime, int isLeftRight, double klr, double tStartLr, double stepMaxLr, double sumMaxLr, int isUpLow, double kud, double tStartUd, double stepMaxUd, double sumMaxUd, int axisSelect, int referenceType, double referSampleStartUd, double referSampleCountUd, double referenceCurrent, int offsetType, int offsetParameter) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] paramLR = new Object[]{klr, tStartLr, stepMaxLr, sumMaxLr};
            Object[] paramUD = new Object[]{kud, tStartUd, stepMaxUd, sumMaxUd};
            Object[] params = new Object[]{flag, delaytime, isLeftRight, paramLR, isUpLow, paramUD, axisSelect, referenceType, referSampleStartUd, referSampleCountUd, referenceCurrent, offsetType, offsetParameter};
            int rtn = (Integer)this.client.execute("ArcWeldTraceControl", params);
            if (this.log != null) {
                this.log.LogInfo("ArcWeldTraceControl(" + flag + ", " + delaytime + ", " + isLeftRight + ", " + klr + ", " + tStartLr + ", " + stepMaxLr + ", " + sumMaxLr + ", " + isUpLow + ", " + kud + ", " + tStartUd + ", " + stepMaxUd + ", " + sumMaxUd + ", " + axisSelect + ", " + referenceType + ", " + referSampleStartUd + ", " + referSampleCountUd + ", " + referenceCurrent + "," + offsetType + ", " + offsetParameter + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ArcWeldTraceExtAIChannelConfig(int channel) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{channel};
            int rtn = (Integer)this.client.execute("ArcWeldTraceExtAIChannelConfig", params);
            if (this.log != null) {
                this.log.LogInfo("ArcWeldTraceExtAIChannelConfig(" + channel + " ) : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int EndForceDragControl(int status, int asaptiveFlag, int interfereDragFlag, int ingularityConstraintsFlag, Object[] M, Object[] B, Object[] K, Object[] F, double Fmax, double Vmax) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{status, asaptiveFlag, interfereDragFlag, ingularityConstraintsFlag, M, B, K, F, Fmax, Vmax};
            int rtn = (Integer)this.client.execute("EndForceDragControl", params);
            if (this.log != null) {
                this.log.LogInfo("EndForceDragControl(" + status + ", " + asaptiveFlag + ", " + interfereDragFlag + ", " + Arrays.toString(M) + ", " + Arrays.toString(B) + ", " + Arrays.toString(K) + ", " + Arrays.toString(F) + ", " + Fmax + ", " + Vmax + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetForceSensorDragAutoFlag(int status) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{status};
            int rtn = (Integer)this.client.execute("SetForceSensorDragAutoFlag", params);
            if (this.log != null) {
                this.log.LogInfo("SetForceSensorDragAutoFlag(" + status + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ForceAndJointImpedanceStartStop(int status, int impedanceFlag, Object[] lamdeGain, Object[] KGain, Object[] BGain, double dragMaxTcpVel, double dragMaxTcpOriVel) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{status, impedanceFlag, lamdeGain, KGain, BGain, dragMaxTcpVel, dragMaxTcpOriVel};
            int rtn = (Integer)this.client.execute("ForceAndJointImpedanceStartStop", params);
            if (this.log != null) {
                this.log.LogInfo("ForceAndJointImpedanceStartStop(" + status + ", " + impedanceFlag + ", " + Arrays.toString(lamdeGain) + ", " + Arrays.toString(KGain) + ", " + Arrays.toString(BGain) + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Integer> GetForceAndTorqueDragState() {
        ArrayList<Integer> rtnArray = new ArrayList<Integer>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetForceAndTorqueDragState", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Integer)result[1]);
                rtnArray.set(2, (Integer)result[2]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetForceAndTorqueDragState(" + (Integer)result[1] + ",  " + (Integer)result[2] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int SetForceSensorPayLoad(double weight) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weight};
            int rtn = (Integer)this.client.execute("SetForceSensorPayload", params);
            if (this.log != null) {
                this.log.LogInfo("SetForceSensorPayLoad(" + weight + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetForceSensorPayLoadCog(DescTran cog) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{cog.x, cog.y, cog.z};
            int rtn = (Integer)this.client.execute("SetForceSensorPayloadCog", params);
            if (this.log != null) {
                this.log.LogInfo("SetForceSensorPayLoadCog(" + cog.x + ", " + cog.y + ", " + cog.z + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Number> GetForceSensorPayLoad() {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        if (this.IsSockComError()) {
            rtnArray.set(0, this.sockErr);
            return rtnArray;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetForceSensorPayload", params);
            rtnArray.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArray.set(1, (Double)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetForceSensorPayLoad(" + (Double)result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int GetForceSensorPayLoadCog(DescTran cog) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetForceSensorPayloadCog", params);
            if ((Integer)result[0] == 0) {
                cog.x = (Double)result[1];
                cog.y = (Double)result[2];
                cog.z = (Double)result[3];
            }
            if (this.log != null) {
                this.log.LogInfo("GetForceSensorPayLoadCog(" + cog.x + ",  " + cog.y + ",  " + cog.z + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ForceSensorAutoComputeLoad(MassCenter massCenter) {
        JointPos startJ = new JointPos(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose startDesc = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.GetActualJointPosDegree(startJ);
        this.GetActualTCPPose(startDesc);
        JointPos tmpJPos = new JointPos(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose tmpDescPos = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        DescPose offectPos = new DescPose(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        ExaxisPos tmpExaxisPos = new ExaxisPos(0.0, 0.0, 0.0, 0.0);
        this.ForceSensorSetSaveDataFlag(1);
        this.GetActualJointPosDegree(tmpJPos);
        if (tmpJPos.J3 < 0.0) {
            tmpJPos.J4 += 90.0;
            this.GetForwardKin(tmpJPos, tmpDescPos);
        } else {
            tmpJPos.J4 -= 90.0;
            this.GetForwardKin(tmpJPos, tmpDescPos);
        }
        this.MoveJ(tmpJPos, tmpDescPos, 0, 0, 100.0, 100.0, 100.0, tmpExaxisPos, -1.0, 0, offectPos);
        this.ForceSensorSetSaveDataFlag(2);
        this.GetActualJointPosDegree(tmpJPos);
        if (tmpJPos.J6 < 0.0) {
            tmpJPos.J6 += 90.0;
            this.GetForwardKin(tmpJPos, tmpDescPos);
        } else {
            tmpJPos.J6 -= 90.0;
            this.GetForwardKin(tmpJPos, tmpDescPos);
        }
        this.MoveJ(tmpJPos, tmpDescPos, 0, 0, 100.0, 100.0, 100.0, tmpExaxisPos, -1.0, 0, offectPos);
        this.ForceSensorSetSaveDataFlag(3);
        this.ForceSensorComputeLoad(massCenter);
        this.WaitMs(100);
        this.MoveJ(startJ, startDesc, 0, 0, 100.0, 100.0, 100.0, tmpExaxisPos, -1.0, 0, offectPos);
        return 0;
    }

    public int ForceSensorSetSaveDataFlag(int recordCount) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{recordCount};
            int rtn = (Integer)this.client.execute("ForceSensorSetSaveDataFlag", params);
            if (this.log != null) {
                this.log.LogInfo("ForceSensorSetSaveDataFlag(" + recordCount + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ForceSensorComputeLoad(MassCenter massCenter) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("ForceSensorComputeLoad", params);
            if ((Integer)result[0] == 0) {
                massCenter.weight = (Double)result[1];
                massCenter.cog.x = (Double)result[2];
                massCenter.cog.y = (Double)result[3];
                massCenter.cog.z = (Double)result[4];
            }
            if (this.log != null) {
                this.log.LogInfo("ForceSensorComputeLoad(" + massCenter.weight + ",  " + massCenter.cog.x + ",  " + massCenter.cog.y + ",  " + massCenter.cog.z + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetSegmentWeldPoint(DescPose startPos, DescPose endPos, double startDistance, DescPose weldPointDesc, JointPos weldPointJoint, Coord coord) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] tmpStartDesc = new Object[]{startPos.tran.x, startPos.tran.y, startPos.tran.z, startPos.rpy.rx, startPos.rpy.ry, startPos.rpy.rz};
            Object[] tmpEndDesc = new Object[]{endPos.tran.x, endPos.tran.y, endPos.tran.z, endPos.rpy.rx, endPos.rpy.ry, endPos.rpy.rz};
            Object[] params = new Object[]{tmpStartDesc, tmpEndDesc, startDistance};
            Object[] result = (Object[])this.client.execute("GetSegmentWeldPoint", params);
            if ((Integer)result[0] == 0) {
                String paramStr = (String)result[1];
                String[] parS = paramStr.split(",");
                if (parS.length != 14) {
                    this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "get segment weld point fail");
                    return -1;
                }
                weldPointJoint.J1 = Double.parseDouble(parS[0]);
                weldPointJoint.J2 = Double.parseDouble(parS[1]);
                weldPointJoint.J3 = Double.parseDouble(parS[2]);
                weldPointJoint.J4 = Double.parseDouble(parS[3]);
                weldPointJoint.J5 = Double.parseDouble(parS[4]);
                weldPointJoint.J6 = Double.parseDouble(parS[5]);
                weldPointDesc.tran.x = Double.parseDouble(parS[6]);
                weldPointDesc.tran.y = Double.parseDouble(parS[7]);
                weldPointDesc.tran.z = Double.parseDouble(parS[8]);
                weldPointDesc.rpy.rx = Double.parseDouble(parS[9]);
                weldPointDesc.rpy.ry = Double.parseDouble(parS[10]);
                weldPointDesc.rpy.rz = Double.parseDouble(parS[11]);
                coord.tool = (int)Double.parseDouble(parS[12]);
                coord.user = (int)Double.parseDouble(parS[13]);
                if (this.log != null) {
                    this.log.LogInfo("GetSegmentWeldPoint(" + startPos + ",  " + endPos + ", " + startDistance + ",  " + weldPointDesc + ") : " + (Integer)result[0]);
                }
                return (Integer)result[0];
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeldingSetProcessParam(int id, WeldingProcessParam param) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, param.startCurrent, param.startVoltage, (double)param.startTime * 1.0, param.weldCurrent, param.weldVoltage, param.endCurrent, param.endVoltage, (double)param.endTime * 1.0};
            int rtn = (Integer)this.client.execute("WeldingSetProcessParam", params);
            if (this.log != null) {
                this.log.LogInfo("WeldingSetProcessParam(" + id + ", " + param.startCurrent + ", " + param.startVoltage + ", " + param.startTime + ", " + param.weldCurrent + ", " + param.weldVoltage + ", " + param.endCurrent + ", " + param.endVoltage + ", " + param.endTime + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeldingGetProcessParam(int id, WeldingProcessParam param) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id};
            Object[] result = (Object[])this.client.execute("WeldingGetProcessParam", params);
            if ((Integer)result[0] == 0) {
                param.startCurrent = (Double)result[1];
                param.startVoltage = (Double)result[2];
                param.startTime = (int)((Double)result[3]).doubleValue();
                param.weldCurrent = (Double)result[4];
                param.weldVoltage = (Double)result[5];
                param.endCurrent = (Double)result[6];
                param.endVoltage = (Double)result[7];
                param.endTime = (int)((Double)result[8]).doubleValue();
            }
            if (this.log != null) {
                this.log.LogInfo("WeldingGetProcessParam(" + id + ",  " + param.startCurrent + ",  " + param.startVoltage + ",  " + param.startTime + ",  " + param.weldCurrent + ",  " + param.weldVoltage + ",  " + param.endCurrent + ",  " + param.endVoltage + ",  " + param.endTime + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AxleSensorConfig(DeviceConfig config) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{config.company, config.device, config.softwareVersion, config.bus};
            int rtn = (Integer)this.client.execute("AxleSensorConfig", params);
            if (this.log != null) {
                this.log.LogInfo("AxleSensorConfig(" + config.company + ", " + config.device + ", " + config.softwareVersion + ", " + config.bus + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AxleSensorConfigGet(DeviceConfig config) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("AxleSensorConfigGet", params);
            if ((Integer)result[0] == 0) {
                config.company = (Integer)result[1] + 1;
                config.device = (Integer)result[2];
            }
            if (this.log != null) {
                this.log.LogInfo("AxleSensorConfigGet(" + config.company + ",  " + config.device + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AxleSensorActivate(int actFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{actFlag};
            int rtn = (Integer)this.client.execute("AxleSensorActivate", params);
            if (this.log != null) {
                this.log.LogInfo("AxleSensorActivate(" + actFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AxleSensorRegWrite(int devAddr, int regHAddr, int regLAddr, int regNum, int data1, int data2, int isNoBlock) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{devAddr, regHAddr, regLAddr, regNum, data1, data2, isNoBlock};
            int rtn = (Integer)this.client.execute("AxleSensorRegWrite", params);
            if (this.log != null) {
                this.log.LogInfo("AxleSensorRegWrite(" + devAddr + ", " + regHAddr + ", " + regLAddr + ", " + regNum + ", " + data1 + ", " + data2 + ", " + isNoBlock + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetOutputResetCtlBoxDO(int resetFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{resetFlag};
            int rtn = (Integer)this.client.execute("SetOutputResetCtlBoxDO", params);
            if (this.log != null) {
                this.log.LogInfo("SetOutputResetCtlBoxDO(" + resetFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetOutputResetCtlBoxAO(int resetFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{resetFlag};
            int rtn = (Integer)this.client.execute("SetOutputResetCtlBoxAO", params);
            if (this.log != null) {
                this.log.LogInfo("SetOutputResetCtlBoxAO(" + resetFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetOutputResetAxleDO(int resetFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{resetFlag};
            int rtn = (Integer)this.client.execute("SetOutputResetAxleDO", params);
            if (this.log != null) {
                this.log.LogInfo("SetOutputResetAxleDO(" + resetFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetOutputResetAxleAO(int resetFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{resetFlag};
            int rtn = (Integer)this.client.execute("SetOutputResetAxleAO", params);
            if (this.log != null) {
                this.log.LogInfo("SetOutputResetAxleAO(" + resetFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetOutputResetExtDO(int resetFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{resetFlag};
            int rtn = (Integer)this.client.execute("SetOutputResetExtDO", params);
            if (this.log != null) {
                this.log.LogInfo("SetOutputResetExtDO(" + resetFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetOutputResetExtAO(int resetFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{resetFlag};
            int rtn = (Integer)this.client.execute("SetOutputResetExtAO", params);
            if (this.log != null) {
                this.log.LogInfo("SetOutputResetExtAO(" + resetFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetOutputResetSmartToolDO(int resetFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{resetFlag};
            int rtn = (Integer)this.client.execute("SetOutputResetSmartToolDO", params);
            if (this.log != null) {
                this.log.LogInfo("SetOutputResetSmartToolDO(" + resetFlag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeaveStartSim(int weaveNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weaveNum};
            int rtn = (Integer)this.client.execute("WeaveStartSim", params);
            if (this.log != null) {
                this.log.LogInfo("WeaveStartSim(" + weaveNum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeaveEndSim(int weaveNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weaveNum};
            int rtn = (Integer)this.client.execute("WeaveEndSim", params);
            if (this.log != null) {
                this.log.LogInfo("WeaveEndSim(" + weaveNum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeaveInspectStart(int weaveNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weaveNum};
            int rtn = (Integer)this.client.execute("WeaveInspectStart", params);
            if (this.log != null) {
                this.log.LogInfo("WeaveInspectStart(" + weaveNum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeaveInspectEnd(int weaveNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weaveNum};
            int rtn = (Integer)this.client.execute("WeaveInspectEnd", params);
            if (this.log != null) {
                this.log.LogInfo("WeaveInspectEnd(" + weaveNum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeaveChangeStart(int weaveNum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{weaveNum};
            int rtn = (Integer)this.client.execute("WeaveChangeStart", params);
            if (this.log != null) {
                this.log.LogInfo("WeaveChangeStart(" + weaveNum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int WeaveChangeEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("WeaveChangeEnd", params);
            if (this.log != null) {
                this.log.LogInfo("WeaveChangeEnd() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAirControlExtDoNum(int DONum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{DONum};
            int rtn = (Integer)this.client.execute("SetAirControlExtDoNum", params);
            if (this.log != null) {
                this.log.LogInfo("SetAirControlExtDoNum(" + DONum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetArcStartExtDoNum(int DONum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{DONum};
            int rtn = (Integer)this.client.execute("SetArcStartExtDoNum", params);
            if (this.log != null) {
                this.log.LogInfo("SetArcStartExtDoNum(" + DONum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetWireReverseFeedExtDoNum(int DONum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{DONum};
            int rtn = (Integer)this.client.execute("SetWireReverseFeedExtDoNum", params);
            if (this.log != null) {
                this.log.LogInfo("SetWireReverseFeedExtDoNum(" + DONum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetWireForwardFeedExtDoNum(int DONum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{DONum};
            int rtn = (Integer)this.client.execute("SetWireForwardFeedExtDoNum", params);
            if (this.log != null) {
                this.log.LogInfo("SetWireForwardFeedExtDoNum(" + DONum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetArcDoneExtDiNum(int DINum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{DINum};
            int rtn = (Integer)this.client.execute("SetArcDoneExtDiNum", params);
            if (this.log != null) {
                this.log.LogInfo("SetArcDoneExtDINum(" + DINum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetWeldReadyExtDiNum(int DINum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{DINum};
            int rtn = (Integer)this.client.execute("SetWeldReadyExtDiNum", params);
            if (this.log != null) {
                this.log.LogInfo("SetWeldReadyExtDiNum(" + DINum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetExtDIWeldBreakOffRecover(int reWeldDINum, int abortWeldDINum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{reWeldDINum, abortWeldDINum};
            int rtn = (Integer)this.client.execute("SetExtDIWeldBreakOffRecover", params);
            if (this.log != null) {
                this.log.LogInfo("SetExtDIWeldBreakOffRecover(" + reWeldDINum + "," + abortWeldDINum + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetCollisionDetectionMethod(int method) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{method};
            int rtn = (Integer)this.client.execute("SetCollisionDetectionMethod", params);
            if (this.log != null) {
                this.log.LogInfo("SetCollisionDetectionMethod(" + method + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetStaticCollisionOnOff(int status) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{status};
            int rtn = 0;
            this.client.execute("SetStaticCollisionOnOff", params);
            if (this.log != null) {
                this.log.LogInfo("SetStaticCollisionOnOff(" + status + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int CustomCollisionDetectionStart(int flag, double[] jointDetectionThreshould, double[] tcpDetectionThreshould, int block) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params1 = new Object[]{jointDetectionThreshould[0], jointDetectionThreshould[1], jointDetectionThreshould[2], jointDetectionThreshould[3], jointDetectionThreshould[4], jointDetectionThreshould[5]};
            Object[] params2 = new Object[]{tcpDetectionThreshould[0], tcpDetectionThreshould[1], tcpDetectionThreshould[2], tcpDetectionThreshould[3], tcpDetectionThreshould[4], tcpDetectionThreshould[5]};
            Object[] params = new Object[]{flag, params1, params2, block};
            int rtn = (Integer)this.client.execute("CustomCollisionDetectionStart", params);
            if (this.log != null) {
                this.log.LogInfo("CustomCollisionDetectionStart(" + flag + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int CustomCollisionDetectionEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("CustomCollisionDetectionEnd", params);
            if (this.log != null) {
                this.log.LogInfo("CustomCollisionDetectionEnd() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetPowerLimit(int status, double power) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{status, power};
            int rtn = (Integer)this.client.execute("SetPowerLimit", params);
            if (this.log != null) {
                this.log.LogInfo("SetPowerLimit(" + status + "," + power + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ServoJTStart() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ServoJTStart", params);
            if (this.log != null) {
                this.log.LogInfo("ServoJTStart() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ServoJT(Object[] torque, double interval) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{torque, interval};
            int rtn = (Integer)this.client.execute("ServoJT", params);
            if (this.log != null) {
                this.log.LogInfo("ServoJT() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ServoJTEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ServoJTEnd", params);
            if (this.log != null) {
                this.log.LogInfo("ServoJTEnd() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetRobotRealtimeStateSamplePeriod(int period) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{period};
            int rtn = (Integer)this.client.execute("SetRobotRealtimeStateSamplePeriod", params);
            if (this.log != null) {
                this.log.LogInfo("SetRobotRealtimeStateSamplePeriod(" + period + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Integer> GetRobotRealtimeStateSamplePeriod() {
        ArrayList<Integer> rtnArr = new ArrayList<Integer>(){};
        rtnArr.add(-1);
        rtnArr.add(-1);
        if (this.IsSockComError()) {
            rtnArr.set(0, this.sockErr);
            return rtnArr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetRobotRealtimeStateSamplePeriod", params);
            rtnArr.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArr.set(1, (Integer)result[1]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetRobotRealtimeStateSamplePeriod(" + (Integer)result[1] + ") : " + (Integer)result[0]);
            }
            return rtnArr;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArr.set(0, -4);
            return rtnArr;
        }
    }

    public int GetJointDriverTemperature(double[] temperature) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            ROBOT_STATE_PKG pkg = this.GetRobotRealTimeState();
            for (int i = 0; i < 6; ++i) {
                temperature[i] = pkg.jointDriverTemperature[i];
            }
            return this.sockErr;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetJointDriverTorque(double[] torque) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            ROBOT_STATE_PKG pkg = this.GetRobotRealTimeState();
            for (int i = 0; i < 6; ++i) {
                torque[i] = pkg.jointDriverTorque[i];
            }
            return this.sockErr;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ArcWeldTraceReplayStart() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ArcWeldTraceReplayStart", params);
            if (this.log != null) {
                this.log.LogInfo("ArcWeldTraceReplayStart() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ArcWeldTraceReplayEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("ArcWeldTraceReplayEnd", params);
            if (this.log != null) {
                this.log.LogInfo("ArcWeldTraceReplayEnd() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int MultilayerOffsetTrsfToBase(DescTran pointO, DescTran pointX, DescTran pointZ, double dx, double dz, double dry, DescPose offset) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{pointO.x, pointO.y, pointO.z, pointX.x, pointX.y, pointX.z, pointZ.x, pointZ.y, pointZ.z, dx, dz, dry};
            Object[] result = (Object[])this.client.execute("MultilayerOffsetTrsfToBase", params);
            if ((Integer)result[0] == 0) {
                offset.tran.x = (Double)result[1];
                offset.tran.y = (Double)result[2];
                offset.tran.z = (Double)result[3];
                offset.rpy.rx = (Double)result[4];
                offset.rpy.ry = (Double)result[5];
                offset.rpy.rz = (Double)result[6];
            }
            if (this.log != null) {
                this.log.LogInfo("MultilayerOffsetTrsfToBase(" + pointO.x + "," + pointO.y + "," + pointO.z + "," + pointX.x + "," + pointX.y + "," + pointX.z + "," + pointZ.x + "," + pointZ.y + "," + pointZ.z + "," + dx + "," + dz + "," + dry + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AngularSpeedStart(int ratio) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{ratio};
            int rtn = (Integer)this.client.execute("AngularSpeedStart", params);
            if (this.log != null) {
                this.log.LogInfo("AngularSpeedStart(" + ratio + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AngularSpeedEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("AngularSpeedEnd", params);
            if (this.log != null) {
                this.log.LogInfo("AngularSpeedEnd() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SoftwareUpgrade(String filePath, boolean block) {
        try {
            File fileInfo = new File(filePath);
            if (!fileInfo.exists()) {
                return -7;
            }
            int rtn = this.FileUpLoad(1, filePath);
            if (rtn == 0) {
                Object[] params = new Object[0];
                rtn = (Integer)this.client.execute("SoftwareUpgrade", params);
                if (rtn != 0 && this.log != null) {
                    this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "Software UpLoad fail");
                }
                if (block) {
                    this.Sleep(3000);
                    int state = this.GetSoftwareUpgradeState().get(1);
                    if (state == 0 && this.log != null) {
                        this.log.LogError("software upgrade not start");
                        return -1;
                    }
                    while (state > 0 && state < 100) {
                        this.Sleep(500);
                        state = this.GetSoftwareUpgradeState().get(1);
                    }
                    rtn = state == 100 ? 0 : state;
                }
                if (this.log != null) {
                    this.log.LogInfo("SoftwareUpgrade(" + filePath + ") : " + rtn);
                }
                return rtn;
            }
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "Software UpLoad Fail(" + filePath + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public List<Integer> GetSoftwareUpgradeState() {
        ArrayList<Integer> rtnArr = new ArrayList<Integer>(){};
        rtnArr.add(-1);
        rtnArr.add(-1);
        if (this.IsSockComError()) {
            rtnArr.set(0, this.sockErr);
            return rtnArr;
        }
        try {
            ROBOT_STATE_PKG pkg = this.GetRobotRealTimeState();
            rtnArr.set(1, pkg.softwareUpgradeState);
            return rtnArr;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArr.set(0, -4);
            return rtnArr;
        }
    }

    public int AuxServoSetAcc(double acc, double dec) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{acc, dec};
            int rtn = (Integer)this.client.execute("AuxServoSetAcc", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServoSetAcc(" + acc + "," + dec + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AuxServoSetEmergencyStopAcc(double acc, double dec) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{acc, dec};
            int rtn = (Integer)this.client.execute("AuxServoSetEmergencyStopAcc", params);
            if (this.log != null) {
                this.log.LogInfo("AuxServoSetEmergencyStopAcc(" + acc + "," + dec + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Number> AuxServoGetAcc() {
        ArrayList<Number> rtnArr = new ArrayList<Number>(){};
        rtnArr.add(-1);
        rtnArr.add(-1);
        rtnArr.add(-1);
        if (this.IsSockComError()) {
            rtnArr.set(0, this.sockErr);
            return rtnArr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("AuxServoGetAcc", params);
            rtnArr.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArr.set(1, (Double)result[1]);
                rtnArr.set(2, (Double)result[2]);
            }
            if (this.log != null) {
                this.log.LogInfo("AuxServoGetAcc(" + (Double)result[1] + "," + (Double)result[2] + ") : " + (Integer)result[0]);
            }
            return rtnArr;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArr.set(0, -4);
            return rtnArr;
        }
    }

    public List<Number> AuxServoGetEmergencyStopAcc() {
        ArrayList<Number> rtnArr = new ArrayList<Number>(){};
        rtnArr.add(-1);
        rtnArr.add(-1);
        rtnArr.add(-1);
        if (this.IsSockComError()) {
            rtnArr.set(0, this.sockErr);
            return rtnArr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("AuxServoGetEmergencyStopAcc", params);
            rtnArr.set(0, (Integer)result[0]);
            if ((Integer)result[0] == 0) {
                rtnArr.set(1, (Double)result[1]);
                rtnArr.set(2, (Double)result[2]);
            }
            if (this.log != null) {
                this.log.LogInfo("AuxServoGetEmergencyStopAcc(" + (Double)result[1] + "," + (Double)result[2] + ") : " + (Integer)result[0]);
            }
            return rtnArr;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArr.set(0, -4);
            return rtnArr;
        }
    }

    public int GetAxleCommunicationParam(AxleComParam param) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetAxleCommunicationParam", params);
            if ((Integer)result[0] == 0) {
                param.baudRate = (Integer)result[1];
                param.dataBit = (Integer)result[2];
                param.stopBit = (Integer)result[3];
                param.verify = (Integer)result[4];
                param.timeout = (Integer)result[5];
                param.timeoutTimes = (Integer)result[6];
                param.period = (Integer)result[7];
            }
            if (this.log != null) {
                this.log.LogInfo("GetAxleCommunicationParam(" + param.baudRate + ",  " + param.dataBit + ",  " + param.stopBit + ",  " + param.verify + ",  " + param.timeout + ",  " + param.timeoutTimes + ",  " + param.period + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAxleCommunicationParam(AxleComParam param) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{param.baudRate, param.dataBit, param.stopBit, param.verify, param.timeout, param.timeoutTimes, param.period};
            int rtn = (Integer)this.client.execute("SetAxleCommunicationParam", params);
            if (this.log != null) {
                this.log.LogInfo("SetAxleCommunicationParam(" + param.baudRate + "," + param.dataBit + "," + param.stopBit + "," + param.verify + "," + param.timeout + "," + param.timeoutTimes + "," + param.period + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAxleFileType(int type) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{type};
            int rtn = (Integer)this.client.execute("SetAxleFileType", params);
            if (this.log != null) {
                this.log.LogInfo("SetAxleFileType(" + type + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAxleLuaEnable(int enable) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{enable};
            int rtn = (Integer)this.client.execute("SetAxleLuaEnable", params);
            if (this.log != null) {
                this.log.LogInfo("SetAxleLuaEnable(" + enable + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetRecoverAxleLuaErr(int status) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{status};
            int rtn = (Integer)this.client.execute("SetRecoverAxleLuaErr", params);
            if (this.log != null) {
                this.log.LogInfo("SetRecoverAxleLuaErr(" + status + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetAxleLuaEnableStatus(int[] status) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetAxleLuaEnableStatus", params);
            if ((Integer)result[0] == 0) {
                status[0] = (Integer)result[1];
            }
            if (this.log != null) {
                this.log.LogInfo("GetAxleLuaEnableStatus(" + status[0] + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAxleLuaEnableDeviceType(int forceSensorEnable, int gripperEnable, int IOEnable) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{forceSensorEnable, gripperEnable, IOEnable};
            int rtn = (Integer)this.client.execute("SetAxleLuaEnableDeviceType", params);
            if (this.log != null) {
                this.log.LogInfo("SetAxleLuaEnableDeviceType(" + forceSensorEnable + "," + gripperEnable + "," + IOEnable + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetAxleLuaEnableDeviceType(int[] enable) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetAxleLuaEnableDeviceType", params);
            if ((Integer)result[0] == 0) {
                enable[0] = (Integer)result[1];
                enable[1] = (Integer)result[2];
                enable[2] = (Integer)result[3];
            }
            if (this.log != null) {
                this.log.LogInfo("GetAxleLuaEnableDeviceType(" + enable[0] + "," + enable[1] + "," + enable[2] + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetAxleLuaEnableDevice(int[] forceSensorEnable, int[] gripperEnable, int[] IODeviceEnable) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        String paramStr = "";
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetAxleLuaEnableDevice", params);
            if ((Integer)result[0] == 0) {
                paramStr = (String)result[1];
                System.out.println("result str is " + paramStr);
                String[] parS = paramStr.split(",");
                if (parS.length != 24) {
                    this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "get segment weld point fail");
                    return -1;
                }
                forceSensorEnable[0] = Integer.parseInt(parS[0]);
                forceSensorEnable[1] = Integer.parseInt(parS[1]);
                forceSensorEnable[2] = Integer.parseInt(parS[2]);
                forceSensorEnable[3] = Integer.parseInt(parS[3]);
                forceSensorEnable[4] = Integer.parseInt(parS[4]);
                forceSensorEnable[5] = Integer.parseInt(parS[5]);
                forceSensorEnable[6] = Integer.parseInt(parS[6]);
                forceSensorEnable[7] = Integer.parseInt(parS[7]);
                gripperEnable[0] = Integer.parseInt(parS[8]);
                gripperEnable[1] = Integer.parseInt(parS[9]);
                gripperEnable[2] = Integer.parseInt(parS[10]);
                gripperEnable[3] = Integer.parseInt(parS[11]);
                gripperEnable[4] = Integer.parseInt(parS[12]);
                gripperEnable[5] = Integer.parseInt(parS[13]);
                gripperEnable[6] = Integer.parseInt(parS[14]);
                gripperEnable[7] = Integer.parseInt(parS[15]);
                IODeviceEnable[0] = Integer.parseInt(parS[16]);
                IODeviceEnable[1] = Integer.parseInt(parS[17]);
                IODeviceEnable[2] = Integer.parseInt(parS[18]);
                IODeviceEnable[3] = Integer.parseInt(parS[19]);
                IODeviceEnable[4] = Integer.parseInt(parS[20]);
                IODeviceEnable[5] = Integer.parseInt(parS[21]);
                IODeviceEnable[6] = Integer.parseInt(parS[22]);
                IODeviceEnable[7] = Integer.parseInt(parS[23]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetAxleLuaEnableDevice(" + paramStr + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetAxleLuaGripperFunc(int id, int[] func) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] funcs = new Object[]{func[0], func[1], func[2], func[3], func[4], func[5], func[6], func[7], func[8], func[9], func[10], func[11], func[12], func[13], func[14], func[15]};
            Object[] params = new Object[]{id, funcs};
            int rtn = (Integer)this.client.execute("SetAxleLuaGripperFunc", params);
            if (this.log != null) {
                this.log.LogInfo("SetAxleLuaGripperFunc(" + id + "," + Arrays.toString(func) + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetAxleLuaGripperFunc(int id, int[] func) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        String paramStr = "";
        try {
            Object[] params = new Object[]{id};
            Object[] result = (Object[])this.client.execute("GetAxleLuaGripperFunc", params);
            if ((Integer)result[0] == 0) {
                paramStr = (String)result[1];
                String[] parS = paramStr.split(",");
                if (parS.length != 16) {
                    this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "get segment weld point fail");
                    return -1;
                }
                func[0] = Integer.parseInt(parS[0]);
                func[1] = Integer.parseInt(parS[1]);
                func[2] = Integer.parseInt(parS[2]);
                func[3] = Integer.parseInt(parS[3]);
                func[4] = Integer.parseInt(parS[4]);
                func[5] = Integer.parseInt(parS[5]);
                func[6] = Integer.parseInt(parS[6]);
                func[7] = Integer.parseInt(parS[7]);
                func[8] = Integer.parseInt(parS[8]);
                func[9] = Integer.parseInt(parS[9]);
                func[10] = Integer.parseInt(parS[10]);
                func[11] = Integer.parseInt(parS[11]);
                func[12] = Integer.parseInt(parS[12]);
                func[13] = Integer.parseInt(parS[13]);
                func[14] = Integer.parseInt(parS[14]);
                func[15] = Integer.parseInt(parS[15]);
            }
            if (this.log != null) {
                this.log.LogInfo("GetAxleLuaGripperFunc(" + paramStr + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public List<Number> GetGripperRotNum() {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.set(0, this.sockErr);
        if (this.IsSockComError()) {
            return rtnArray;
        }
        try {
            ROBOT_STATE_PKG pkg = this.GetRobotRealTimeState();
            rtnArray.set(1, Integer.valueOf(pkg.gripper_fault));
            rtnArray.set(2, Double.valueOf(pkg.gripperRotNum));
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public List<Number> GetGripperRotSpeed() {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.set(0, this.sockErr);
        if (this.IsSockComError()) {
            return rtnArray;
        }
        try {
            ROBOT_STATE_PKG pkg = this.GetRobotRealTimeState();
            rtnArray.set(1, Integer.valueOf(pkg.gripper_fault));
            rtnArray.set(2, pkg.gripperRotSpeed);
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public List<Number> GetGripperRotTorque() {
        ArrayList<Number> rtnArray = new ArrayList<Number>(){};
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.add(-1);
        rtnArray.set(0, this.sockErr);
        if (this.IsSockComError()) {
            return rtnArray;
        }
        try {
            ROBOT_STATE_PKG pkg = this.GetRobotRealTimeState();
            rtnArray.set(1, Integer.valueOf(pkg.gripper_fault));
            rtnArray.set(2, pkg.gripperRotTorque);
            return rtnArray;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            rtnArray.set(0, -4);
            return rtnArray;
        }
    }

    public int PtpFIRPlanningStart(double maxAcc) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{maxAcc};
            int rtn = (Integer)this.client.execute("PtpFIRPlanningStart", params);
            if (this.log != null) {
                this.log.LogInfo("PtpFIRPlanningStart(" + maxAcc + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int PtpFIRPlanningEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("PtpFIRPlanningEnd", params);
            if (this.log != null) {
                this.log.LogInfo("PtpFIRPlanningEnd() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int TrajectoryJUpLoad(String filePath) {
        return this.FileUpLoad(20, filePath);
    }

    public int TrajectoryJDelete(String fileName) {
        return this.FileDelete(20, fileName);
    }

    public int LinArcFIRPlanningStart(double maxAccLin, double maxAccDeg, double maxJerkLin, double maxJerkDeg) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{maxAccLin, maxAccDeg, maxJerkLin, maxJerkDeg};
            int rtn = (Integer)this.client.execute("LinArcFIRPlanningStart", params);
            if (this.log != null) {
                this.log.LogInfo("LinArcFIRPlanningStart(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LinArcFIRPlanningEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("LinArcFIRPlanningEnd", params);
            if (this.log != null) {
                this.log.LogInfo("LinArcFIRPlanningEnd(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetCtrlOpenLUAName(int id, String name) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, name};
            int rtn = (Integer)this.client.execute("SetCtrlOpenLUAName", params);
            if (this.log != null) {
                this.log.LogInfo("SetCtrlOpenLUAName(" + id + "," + name + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetCtrlOpenLUAName(String[] name) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        String paramStr = "";
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetCtrlOpenLUAName", params);
            if ((Integer)result[0] == 0) {
                paramStr = (String)result[1];
                String[] parS = paramStr.split(",");
                if (parS.length != 16) {
                    this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "get segment weld point fail");
                    return -1;
                }
                name[0] = parS[0];
                name[1] = parS[1];
                name[2] = parS[2];
                name[3] = parS[3];
            }
            if (this.log != null) {
                this.log.LogInfo("GetCtrlOpenLUAName(" + paramStr + ") : " + (Integer)result[0]);
            }
            return (Integer)result[0];
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int LoadCtrlOpenLUA(int id) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id};
            int rtn = (Integer)this.client.execute("LoadCtrlOpenLUA", params);
            if (this.log != null) {
                this.log.LogInfo("LoadCtrlOpenLUA(" + id + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int UnloadCtrlOpenLUA(int id) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id};
            int rtn = (Integer)this.client.execute("UnloadCtrlOpenLUA", params);
            if (this.log != null) {
                this.log.LogInfo("UnloadCtrlOpenLUA(" + id + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    private int SetCtrlOpenLuaErrCode(int id, int code) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{id, code};
            int rtn = (Integer)this.client.execute("SetCtrlOpenLuaErrCode", params);
            if (this.log != null) {
                this.log.LogInfo("SetCtrlOpenLuaErrCode(" + id + "," + code + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SlaveFileWrite(int type, int slaveID, String fileName) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{type, slaveID, fileName};
            int rtn = (Integer)this.client.execute("SlaveFileWrite", params);
            if (this.log != null) {
                this.log.LogInfo("SlaveFileWrite(" + type + "," + slaveID + "," + fileName + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetSysServoBootMode() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("SetSysServoBootMode", params);
            if (this.log != null) {
                this.log.LogInfo("SetSysServoBootMode() : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int AxleLuaUpload(String filePath) {
        try {
            File fileInfo = new File(filePath);
            if (!fileInfo.exists()) {
                return -7;
            }
            int rtn = this.FileUpLoad(10, filePath);
            if (rtn == 0) {
                String fileName = "/tmp/" + fileInfo.getName();
                rtn = this.SetAxleFileType(2);
                if (rtn != 0) {
                    return -1;
                }
                rtn = this.SetSysServoBootMode();
                if (rtn != 0) {
                    return -1;
                }
                rtn = this.SlaveFileWrite(1, 7, fileName);
                if (rtn != 0) {
                    return -1;
                }
                return 0;
            }
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "LuaUpLoadFail(" + filePath + ") : " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            return -1;
        }
    }

    public int TractorEnable(Boolean enable) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        int int_enable = enable != false ? 1 : 0;
        try {
            Object[] params = new Object[]{int_enable};
            int rtn = (Integer)this.client.execute("TractorEnable", params);
            if (this.log != null) {
                this.log.LogInfo("TractorEnable(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int TractorHoming() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("TractorHoming", params);
            if (this.log != null) {
                this.log.LogInfo("TractorHoming(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int TractorMoveL(double distance, double vel) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{distance, vel};
            int rtn = (Integer)this.client.execute("TractorMoveL", params);
            if (this.log != null) {
                this.log.LogInfo("TractorMoveL(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int TractorMoveC(double radio, double angle, double vel) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{radio, angle, vel};
            int rtn = (Integer)this.client.execute("TractorMoveC", params);
            if (this.log != null) {
                this.log.LogInfo("TractorMoveC(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int TractorStop() {
        int rtn = this.ProgramStop();
        return rtn;
    }

    public int SetWireSearchExtDIONum(int searchDoneDINum, int searchStartDONum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{searchDoneDINum, searchStartDONum};
            int rtn = (Integer)this.client.execute("SetWireSearchExtDIONum", params);
            if (this.log != null) {
                this.log.LogInfo("SetWireSearchExtDIONum(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetWeldMachineCtrlModeExtDoNum(int DONum) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{DONum};
            int rtn = (Integer)this.client.execute("SetWeldMachineCtrlModeExtDoNum", params);
            if (this.log != null) {
                this.log.LogInfo("SetWeldMachineCtrlModeExtDoNum(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SetWeldMachineCtrlMode(int mode) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{mode};
            int rtn = (Integer)this.client.execute("SetWeldMachineCtrlMode", params);
            if (this.log != null) {
                this.log.LogInfo("SetWeldMachineCtrlMode(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SingularAvoidStart(int protectMode, double minShoulderPos, double minElbowPos, double minWristPos) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{protectMode, minShoulderPos, minElbowPos, minWristPos};
            int rtn = (Integer)this.client.execute("SingularAvoidStart", params);
            if (this.log != null) {
                this.log.LogInfo("SingularAvoidStart(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int SingularAvoidEnd() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            Object[] params = new Object[]{};
            int rtn = (Integer)this.client.execute("SingularAvoidEnd", params);
            if (this.log != null) {
                this.log.LogInfo("SingularAvoidEnd(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int RbLogDownload(String savePath) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        int errcode = 0;
        try {
            Object[] params = new Object[]{};
            errcode = (Integer)this.client.execute("RbLogDownloadPrepare", params);
            if (this.log != null) {
                this.log.LogInfo("RbLogDownloadPrepare(): " + errcode);
            }
            if (errcode != 0) {
                this.log.LogInfo("RbLogDownloadPrepare fail.");
                return errcode;
            }
            this.log.LogInfo("RbLogDownloadPrepare success.");
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
        String fileName = "rblog.tar.gz";
        errcode = this.FileDownLoad(1, fileName, savePath);
        return errcode;
    }

    public int AllDataSourceDownload(String savePath) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        int errcode = 0;
        try {
            Object[] params = new Object[]{};
            errcode = (Integer)this.client.execute("AllDataSourceDownloadPrepare", params);
            if (this.log != null) {
                this.log.LogInfo("AllDataSourceDownloadPrepare(): " + errcode);
            }
            if (errcode != 0) {
                this.log.LogInfo("AllDataSourceDownloadPrepare fail.");
                return errcode;
            }
            this.log.LogInfo("AllDataSourceDownloadPrepare success.");
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
        String fileName = "alldatasource.tar.gz";
        errcode = this.FileDownLoad(2, fileName, savePath);
        return errcode;
    }

    public int DataPackageDownload(String savePath) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        int errcode = 0;
        try {
            Object[] params = new Object[]{};
            errcode = (Integer)this.client.execute("DataPackageDownloadPrepare", params);
            if (this.log != null) {
                this.log.LogInfo("DataPackageDownloadPrepare(): " + errcode);
            }
            if (errcode != 0) {
                this.log.LogInfo("DataPackageDownloadPrepare fail.");
                return errcode;
            }
            this.log.LogInfo("DataPackageDownloadPrepare success.");
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
        String fileName = "fr_user_data.tar.gz";
        errcode = this.FileDownLoad(3, fileName, savePath);
        return errcode;
    }

    public int GetRobotSN(String[] SNCode) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        int errcode = 0;
        try {
            Object[] params = new Object[]{};
            Object[] result = (Object[])this.client.execute("GetRobotSN", params);
            errcode = (Integer)result[0];
            if (this.log != null) {
                this.log.LogInfo("GetRobotSN(): " + errcode);
            }
            if (0 == errcode) {
                SNCode[0] = (String)result[1];
            }
            return errcode;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ShutDownRobotOS() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        int errcode = 0;
        try {
            Object[] params = new Object[]{};
            errcode = (Integer)this.client.execute("ShutDownRobotOS", params);
            if (this.log != null) {
                this.log.LogInfo("ShutDownRobotOS(): " + errcode);
            }
            return errcode;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int GetSafetyCode() {
        ROBOT_STATE_PKG pkg = this.GetRobotRealTimeState();
        if (pkg.safety_stop0_state == 1 || pkg.safety_stop1_state == 1) {
            return 99;
        }
        return 0;
    }

    public int AccSmoothStart(boolean saveFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        int errcode = 0;
        try {
            int flag = saveFlag ? 1 : 0;
            Object[] params = new Object[]{flag};
            errcode = (Integer)this.client.execute("AccSmoothStart", params);
            if (this.log != null) {
                this.log.LogInfo("AccSmoothStart(): " + errcode);
            }
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
        ROBOT_STATE_PKG pkg = this.GetRobotRealTimeState();
        if ((pkg.main_code != 0 || pkg.sub_code != 0) && errcode == 0) {
            errcode = 14;
        }
        return errcode;
    }

    public int AccSmoothEnd(boolean saveFlag) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            int flag = saveFlag ? 1 : 0;
            Object[] params = new Object[]{flag};
            int rtn = (Integer)this.client.execute("AccSmoothEnd", params);
            if (this.log != null) {
                this.log.LogInfo("AccSmoothEnd(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorComDetect(int timeout) {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        if (this.GetSafetyCode() != 0) {
            return this.GetSafetyCode();
        }
        try {
            Object[] params = new Object[]{timeout};
            int rtn = (Integer)this.client.execute("ConveryComDetect", params);
            if (this.log != null) {
                this.log.LogInfo("ConveryComDetect(): " + rtn);
            }
            return rtn;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public int ConveyorComDetectTrigger() {
        if (this.IsSockComError()) {
            return this.sockErr;
        }
        try {
            int errcode = 0;
            while (this.isSendCmd) {
                Thread.sleep(10L);
            }
            this.sendBuf = "/f/bIII" + cnt + "III1149III25IIIConveryComDetectTrigger()III/b/f";
            System.out.println(this.sendBuf);
            this.clientCmd.Send(this.sendBuf);
            byte[] recvBuf = new byte[1024];
            this.clientCmd.Recv(recvBuf);
            this.isSendCmd = true;
            System.out.println("ConveryComDetectTrigger() executed. Count: " + ++cnt);
            if (this.log != null) {
                this.log.LogInfo("ConveryComDetectTrigger(): " + errcode);
            }
            return errcode;
        }
        catch (Throwable e) {
            if (this.log != null) {
                this.log.LogError(Thread.currentThread().getStackTrace()[1].getMethodName(), Thread.currentThread().getStackTrace()[1].getLineNumber(), "RPC exception " + e.getMessage());
            }
            return -4;
        }
    }

    public byte[] subByte(byte[] b, int off, int length) {
        byte[] b1 = new byte[length];
        System.arraycopy(b, off, b1, 0, length);
        return b1;
    }

    public static char[] getChars(byte[] bytes) {
        Charset cs = Charset.forName("UTF-8");
        ByteBuffer bb = ByteBuffer.allocate(bytes.length);
        bb.put(bytes).flip();
        CharBuffer cb = cs.decode(bb);
        return cb.array();
    }

    public void Sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception e) {
            System.out.println("Got an exception in Sleep!  :  " + e.getMessage());
        }
    }
}

