#!/bin/sh

USER_FILE="/tmp/controller/user.config"
EX_DEVICE_FILE="/tmp/controller/ex_device.config"
EXAXIS_FILE="/tmp/controller/exaxis.config"
ROBOT_FILE="/tmp/controller/robot.config"
DHPARA_FILE="/tmp/controller/dhpara.config"

echo upgrade_process = 40

sync

#web升级
#免密解压
tar -zxf /tmp/software/web.tar.gz -C /tmp/
#加密解压
#openssl des3 -d -k frweb -salt -in /tmp/software/web.tar.gz | tar xzvf - -C /tmp/

#清除前次升级缓存
rm -r /usr/local/etc/tmp

#web相关
sh /tmp/web/shell/fr_upgrade_web.sh
sync

echo upgrade_process = 60

#controller相关so
echo "##### Uncompress fr_control upgrade file";
tar -zxf /tmp/software/controller.tar.gz -C /tmp/

# 检查user.config文件是否存在
if [ ! -f $USER_FILE ]; then
    # 文件不存在，升级失败

	echo upgrade_process = -5
    exit 1
fi
if [ ! -f $EX_DEVICE_FILE ]; then
    # 文件不存在，升级失败

	echo upgrade_process = -6
    exit 1
fi
if [ ! -f $EXAXIS_FILE ]; then
    # 文件不存在，升级失败

	echo upgrade_process = -7
    exit 1
fi
if [ ! -f $ROBOT_FILE ]; then
    # 文件不存在，升级失败

	echo upgrade_process = -8
    exit 1
fi
if [ ! -f $DHPARA_FILE ]; then
    # 文件不存在，升级失败

	echo upgrade_process = -9
    exit 1
fi

sh /tmp/web/shell/fr_upgrade_control.sh
sync
echo upgrade_process = 70

#mv /tmp/fr_control /tmp/robot

#目录版本管控
sh /tmp/web/shell/fr_upgrade_file.sh 1
sync
echo upgrade_process = 75

#config、db文件版本管控
sh /tmp/web/shell/fr_upgrade_file.sh 2
sync
echo upgrade_process = 80

sh /tmp/web/shell/frinit_upgrade.sh
sync
sh /tmp/web/shell/webrecovery_upgrade.sh
sync
echo upgrade_process = 90

# 创建标志 “升级成功” 的文件
touch /usr/local/etc/upgrade_success.txt
sync

sleep 2

wait
exit 0